/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour;

import com.sixtyfour.Logger;
import com.sixtyfour.ProgramExecutor;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.mnemonics.Mnemonic;
import com.sixtyfour.parser.assembly.AssemblyParser;
import com.sixtyfour.parser.assembly.ConstantValue;
import com.sixtyfour.parser.assembly.ConstantsContainer;
import com.sixtyfour.parser.assembly.LabelAndCode;
import com.sixtyfour.parser.assembly.LabelsContainer;
import com.sixtyfour.system.Cpu;
import com.sixtyfour.system.Machine;
import com.sixtyfour.system.Program;
import com.sixtyfour.system.ProgramPart;
import com.sixtyfour.util.MemoryException;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class Assembler
implements ProgramExecutor {
    private String[] code = null;
    private int codeStart = -1;
    private int startAddr = 0;
    private Machine machine = null;
    private Program program = null;
    private boolean running = false;
    private Map<Integer, String> addr2code = new HashMap<Integer, String>();

    public Assembler(String code) {
        this(code.split("\n"));
    }

    public Assembler(String[] code) {
        this(code, null);
    }

    public Assembler(List<String> code) {
        this(code.toArray(new String[code.size()]), null);
    }

    public Assembler(String code, Machine machine) {
        this(code.split("\n"), machine);
    }

    public Assembler(String[] code, Machine machine) {
        this.code = Arrays.copyOf(code, code.length);
        this.machine = machine == null ? new Machine() : machine;
    }

    @Override
    public void compile(CompilerConfig config) {
        Logger.log("Running assembler...");
        Machine compileMachine = new Machine();
        ConstantsContainer ccon = new ConstantsContainer();
        LabelsContainer lcon = new LabelsContainer(compileMachine);
        int addr = 0;
        int cnt = 0;
        long startTime = System.nanoTime();
        ArrayList<Integer> lineBreaks = new ArrayList<Integer>();
        Program prg = new Program();
        prg.setLabelsContainer(lcon);
        boolean initial = true;
        HashSet<Integer> usedAddrs = new HashSet<Integer>();
        boolean skipMode = false;
        String[] stringArray = this.code;
        int n = this.code.length;
        int n2 = 0;
        while (n2 < n) {
            String line;
            String oLine = line = stringArray[n2];
            ++cnt;
            if (!(line = line.replace('\t', ' ').trim()).startsWith(";")) {
                String lline = (line = AssemblyParser.truncateComments(line)).toLowerCase(Locale.ENGLISH);
                if (lline.contains("<if ")) {
                    String cond = line.substring(4);
                    int pos = cond.indexOf(">");
                    if (pos != -1) {
                        cond = cond.substring(0, pos);
                        skipMode = (cond = cond.trim()).startsWith("!") ? ccon.get(cond.substring(1)) != null : ccon.get(cond) == null;
                    }
                } else if (skipMode) {
                    if (lline.contains("</if>")) {
                        skipMode = false;
                    }
                } else if (!lline.contains("</if>") && line.length() != 0) {
                    ConstantValue cv = AssemblyParser.getConstant(config, line, ccon);
                    if (cv != null) {
                        ccon.put(cv);
                        if (cv.getName().equals("*")) {
                            if (initial) {
                                initial = false;
                            } else {
                                ProgramPart part = new ProgramPart();
                                part.setAddress(this.startAddr);
                                part.setEndAddress(addr);
                                part.setLineAddresses(this.createAndResetOpas(lineBreaks));
                                prg.addPart(part);
                            }
                            this.startAddr = addr = cv.getValue();
                        }
                    } else {
                        boolean isData = line.startsWith(".");
                        if (!isData) {
                            Mnemonic mne = AssemblyParser.getMnemonic(config, line);
                            if (mne == null) {
                                LabelAndCode lac = AssemblyParser.getLabel(line);
                                if (lac != null) {
                                    if (lac.getCode().startsWith(".")) {
                                        isData = true;
                                    } else {
                                        mne = AssemblyParser.getMnemonic(config, lac.getCode());
                                    }
                                    lcon.put(lac.getLabel(), addr);
                                    ConstantValue cvl = AssemblyParser.getConstant(config, String.valueOf(lac.getLabel()) + "=" + addr, ccon);
                                    ccon.put(cvl);
                                    line = lac.getCode();
                                } else {
                                    this.raiseError("Syntax error at: " + oLine + "/" + addr, addr, cnt);
                                }
                            }
                            if (!isData) {
                                if (mne != null) {
                                    if (this.codeStart == -1) {
                                        this.codeStart = addr;
                                    }
                                    try {
                                        lineBreaks.add(addr);
                                        this.addr2code.put(addr, line);
                                        int oldAddr = addr;
                                        addr = mne.parse(config, line, addr, compileMachine, ccon, lcon);
                                        this.flagAddress(usedAddrs, oldAddr, addr);
                                    }
                                    catch (RuntimeException re) {
                                        this.raiseError("Error at line: " + oLine, re, addr, cnt);
                                    }
                                } else if (!line.trim().isEmpty()) {
                                    this.raiseError("Unknown mnemonic in: " + oLine, addr, cnt);
                                }
                            }
                        }
                        if (isData) {
                            String lineUpper = VarUtils.toUpper(line.trim());
                            int[] data = AssemblyParser.getBinaryData(config, addr, line, ccon, lcon);
                            lineBreaks.add(addr);
                            if (addr + data.length > compileMachine.getRam().length) {
                                this.raiseError("Out of target memory: " + data.length, addr, cnt);
                            }
                            System.arraycopy(data, 0, compileMachine.getRam(), addr, data.length);
                            if (lineUpper.startsWith(".STRG")) {
                                compileMachine.getRam()[addr - 1] = data.length;
                            }
                            int oldAddr = addr;
                            this.flagAddress(usedAddrs, oldAddr, addr += data.length);
                        }
                    }
                }
            }
            ++n2;
        }
        ccon.applyDelayedData(compileMachine);
        if (lcon.hasDelayedLabels()) {
            this.raiseError("Undefined label: " + lcon.getFirstDelayedLabel(), addr, cnt);
        }
        if (addr != this.startAddr) {
            ProgramPart part = new ProgramPart();
            part.setAddress(this.startAddr);
            part.setEndAddress(addr);
            part.setLineAddresses(this.createAndResetOpas(lineBreaks));
            prg.addPart(part);
        }
        for (ProgramPart part : prg.getParts()) {
            part.setBytes(Arrays.copyOfRange(compileMachine.getRam(), part.getAddress(), part.getEndAddress()));
        }
        prg.setCodeStart(this.codeStart == -1 ? this.startAddr : this.codeStart);
        this.program = prg;
        int i = 0;
        while (i < prg.getParts().size()) {
            ProgramPart pp = prg.getParts().get(i);
            String start = this.getHex(pp.getAddress());
            String end = this.getHex(pp.getEndAddress());
            Logger.log("Part " + i + ": " + start + " - " + end);
            ++i;
        }
        Logger.log(String.valueOf(cnt) + " lines compiled in: " + (System.nanoTime() - startTime) / 1000000L + "ms");
    }

    @Override
    public void run(CompilerConfig config) {
        if (this.program == null) {
            this.compile(config);
        }
        Cpu cpu = this.machine.getCpu();
        cpu.setPaused(false);
        cpu.reset();
        this.running = true;
        cpu.execute(this.program);
        this.running = false;
    }

    @Override
    public void start(CompilerConfig config) {
        if (this.program == null) {
            throw new RuntimeException("Program hasn't been compiled!");
        }
        Cpu cpu = this.machine.getCpu();
        cpu.setPaused(false);
        this.running = true;
        cpu.execute(this.program);
        this.running = false;
    }

    @Override
    public Machine getMachine() {
        return this.machine;
    }

    @Override
    public Cpu getCpu() {
        return this.machine.getCpu();
    }

    @Override
    public int[] getRam() {
        return this.machine.getRam();
    }

    @Override
    public void runStop() {
        this.machine.getCpu().stop();
    }

    public Program getProgram() {
        return this.program;
    }

    public String getCodeLine(int addr) {
        return this.addr2code.get(addr);
    }

    public void setProgram(Program program) {
        this.program = program;
    }

    public String toString() {
        if (this.program == null) {
            return "";
        }
        Program prg = this.program;
        StringBuilder sb = new StringBuilder();
        int cnt = 1;
        for (ProgramPart part : prg.getParts()) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append("Part: " + cnt++);
            int start = part.getAddress();
            int lineIndex = 0;
            int i = start;
            while (i < start + part.getBytes().length) {
                int val;
                String num;
                if (lineIndex < part.getLineAddresses().length && i == part.getLineAddresses()[lineIndex]) {
                    ++lineIndex;
                    sb.append("\n");
                    sb.append("." + Integer.toString(i, 16));
                    sb.append("\t");
                }
                if ((num = Integer.toString(val = AssemblyParser.getLowByte(part.getBytes()[i - start]), 16)).length() == 1) {
                    num = "0" + num;
                }
                sb.append(num).append(" ");
                ++i;
            }
        }
        return sb.toString();
    }

    private int[] createAndResetOpas(List<Integer> lineBreaks) {
        int[] opas = new int[lineBreaks.size()];
        int c = 0;
        for (Integer i : lineBreaks) {
            opas[c++] = i;
        }
        lineBreaks.clear();
        return opas;
    }

    private void raiseError(String txt, Throwable t, int addr, int cnt) {
        throw new RuntimeException("Line " + cnt + "\t." + Integer.toHexString(addr) + "\t" + txt, t);
    }

    private void raiseError(String txt, int addr, int cnt) {
        throw new RuntimeException("Line " + cnt + "\t." + Integer.toHexString(addr) + "\t" + txt);
    }

    private String getHex(int inty) {
        String p = Integer.toHexString(inty);
        if (p.length() < 4) {
            p = String.valueOf("000".substring(0, 4 - p.length())) + p;
        }
        return "$" + p;
    }

    private void flagAddress(Set<Integer> used, int start, int endExcl) {
        int i = start;
        while (i < endExcl) {
            if (used.contains(i)) {
                throw new MemoryException("Overlapping memory addresses @ $" + Integer.toHexString(i));
            }
            used.add(i);
            ++i;
        }
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }
}

