/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour;

import com.sixtyfour.Logger;
import com.sixtyfour.ProgramExecutor;
import com.sixtyfour.Tracer;
import com.sixtyfour.cbmnative.PCode;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.config.LoopMode;
import com.sixtyfour.config.MemoryConfig;
import com.sixtyfour.elements.commands.Assignment;
import com.sixtyfour.elements.commands.Command;
import com.sixtyfour.elements.commands.CommandList;
import com.sixtyfour.elements.commands.For;
import com.sixtyfour.elements.commands.Let;
import com.sixtyfour.elements.commands.Next;
import com.sixtyfour.elements.commands.Rem;
import com.sixtyfour.elements.commands.internal.Delay;
import com.sixtyfour.elements.functions.FunctionList;
import com.sixtyfour.extensions.BasicExtension;
import com.sixtyfour.parser.Line;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.TermEnhancer;
import com.sixtyfour.plugins.CodeEnhancer;
import com.sixtyfour.plugins.InputProvider;
import com.sixtyfour.plugins.MemoryListener;
import com.sixtyfour.plugins.OutputChannel;
import com.sixtyfour.plugins.SystemCallListener;
import com.sixtyfour.system.Cpu;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.Jit;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class Basic
implements ProgramExecutor {
    private String[] code = null;
    private Map<Integer, Line> lines = new HashMap<Integer, Line>();
    private List<Integer> lineNumbers = new ArrayList<Integer>();
    private Machine machine = null;
    private boolean compiled = false;
    private boolean stop = false;
    private boolean printLineNumbers = false;
    private boolean paused;
    private boolean running;
    private Tracer tracer = null;
    private static Map<String, BasicExtension> addedExtensions = new HashMap<String, BasicExtension>();
    private CodeEnhancer codeEnhancer;

    public Basic(String code) {
        this(code.split("\n"));
    }

    public Basic(String code, Machine machine) {
        this(code.split("\n"), machine);
    }

    public Basic(String[] code) {
        this(code, null);
    }

    public Basic(String[] code, Machine machine) {
        this.code = Arrays.copyOf(code, code.length);
        this.machine = machine == null ? new Machine() : machine;
    }

    public void enableJit() {
        this.machine.setJit(new Jit());
    }

    public void enableJit(int compileThreshold) {
        this.machine.setJit(new Jit(compileThreshold));
    }

    public static void registerExtension(BasicExtension extension) {
        String name = extension.getClass().getName();
        if (!addedExtensions.containsKey(name)) {
            addedExtensions.put(name, extension);
            Logger.log(String.valueOf(name) + " registered as a BASIC extension!");
            CommandList.registerNewCommands(extension.getCommands());
            FunctionList.registerNewFunctions(extension.getFunctions());
        }
    }

    public static void registerExtension(Class<? extends BasicExtension> clazz) {
        try {
            Basic.registerExtension(clazz.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to register extension " + clazz);
        }
    }

    public static List<BasicExtension> getExtensions() {
        if (addedExtensions.size() == 0) {
            return new ArrayList<BasicExtension>();
        }
        return new ArrayList<BasicExtension>(addedExtensions.values());
    }

    public String[] getCode() {
        return this.code;
    }

    @Override
    public Machine getMachine() {
        return this.machine;
    }

    public void setMachine(Machine machine) {
        this.machine = machine;
    }

    @Override
    public Cpu getCpu() {
        return this.machine.getCpu();
    }

    public PCode getPCode() {
        return new PCode(this.lineNumbers, this.lines);
    }

    public String getStringVariable(String name) {
        Object obj = this.machine.getVariable(VarUtils.toUpper(name)).getValue();
        if (VarUtils.isString(obj)) {
            return (String)obj;
        }
        return null;
    }

    public Integer getIntegerVariable(String name) {
        Object obj = this.machine.getVariable(VarUtils.toUpper(name)).getValue();
        if (VarUtils.isInteger(obj)) {
            return (Integer)obj;
        }
        return null;
    }

    public Float getFloatVariable(String name) {
        Object obj = this.machine.getVariable(VarUtils.toUpper(name)).getValue();
        if (VarUtils.isFloat(obj)) {
            return (Float)obj;
        }
        if (VarUtils.isDouble(obj)) {
            return new Float(((Double)obj).floatValue());
        }
        return null;
    }

    public Object[] getArrayVariable(String name) {
        Object obj;
        if (!name.endsWith("[]")) {
            name = String.valueOf(name) + "[]";
        }
        if ((obj = this.machine.getVariable(VarUtils.toUpper(name)).getValue()).getClass().isArray()) {
            return ((ArrayList)obj).toArray();
        }
        return null;
    }

    @Override
    public void compile(CompilerConfig config) {
        this.compile(config, true);
    }

    public void compile(CompilerConfig config, boolean resetMachine) {
        long start = System.nanoTime();
        if (resetMachine) {
            this.machine.resetMemory();
        }
        this.machine.clearCommandList();
        List<BasicExtension> exts = Basic.getExtensions();
        for (BasicExtension ext : exts) {
            this.machine.addSystemVariables(ext.getSystemVariables());
        }
        Line cl = null;
        int lastLineNumber = -1;
        this.lines.clear();
        this.lineNumbers.clear();
        String[] stringArray = this.code;
        int n = this.code.length;
        int n2 = 0;
        while (n2 < n) {
            block15: {
                String line = stringArray[n2];
                try {
                    line = line.replaceAll("^\\s+", "");
                    if (line.isEmpty()) break block15;
                    cl = Line.getLine(line);
                    if (this.lines.containsKey(cl.getNumber())) {
                        throw new RuntimeException("Duplicate line number in: " + line);
                    }
                    if (cl.getNumber() < 0 || cl.getNumber() < lastLineNumber) {
                        throw new RuntimeException("Faulty line number in: " + line);
                    }
                    lastLineNumber = cl.getNumber();
                    int lineCnt = this.lineNumbers.size();
                    cl.setCount(lineCnt);
                    this.lines.put(cl.getNumber(), cl);
                    this.lineNumbers.add(cl.getNumber());
                    boolean looseEnding = cl.getLine().trim().endsWith(":");
                    if (looseEnding) {
                        cl.addDummyRemark();
                    }
                    String[] parts = Parser.getParts(cl, this.machine);
                    int pos = 0;
                    String[] stringArray2 = parts;
                    int n3 = parts.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String part = stringArray2[n4];
                        int loops = 0;
                        do {
                            if (part.trim().length() > 0) {
                                Command command = Parser.getCommand(part);
                                if (command == null) {
                                    throw new RuntimeException("Syntax error: " + cl.getNumber() + " " + cl.getLine());
                                }
                                if (!command.keepSpaces()) {
                                    part = TermEnhancer.removeWhiteSpace(part);
                                }
                                part = command.parse(config, part, lineCnt, cl.getNumber(), pos, pos == parts.length - 1, this.machine);
                                this.machine.addCommand(command);
                                cl.addCommand(command);
                                if (command instanceof Assignment && loops > 0) {
                                    this.machine.trackVariableUsage(((Assignment)Assignment.class.cast(command)).getVar(), false);
                                }
                                ++pos;
                                ++loops;
                                if (!"###".equals(part)) continue;
                                break;
                            }
                            part = null;
                        } while (part != null);
                        if (!"###".equals(part)) {
                            ++n4;
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable t) {
                    String msg = t.getMessage();
                    String err = "Error in line " + (cl != null ? Integer.valueOf(cl.getNumber()) : "??") + (msg != null ? ": " + msg : "");
                    this.machine.getOutputChannel().systemPrintln(0, err);
                    throw t;
                }
            }
            ++n2;
        }
        this.modifyDelayLoops(config);
        this.compiled = true;
        Logger.log(String.valueOf(this.machine.getCommandList().size()) + " commands compiled in: " + (System.nanoTime() - start) / 1000000L + "ms");
    }

    @Override
    public void start(CompilerConfig config) {
        this.stop = false;
        if (!this.compiled) {
            throw new RuntimeException("Code not compiled! Either call compile();start(); or run()!");
        }
        this.runInternal(config);
    }

    @Override
    public void run(CompilerConfig config) {
        this.stop = false;
        if (!this.compiled) {
            this.compile(config);
        }
        if (this.compiled) {
            this.runInternal(config);
            this.compiled = false;
        } else {
            this.machine.getOutputChannel().systemPrintln(0, "\nREADY.");
        }
    }

    public void executeSingleCommand(CompilerConfig config, String cmd) {
        if (cmd == null || cmd.isEmpty()) {
            return;
        }
        Command command = Parser.getCommand(cmd.trim());
        if (command == null) {
            throw new RuntimeException("Syntax error: " + cmd);
        }
        if (!command.keepSpaces()) {
            cmd = TermEnhancer.removeWhiteSpace(cmd);
        }
        command.parse(config, cmd, 0, 0, 0, false, this.machine);
        command.execute(config, this.machine);
    }

    public void resetMemory() {
        this.machine.resetMemory();
    }

    @Override
    public void runStop() {
        this.paused = false;
        this.stop = true;
    }

    @Override
    public int[] getRam() {
        return this.machine.getRam();
    }

    public InputProvider getInputProvider() {
        return this.machine.getInputProvider();
    }

    public void setInputProvider(InputProvider inputProvider) {
        this.machine.setInputProvider(inputProvider);
    }

    public OutputChannel getOutputChannel() {
        return this.machine.getOutputChannel();
    }

    public void setOutputChannel(OutputChannel outputChannel) {
        this.machine.setOutputChannel(outputChannel);
    }

    public SystemCallListener getSystemCallListener() {
        return this.machine.getSystemCallListener();
    }

    public void setSystemCallListener(SystemCallListener scl) {
        this.machine.setSystemCallListener(scl);
    }

    public MemoryListener getMemoryListener() {
        return this.machine.getMemoryListener();
    }

    public void setMemoryListener(MemoryListener memoryListener) {
        this.machine.setMemoryListener(memoryListener);
    }

    public boolean isPrintLineNumbers() {
        return this.printLineNumbers;
    }

    public void setPrintLineNumbers(boolean printLineNumbers) {
        this.printLineNumbers = printLineNumbers;
    }

    public void setPause(boolean paused) {
        this.paused = paused;
    }

    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public void setTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    public CodeEnhancer getCodeEnhancer() {
        return this.codeEnhancer;
    }

    public void setCodeEnhancer(CodeEnhancer codeEnhancer) {
        this.codeEnhancer = codeEnhancer;
    }

    private void runInternal(CompilerConfig config) {
        String cmd;
        long start = System.nanoTime();
        if (this.codeEnhancer != null) {
            cmd = this.codeEnhancer.getFirstCommand();
            this.executeSingleCommand(config, cmd);
        }
        this.execute(config, 0, 0);
        if (this.codeEnhancer != null) {
            cmd = this.codeEnhancer.getLastCommand();
            this.executeSingleCommand(config, cmd);
        }
        long end = System.nanoTime();
        this.machine.getOutputChannel().systemPrintln(0, "\nREADY. (" + (end - start) / 1000000L + "ms)");
    }

    /*
     * Unable to fully structure code
     */
    private void execute(CompilerConfig config, int lineCnt, int pos) {
        if (this.lineNumbers.size() == 0) {
            return;
        }
        num = null;
        this.running = true;
        if (this.tracer != null) {
            this.tracer.start(this);
        }
        try {
            try {
                block7: do {
                    num = this.lineNumbers.get(lineCnt);
                    if (this.printLineNumbers) {
                        Logger.log("[" + num + "]");
                    }
                    line = this.lines.get(num);
                    i = pos;
                    while (i < line.getCommands().size()) {
                        if (!this.stop) ** GOTO lbl23
                        continue block7;
lbl-1000:
                        // 1 sources

                        {
                            try {
                                Thread.sleep(1L);
                                continue;
                            }
                            catch (InterruptedException var7_10) {
                                // empty catch block
                            }
lbl23:
                            // 3 sources

                            ** while (this.paused)
                        }
lbl24:
                        // 1 sources

                        command = line.getCommands().get(i);
                        this.machine.setCurrentCommand(command);
                        pc = command.execute(config, this.machine);
                        if (this.tracer != null) {
                            this.tracer.commandExecuted(this, command, num, i);
                        }
                        this.machine.setCurrentCommand(null);
                        if (pc != null) {
                            if (pc.isEnd() || pc.isStop()) {
                                lineCnt = this.lines.size();
                                if (!pc.isStop()) continue block7;
                                this.stop = true;
                                continue block7;
                            }
                            if (pc.isList()) {
                                var12_16 = this.code;
                                var11_15 = this.code.length;
                                var10_14 = 0;
                                while (var10_14 < var11_15) {
                                    cl = var12_16[var10_14];
                                    this.machine.getOutputChannel().systemPrintln(0, cl);
                                    ++var10_14;
                                }
                            } else {
                                if (pc.isSkip()) continue block7;
                                if (pc.getLineNumber() == -1) {
                                    lineCnt = pc.getLineCnt();
                                    num = this.lineNumbers.get(lineCnt);
                                    line = this.lines.get(num);
                                    i = pc.getLinePos();
                                    if (i >= line.getCommands().size() - 1) {
                                        num = this.lineNumbers.get(++lineCnt);
                                        line = this.lines.get(num);
                                        i = -1;
                                    }
                                } else {
                                    num = pc.getLineNumber();
                                    line = this.lines.get(num);
                                    i = -1;
                                    if (line == null) {
                                        throw new RuntimeException("Undef'd statement error: " + command);
                                    }
                                    lineCnt = line.getCount();
                                }
                            }
                        }
                        ++i;
                    }
                } while (++lineCnt < this.lines.size() && !this.stop);
                if (this.stop) {
                    this.machine.getOutputChannel().systemPrintln(0, "\nBREAK IN " + num);
                }
            }
            catch (Throwable t) {
                msg = t.getMessage();
                err = "Error in line " + (num != null ? num : "??") + (msg != null ? ": " + msg : "");
                this.machine.getOutputChannel().systemPrintln(0, err);
                this.running = false;
                throw t;
            }
        }
        finally {
            if (this.tracer != null) {
                this.tracer.stop(this);
            }
        }
        this.running = false;
    }

    public void modifyDelayLoops(CompilerConfig config) {
        LoopMode loopMode = config.getLoopMode();
        if (loopMode == null || loopMode == LoopMode.EXECUTE) {
            return;
        }
        int forLine = -1;
        int nextLine = -1;
        int forPos = -1;
        int nextPos = -1;
        Command forCmd = null;
        for (Integer num : this.lineNumbers) {
            Line line = this.lines.get(num);
            int cnt = 0;
            for (Command cmd : line.getCommands()) {
                if (forLine == -1) {
                    if (cmd instanceof For) {
                        forLine = num;
                        forPos = cnt;
                        forCmd = cmd;
                    }
                } else {
                    if (cmd instanceof Rem) continue;
                    if (cmd instanceof Next) {
                        nextLine = num;
                        nextPos = cnt;
                    } else {
                        forLine = -1;
                        nextLine = -1;
                        forPos = -1;
                        nextPos = -1;
                        forCmd = null;
                    }
                }
                if (forLine != -1 && nextLine != -1) {
                    this.lines.get(forLine).getCommands().set(forPos, new Delay((For)forCmd, loopMode == LoopMode.DELAY));
                    this.lines.get(nextLine).getCommands().set(nextPos, new Rem());
                    Logger.log("Replaced for-loop at line " + forLine + " with " + (loopMode == LoopMode.DELAY ? "a delay" : "an empty operation!"));
                    forLine = -1;
                    nextLine = -1;
                    forPos = -1;
                    nextPos = -1;
                    forCmd = null;
                }
                ++cnt;
            }
        }
    }

    public void removeCommands(List<Command> toRemove) {
        this.machine.removeCommands(toRemove);
        if (this.lines.isEmpty()) {
            return;
        }
        HashSet<Command> remSet = new HashSet<Command>(toRemove);
        Integer num = null;
        int lineCnt = 0;
        int pos = 0;
        do {
            num = this.lineNumbers.get(lineCnt);
            Line line = this.lines.get(num);
            List<Command> cmds = line.getCommands();
            int i = pos;
            while (i < cmds.size()) {
                Command cmd = cmds.get(i);
                if (remSet.contains(cmd)) {
                    cmds.set(i, new Rem());
                    Logger.log("Eliminated dead store to " + ((Let)cmd).getVar().getUpperCaseName() + " from line " + num);
                }
                ++i;
            }
        } while (++lineCnt < this.lines.size() && !this.stop);
    }

    public boolean adjustMemoryConfig(MemoryConfig config) {
        boolean adjusted = false;
        for (BasicExtension ext : Basic.getExtensions()) {
            adjusted |= ext.adjustMemoryConfig(this.machine, config);
        }
        return adjusted;
    }
}

