/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour;

import com.sixtyfour.Basic;
import com.sixtyfour.Tracer;
import com.sixtyfour.elements.commands.Command;
import com.sixtyfour.elements.commands.Get;
import com.sixtyfour.elements.commands.Input;
import com.sixtyfour.elements.commands.Wait;

public class DelayTracer
implements Tracer {
    private long commandsPerSecond = -1L;
    private long avgTicks = 0L;
    private long lastTicks = 0L;

    public DelayTracer(int commandsPerSecond) {
        this.commandsPerSecond = commandsPerSecond;
    }

    @Override
    public void commandExecuted(Basic basic, Command command, Integer lineNumber, int count) {
        if (this.commandsPerSecond <= 0L) {
            return;
        }
        long ticks = System.nanoTime();
        if (ticks - this.lastTicks < 0L || command instanceof Input || command instanceof Get || command instanceof Wait) {
            this.lastTicks = ticks;
        } else {
            if (this.avgTicks == 0L) {
                this.avgTicks = ticks - this.lastTicks;
            }
            this.avgTicks = this.avgTicks + (ticks - this.lastTicks) >> 1;
        }
        long waitTime = 1000000000L / this.commandsPerSecond - (ticks - this.lastTicks);
        if ((waitTime /= 1000000L) > 0L) {
            try {
                Thread.sleep(waitTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.lastTicks = System.nanoTime();
    }

    @Override
    public void start(Basic basic) {
        this.lastTicks = System.nanoTime();
        this.avgTicks = 0L;
    }

    @Override
    public void stop(Basic basic) {
    }
}

