/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.basicshell;

import com.sixtyfour.Assembler;
import com.sixtyfour.Basic;
import com.sixtyfour.Logger;
import com.sixtyfour.basicshell.ProgramStore;
import com.sixtyfour.basicshell.ResourceLoader;
import com.sixtyfour.basicshell.Runner;
import com.sixtyfour.basicshell.ShellTextComponent;
import com.sixtyfour.cbmnative.NativeCompiler;
import com.sixtyfour.cbmnative.mos6502.c64.Platform64;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.config.MemoryConfig;
import com.sixtyfour.system.FileWriter;
import com.sixtyfour.util.Colors;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;

public class BasicShell {
    static final ExecutorService executor = Executors.newFixedThreadPool(10);
    private final ArrayBlockingQueue<String> fromTextArea = new ArrayBlockingQueue(20);
    private final ArrayBlockingQueue<String> toTextArea = new ArrayBlockingQueue(20);
    private JTextArea mainTextArea;
    private JPanel panel1;
    private JButton stopButton;
    private JButton clsButton;
    private JButton runButton;
    private Runner runner = null;
    private ProgramStore store = new ProgramStore();
    private int[] lastStrLen = new int[2];
    private int rowNum;
    private int colNum;
    private JLabel caretLabel;

    public static void main(String[] unused) {
        System.setProperty("sun.java2d.d3d", "false");
        JFrame frame = new JFrame("Commodore BASIC V2");
        frame.setIconImage(ResourceLoader.getIcon());
        BasicShell shellFrame = new BasicShell();
        frame.setContentPane(shellFrame.panel1);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
        shellFrame.putString("COMMODORE BASIC V2\nREADY.\n");
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Thread.currentThread().setPriority(10);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        shellFrame.commandLoop();
    }

    int getPenultimateOutputSize() {
        return this.lastStrLen[0];
    }

    private BasicShell() {
        this.setupUI();
        this.mainTextArea.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                JTextArea editArea = (JTextArea)e.getSource();
                try {
                    int caretpos = editArea.getCaretPosition();
                    BasicShell.this.rowNum = editArea.getLineOfOffset(caretpos);
                    BasicShell.this.colNum = caretpos - editArea.getLineStartOffset(BasicShell.this.rowNum);
                    BasicShell.this.caretLabel.setText("  " + BasicShell.this.rowNum + " - " + BasicShell.this.colNum);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.mainTextArea.addKeyListener(new KeyAdapter(){
            private String lineContent = "";

            @Override
            public void keyReleased(KeyEvent e) {
                if (BasicShell.this.runner != null) {
                    BasicShell.this.runner.registerKey(null);
                }
                super.keyReleased(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (BasicShell.this.runner != null) {
                    BasicShell.this.runner.registerKey(Character.valueOf(e.getKeyChar()));
                }
                if (e.getKeyChar() == '\n') {
                    String nline;
                    String line;
                    this.lineContent = line = BasicShell.this.getLineAt(BasicShell.this.rowNum);
                    int end = BasicShell.this.mainTextArea.getText().length();
                    try {
                        end = BasicShell.this.mainTextArea.getLineEndOffset(BasicShell.this.rowNum);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    if (BasicShell.this.colNum < line.length()) {
                        BasicShell.this.mainTextArea.setCaretPosition(BasicShell.this.mainTextArea.getCaretPosition() + line.length() - BasicShell.this.colNum - 1);
                        if (end >= BasicShell.this.mainTextArea.getText().length()) {
                            BasicShell.this.mainTextArea.setCaretPosition(BasicShell.this.mainTextArea.getCaretPosition() + 1);
                        }
                    }
                    if (!(nline = BasicShell.this.getLineAt(BasicShell.this.rowNum + 1)).isEmpty()) {
                        String n1 = BasicShell.this.extractTrailingNumber(null, line);
                        String n2 = BasicShell.this.extractTrailingNumber(null, nline);
                        if (!n1.isEmpty() && !n2.isEmpty()) {
                            BasicShell.this.mainTextArea.setCaretPosition(BasicShell.this.mainTextArea.getCaretPosition() + 1);
                            e.consume();
                            return;
                        }
                    }
                }
                super.keyPressed(e);
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    try {
                        BasicShell.this.fromTextArea.put(this.lineContent);
                        this.lineContent = "";
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        });
        executor.execute(new Runnable(){

            @Override
            public void run() {
                int cnt = 0;
                while (true) {
                    try {
                        while (true) {
                            String s = (String)BasicShell.this.toTextArea.take();
                            BasicShell.this.mainTextArea.append(s);
                            BasicShell.this.mainTextArea.setCaretPosition(BasicShell.this.mainTextArea.getDocument().getLength());
                            if (BasicShell.this.runner != null && BasicShell.this.runner.getRunningBasic() != null && BasicShell.this.runner.getRunningBasic().isRunning() && cnt++ % 1000 == 0) {
                                Thread.sleep(1L);
                            }
                            Thread.yield();
                            if (BasicShell.this.mainTextArea.getText().length() <= 50000) continue;
                            BasicShell.this.mainTextArea.setText(BasicShell.this.mainTextArea.getText().substring(BasicShell.this.mainTextArea.getText().length() - 40000));
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Basic i;
                if (BasicShell.this.runner != null && (i = BasicShell.this.runner.getRunningBasic()) != null) {
                    i.runStop();
                }
                BasicShell.this.mainTextArea.requestFocus();
            }
        });
        this.clsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicShell.this.cls();
            }
        });
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicShell.this.run(false);
            }
        });
    }

    private void setupUI() {
        this.panel1 = new JPanel();
        this.panel1.setLayout(new BorderLayout(0, 0));
        JPanel panel2 = new JPanel();
        panel2.setLayout(new FlowLayout(0, 2, 2));
        panel2.setBackground(Color.BLACK);
        panel2.setPreferredSize(new Dimension(800, 34));
        this.panel1.add((Component)panel2, "South");
        this.stopButton = new JButton();
        this.stopButton.setText("STOP");
        this.stopButton.setPreferredSize(new Dimension(82, 30));
        panel2.add(this.stopButton);
        this.clsButton = new JButton();
        this.clsButton.setPreferredSize(new Dimension(82, 30));
        this.clsButton.setText("CLS");
        panel2.add(this.clsButton);
        this.runButton = new JButton();
        this.runButton.setPreferredSize(new Dimension(82, 30));
        this.runButton.setText("RUN");
        panel2.add(this.runButton);
        this.caretLabel = new JLabel();
        this.caretLabel.setPreferredSize(new Dimension(82, 30));
        this.caretLabel.setForeground(Color.pink);
        panel2.add(this.caretLabel);
        this.mainTextArea = new ShellTextComponent(this);
        this.mainTextArea.setCaretColor(new Color(Colors.COLORS[14]));
        JScrollPane scrollPane1 = new JScrollPane(this.mainTextArea);
        this.panel1.add((Component)scrollPane1, "Center");
        this.panel1.setPreferredSize(new Dimension(800, 600));
    }

    private String getLineAt(int linenum) {
        try {
            int start = this.mainTextArea.getLineStartOffset(linenum);
            int end = this.mainTextArea.getLineEndOffset(linenum);
            return this.mainTextArea.getText(start, end - start);
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    private void cls() {
        this.mainTextArea.setText("");
        this.mainTextArea.requestFocus();
    }

    private void run(boolean sync) {
        this.runner = new Runner(this.store.toArray(), this);
        this.runner.start(sync);
        this.mainTextArea.requestFocus();
    }

    private void dir() {
        File[] filesInFolder = new File(".").listFiles();
        if (filesInFolder != null) {
            File[] fileArray = filesInFolder;
            int n = filesInFolder.length;
            int n2 = 0;
            while (n2 < n) {
                File fileEntry = fileArray[n2];
                if (fileEntry.isFile()) {
                    this.putString(String.valueOf(fileEntry.getName()) + " -- " + fileEntry.length() + '\n');
                }
                ++n2;
            }
        }
    }

    public void putString(String outText) {
        try {
            this.toTextArea.put(outText);
            this.lastStrLen[0] = this.lastStrLen[1];
            this.lastStrLen[1] = outText.length();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void putStringUCase(String outText) {
        this.putString(outText.toUpperCase());
    }

    private void commandLoop() {
        block2: while (true) {
            String msg;
            String s;
            String sl;
            if ((sl = (s = this.getString()).toLowerCase()).startsWith("load") || sl.startsWith("save") || sl.startsWith("compile")) {
                int pos = s.indexOf("\"");
                if (pos != -1) {
                    s = String.valueOf(s.substring(0, pos)) + s.substring(pos).replace(" ", "_");
                }
                s = s.replace("\"", " ").replaceAll("\\s{2,}", " ").trim();
            }
            String[] split = s.split(" ");
            if (sl.startsWith("list")) {
                if ((sl = sl.trim()).length() == 4) {
                    this.putString(this.store.toString());
                    continue;
                }
                String[] lines = this.store.toArray();
                String p2 = sl.substring(4).trim();
                String[] ps = p2.split("-");
                int start = 0;
                int end = lines.length;
                if (ps.length == 1) {
                    if (p2.startsWith("-")) {
                        end = this.findLine(lines, ps[0], true);
                    } else {
                        start = this.findLine(lines, ps[0], false);
                        if (!p2.endsWith("-")) {
                            end = start;
                        }
                    }
                } else {
                    start = this.findLine(lines, ps[0], false);
                    end = this.findLine(lines, ps[1], true);
                }
                if (start > end || start < 0) continue;
                end = Math.min(end, lines.length - 1);
                int i = start;
                while (true) {
                    if (i > end) continue block2;
                    this.putString(String.valueOf(lines[i]) + "\n");
                    ++i;
                }
            }
            if (sl.equals("new")) {
                this.store.clear();
                continue;
            }
            if (sl.equals("cls")) {
                this.cls();
                continue;
            }
            if (sl.equals("dir")) {
                this.dir();
                continue;
            }
            if (split[0].toLowerCase().equals("compile")) {
                if (split.length != 2) {
                    this.putString("?MISSING FILE NAME\n");
                    continue;
                }
                this.compile(split[1]);
                continue;
            }
            if (sl.equals("run")) {
                if (this.runner != null) {
                    this.runner.dispose();
                }
                this.runner = new Runner(this.store.toArray(), this);
                this.runner.synchronousStart();
                continue;
            }
            if (split[0].toLowerCase().equals("save")) {
                if (split.length != 2) {
                    this.putString("?MISSING FILE NAME\n");
                    continue;
                }
                msg = this.store.save(split[1]);
                this.putString(msg);
                continue;
            }
            if (split[0].toLowerCase().equals("load")) {
                if (split.length != 2) {
                    this.putString("?MISSING FILE NAME\n");
                    continue;
                }
                msg = this.store.load(split[1]);
                this.putString(msg);
                continue;
            }
            if (this.store.insert(s)) continue;
            if (this.runner == null) {
                this.runner = new Runner(new String[0], this);
            }
            try {
                this.runner.executeDirectCommand(s);
                continue;
            }
            catch (Throwable t) {
                this.putString("?ERROR\n");
                continue;
            }
            break;
        }
    }

    private int findLine(String[] lines, String line, boolean forEnd) {
        block7: {
            if (!line.isEmpty()) break block7;
            return 0;
        }
        try {
            line = line.trim();
            int ls = Integer.parseInt(line);
            StringBuilder sb = new StringBuilder();
            int cnt = 0;
            int last = -1;
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String l = stringArray[n2];
                String num = this.extractTrailingNumber(sb, l);
                Integer cs = Integer.parseInt(num);
                if (cs == ls) {
                    return cnt;
                }
                if (last < ls && cs > ls) {
                    if (forEnd) {
                        return --cnt;
                    }
                    return cnt;
                }
                last = cs;
                ++cnt;
                ++n2;
            }
        }
        catch (Exception e) {
            Logger.log(e);
            this.putString("? SYNTAX ERROR\n");
        }
        return 0;
    }

    private String extractTrailingNumber(StringBuilder sb, String l) {
        if (sb == null) {
            sb = new StringBuilder();
        } else {
            sb.setLength(0);
        }
        int i = 0;
        while (i < l.length()) {
            char c = l.charAt(i);
            if (!Character.isDigit(c)) break;
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    private void compile(String path) {
        CompilerConfig conf = new CompilerConfig();
        MemoryConfig memConfig = new MemoryConfig();
        String[] code = this.store.toArray();
        Basic basic = new Basic(code);
        NativeCompiler nComp = NativeCompiler.getCompiler();
        List<String> nCode = null;
        Platform64 platform = new Platform64();
        this.putString("COMPILING...\n");
        try {
            nCode = nComp.compile(conf, basic, memConfig, platform);
        }
        catch (Exception e) {
            this.putString("?COMPILE ERROR: " + e.getMessage() + "\n");
            Logger.log(e);
            return;
        }
        Assembler assy = new Assembler(nCode);
        try {
            assy.compile(conf);
        }
        catch (Exception e) {
            this.putString("?COMPILE ERROR: " + e.getMessage() + "\n");
            Logger.log(e);
            return;
        }
        this.putString("SAVING...\n");
        try {
            FileWriter.writeAsPrg(assy.getProgram(), path, memConfig.getProgramStart() == -1 || memConfig.getProgramStart() < platform.getMaxHeaderAddress() && memConfig.getProgramStart() >= platform.getBaseAddress() + 23, platform.getBaseAddress(), true);
        }
        catch (Exception e) {
            this.putString("?IO ERROR: " + e.getMessage() + "\n");
            Logger.log(e);
        }
        this.putString("READY.\n");
    }

    public ProgramStore getStore() {
        return this.store;
    }

    public String getString() {
        try {
            return this.fromTextArea.take().trim();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean peek() {
        return this.fromTextArea.peek() != null;
    }
}

