/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.basicshell;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;

public class BlockCaret
extends DefaultCaret {
    private static final long serialVersionUID = 1L;

    public BlockCaret() {
        this.setBlinkRate(500);
    }

    @Override
    protected synchronized void damage(Rectangle r) {
        if (r != null) {
            JTextComponent component = this.getComponent();
            this.x = r.x;
            this.y = r.y;
            Font font = component.getFont();
            this.width = component.getFontMetrics(font).charWidth('w');
            this.height = r.height;
            this.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        JComponent c = (JComponent)e.getComponent();
        c.repaint();
    }

    @Override
    public void paint(Graphics g) {
        if (this.isVisible()) {
            try {
                JTextComponent component = this.getComponent();
                Rectangle r = component.getUI().modelToView(component, this.getDot());
                Color c = g.getColor();
                g.setColor(component.getBackground());
                g.setXORMode(component.getCaretColor());
                r.setBounds(r.x, r.y, g.getFontMetrics().charWidth('w'), g.getFontMetrics().getHeight());
                g.fillRect(r.x, r.y, r.width, r.height);
                g.setPaintMode();
                g.setColor(c);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }
}

