/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.basicshell;

import com.sixtyfour.Loader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.TreeSet;

public class ProgramStore {
    public static final String ERROR = "ERROR.\n";
    public static final String OK = "READY.\n";
    private final TreeSet<String> store = new TreeSet<String>(new LineComparator());

    private int getLineNumber(String in) throws NumberFormatException {
        StringBuilder buff = new StringBuilder();
        int s = 0;
        while (s < in.length()) {
            char c = in.charAt(s);
            if (!Character.isDigit(c)) break;
            buff.append(c);
            ++s;
        }
        return Integer.parseInt(buff.toString());
    }

    private void removeLine(int num) {
        TreeSet clone = (TreeSet)this.store.clone();
        for (String s : clone) {
            if (this.getLineNumber(s) != num) continue;
            this.store.remove(s);
        }
    }

    public String[] toArray() {
        TreeSet clone = (TreeSet)this.store.clone();
        String[] arr = new String[clone.size()];
        int n = 0;
        for (String s : clone) {
            arr[n++] = s;
        }
        return arr;
    }

    public String toString() {
        TreeSet clone = (TreeSet)this.store.clone();
        StringBuilder sb = new StringBuilder();
        for (String s : clone) {
            sb.append(s).append('\n');
        }
        return sb.toString();
    }

    public boolean insert(String s) {
        if (s != null && s.trim().length() > 0) {
            try {
                int num = this.getLineNumber(s);
                try {
                    int num2 = Integer.parseInt(s);
                    this.removeLine(num);
                }
                catch (NumberFormatException ex) {
                    this.addLine(s);
                }
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        return true;
    }

    private void addLine(String s) {
        this.removeLine(this.getLineNumber(s));
        this.store.add(s);
    }

    public void clear() {
        this.store.clear();
    }

    public String load(String path) {
        this.store.clear();
        try {
            String[] lines;
            String[] stringArray = lines = Loader.loadProgram(path);
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                this.insert(line);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return ERROR;
        }
        return OK;
    }

    public String save(String path) {
        boolean ok = true;
        String txt = this.toString();
        FileWriter outFile = null;
        try {
            outFile = new FileWriter(path);
        }
        catch (IOException e) {
            e.printStackTrace();
            ok = false;
        }
        if (ok) {
            try (PrintWriter out1 = new PrintWriter(outFile);){
                out1.append(txt);
            }
            finally {
                try {
                    outFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    ok = false;
                }
            }
        }
        return ok ? OK : ERROR;
    }

    class LineComparator
    implements Comparator<String> {
        LineComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            return ProgramStore.this.getLineNumber(s1) - ProgramStore.this.getLineNumber(s2);
        }
    }
}

