/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.basicshell;

import com.sixtyfour.Basic;
import com.sixtyfour.basicshell.BasicShell;
import com.sixtyfour.basicshell.ShellInputProvider;
import com.sixtyfour.basicshell.ShellOutputChannel;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.extensions.graphics.GraphicsBasic;
import com.sixtyfour.extensions.textmode.ConsoleSupport;
import java.util.concurrent.Future;

public class Runner
implements Runnable {
    private final Basic olsenBasic;
    private boolean running;
    private Basic runningBasic = null;
    private CompilerConfig config = new CompilerConfig();

    public Runner(String[] program, BasicShell shellFrame) {
        Basic.registerExtension(new GraphicsBasic());
        Basic.registerExtension(new ConsoleSupport());
        this.olsenBasic = new Basic(program);
        this.olsenBasic.setOutputChannel(new ShellOutputChannel(shellFrame));
        this.olsenBasic.setInputProvider(new ShellInputProvider(shellFrame));
    }

    public void dispose() {
        if (this.olsenBasic != null) {
            this.olsenBasic.resetMemory();
        }
    }

    public void registerKey(Character key) {
        if (this.olsenBasic.getInputProvider() instanceof ShellInputProvider) {
            ((ShellInputProvider)this.olsenBasic.getInputProvider()).setCurrentKey(key);
        }
    }

    public void synchronousStart() {
        Future<?> f = BasicShell.executor.submit(this);
        try {
            f.get();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void executeDirectCommand(final String command) {
        Future<?> f = BasicShell.executor.submit(new Runnable(){

            @Override
            public void run() {
                Runner.this.running = true;
                Basic imm = new Basic("0" + command, Runner.this.olsenBasic.getMachine());
                Runner.this.runningBasic = imm;
                imm.compile(Runner.this.config, false);
                imm.start(Runner.this.config);
                Runner.this.running = false;
                Runner.this.runningBasic = null;
            }
        });
        try {
            f.get();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public Basic getOlsenBasic() {
        return this.olsenBasic;
    }

    public Basic getRunningBasic() {
        return this.runningBasic;
    }

    public void start(boolean synchronous) {
        Future<?> f = BasicShell.executor.submit(this);
        if (!synchronous) {
            return;
        }
        try {
            f.get();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        this.running = true;
        this.runningBasic = this.olsenBasic;
        this.olsenBasic.run(this.config);
        this.running = false;
        this.runningBasic = null;
    }
}

