/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.basicshell;

import com.sixtyfour.basicshell.BasicShell;
import com.sixtyfour.basicshell.BlockCaret;
import com.sixtyfour.basicshell.ResourceLoader;
import com.sixtyfour.util.Colors;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.util.List;
import javax.swing.JTextArea;

class ShellTextComponent
extends JTextArea {
    private static final long serialVersionUID = 1L;
    private final BasicShell parent;

    public ShellTextComponent(BasicShell sf) {
        this.parent = sf;
        this.setBackground(new Color(Colors.COLORS[6]));
        this.setDoubleBuffered(true);
        this.setForeground(new Color(Colors.COLORS[14]));
        this.setCaretColor(new Color(Colors.COLORS[14]));
        this.setToolTipText("<html>Type one of:<br>- cls<br>- list<br>- run<br>- new<br>- save[file]<br>- load[file]<br>- compile[file]<br>- dir<br>or edit your BASIC code here</html>");
        BlockCaret mc = new BlockCaret();
        mc.setUpdatePolicy(2);
        this.setCaret(mc);
        this.setFont(ResourceLoader.getFont());
        new DropTarget(this, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent event) {
                DataFlavor[] flavors;
                event.acceptDrop(1);
                Transferable transferable = event.getTransferable();
                DataFlavor[] dataFlavorArray = flavors = transferable.getTransferDataFlavors();
                int n = flavors.length;
                int n2 = 0;
                while (n2 < n) {
                    DataFlavor flavor = dataFlavorArray[n2];
                    try {
                        if (flavor.isFlavorJavaFileListType()) {
                            List files = (List)transferable.getTransferData(flavor);
                            File f = (File)files.get(0);
                            ShellTextComponent.this.parent.getStore().load(f.getPath());
                            ShellTextComponent.this.parent.putStringUCase("Loaded: " + f.getName() + "\n" + "READY.\n");
                            return;
                        }
                    }
                    catch (Exception e) {
                        ShellTextComponent.this.parent.putString("ERROR.\n");
                    }
                    ++n2;
                }
            }
        });
    }

    @Override
    public void paste() {
        try {
            String[] lines;
            String[] stringArray = lines = ShellTextComponent.getClipBoardString().split("[\r\n]+");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                this.parent.getStore().insert(s.trim());
                ++n2;
            }
            this.parent.putStringUCase(lines.length + " lines pasted\n" + "READY.\n");
        }
        catch (Exception e) {
            this.parent.putString("ERROR.\n");
            e.printStackTrace();
        }
    }

    private static String getClipBoardString() throws Exception {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable clipData = clipboard.getContents(clipboard);
        if (clipData != null && clipData.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return (String)clipData.getTransferData(DataFlavor.stringFlavor);
        }
        throw new Exception("no clpboard data");
    }
}

