/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.cbmnative;

import com.sixtyfour.Logger;
import com.sixtyfour.cbmnative.ProgressListener;
import com.sixtyfour.cbmnative.Util;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Compactor {
    private int threshold = 4;
    private int extCount = 0;
    private Map<Integer, List<Line>> lines = new HashMap<Integer, List<Line>>();

    public Compactor(int threshold) {
        this.threshold = threshold;
    }

    public List<String> inlineIntegerConstants(List<String> nCode) {
        Map<String, Number> const2Value = Util.extractNumberConstants(nCode);
        int reps = 0;
        int i = 0;
        while (i < nCode.size()) {
            String cst;
            String cn;
            String line = nCode.get(i);
            int pos = line.indexOf("CONST_");
            if (pos != -1 && line.contains("LD") && !line.contains("<") && !line.contains(">") && !(cn = (cst = line.substring(pos, line.length()).trim()).replace("+1", "")).contains("R")) {
                boolean isHighByte = cst.length() != cn.length();
                Number val = const2Value.get(cn);
                if (VarUtils.isInteger(val)) {
                    int ival = VarUtils.getInt(val);
                    ival = isHighByte ? (ival >>= 8) : (ival -= ival >> 8 << 8);
                    String newLine = String.valueOf(line.substring(0, pos)) + "#" + ival;
                    nCode.set(i, newLine);
                    ++reps;
                    if (newLine.startsWith("LDA") && nCode.get(i - 1).replace("LDY", "LDA").equals(newLine)) {
                        nCode.set(i, "TYA");
                    }
                }
            }
            ++i;
        }
        Logger.log("Inlined " + (reps >> 1) + " integer constants!");
        return nCode;
    }

    public List<String> removeUnusedConstants(List<String> input) {
        Logger.log("Removing unused constants...");
        boolean found = false;
        ArrayList<Line> consts = new ArrayList<Line>();
        int constStart = 0;
        int i = 0;
        while (i < input.size()) {
            String line = input.get(i);
            if (!found) {
                if (line.startsWith("; *** CONSTANTS ***")) {
                    found = true;
                    constStart = i;
                }
            } else if (line.startsWith("CONST_")) {
                line = line.replace("\t", " ");
                line = line.split(" ")[0].trim();
                consts.add(new Line(line, i));
            }
            ++i;
        }
        if (!found) {
            return input;
        }
        Logger.log("Number of constants: " + consts.size());
        List<String> codePart = input.subList(0, constStart);
        ArrayList<Line> notUsed = new ArrayList<Line>();
        for (Line consty : consts) {
            boolean used = false;
            for (String line : codePart) {
                if (!line.endsWith(consty.txt) && !line.endsWith(String.valueOf(consty.txt) + ",X")) continue;
                used = true;
                break;
            }
            if (used) continue;
            notUsed.add(consty);
        }
        Logger.log("Number of unused constants: " + notUsed.size());
        for (Line consty : notUsed) {
            int pos = consty.position;
            boolean clear = true;
            int i2 = pos - 1;
            while (i2 >= 0) {
                String cl = input.get(i2);
                if (!(cl.trim().isEmpty() || cl.startsWith(";") || cl.contains("."))) {
                    Logger.log("Blocking entry: " + cl);
                    clear = false;
                }
                if (cl.startsWith(";")) break;
                --i2;
            }
            if (!clear) continue;
            input.set(pos, "");
        }
        return input;
    }

    public List<String> compact(CompilerConfig conf, List<String> input) {
        Logger.log("Compacting code...");
        ProgressListener pl = null;
        if (conf != null) {
            pl = conf.getProgressListener();
        }
        if (pl != null) {
            pl.start();
        }
        this.strip(input);
        int insertAt = 0;
        int i = 0;
        while (i < input.size() && insertAt == 0) {
            if (input.get(i).contains("SUBROUTINES END")) {
                insertAt = i;
                input.add(insertAt++, ";##END_COMPACT");
            }
            ++i;
        }
        int oldSize = input.size();
        this.updateLineMap(input);
        ArrayList finds = new ArrayList();
        HashSet<Integer> replaced = new HashSet<Integer>();
        Comparator<String> lineComp = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        };
        int i2 = 0;
        while (i2 < input.size()) {
            List<Line> matchings;
            String line;
            if (pl != null && i2 % 300 == 0) {
                pl.nextStep();
            }
            if ((line = input.get(i2).trim()).startsWith(";##END_COMPACT")) break;
            if (!line.startsWith(";") && (matchings = this.lines.get(line.hashCode())) != null) {
                HashSet<List> addedTo = new HashSet<List>();
                for (Line match : matchings) {
                    if (!match.txt.equals(line)) continue;
                    for (List list : finds) {
                        if (addedTo.contains(list)) continue;
                        Line lp = (Line)list.get(list.size() - 1);
                        if (lp.position != match.position - 1) continue;
                        list.add(match);
                        addedTo.add(list);
                        break;
                    }
                    ArrayList<Line> arrayList = new ArrayList<Line>();
                    arrayList.add(match);
                    finds.add(arrayList);
                    addedTo.add(arrayList);
                }
                ArrayList toRemove = new ArrayList(finds);
                toRemove.removeAll(addedTo);
                HashMap<String, ArrayList<List>> removers = new HashMap<String, ArrayList<List>>();
                for (List list : toRemove) {
                    StringBuilder sb = new StringBuilder();
                    for (Line rl : list) {
                        sb.append(rl.txt);
                    }
                    ArrayList<List> subs = (ArrayList<List>)removers.get(sb.toString());
                    if (subs == null) {
                        subs = new ArrayList<List>();
                        removers.put(sb.toString(), subs);
                    }
                    subs.add(list);
                }
                ArrayList arrayList = new ArrayList(removers.keySet());
                Collections.sort(arrayList, lineComp);
                for (String remover : arrayList) {
                    List rems = (List)removers.get(remover);
                    if (rems == null || rems.size() <= 1 || ((List)rems.get(0)).size() <= this.threshold) continue;
                    String label = "COMPACT" + this.extCount++;
                    boolean reallyFirst = true;
                    for (List toReps : rems) {
                        int pos;
                        boolean first = true;
                        boolean alreadyProcs = false;
                        for (Line toRep : toReps) {
                            pos = toRep.position;
                            if (!replaced.contains(pos)) continue;
                            alreadyProcs = true;
                            break;
                        }
                        if (alreadyProcs) continue;
                        for (Line toRep : toReps) {
                            pos = toRep.position;
                            if (first) {
                                input.set(pos, "JSR " + label);
                                if (reallyFirst) {
                                    input.add(insertAt++, label);
                                    String lastLine = null;
                                    for (Line rr : toReps) {
                                        lastLine = rr.txt;
                                        input.add(insertAt++, lastLine);
                                    }
                                    if (lastLine != null && lastLine.startsWith("JSR")) {
                                        input.set(insertAt - 1, "JMP" + lastLine.substring(3));
                                    } else {
                                        input.add(insertAt++, "RTS");
                                    }
                                    input.add(insertAt++, ";##################################################");
                                    reallyFirst = false;
                                }
                                first = false;
                                replaced.add(pos);
                                continue;
                            }
                            input.set(pos, "NOP");
                            replaced.add(pos);
                        }
                    }
                }
                this.updateLineMap(input);
                if (toRemove.size() > 0) {
                    finds.removeAll(toRemove);
                }
            }
            ++i2;
        }
        this.strip(input);
        if (pl != null) {
            pl.done();
        }
        Logger.log("Compactor executed with results:");
        Logger.log("Old size: " + oldSize);
        Logger.log("New size: " + input.size());
        return input;
    }

    private void strip(List<String> input) {
        Iterator<String> itty = input.iterator();
        while (itty.hasNext()) {
            String val = itty.next().trim();
            if (val.contains("SUBROUTINES END")) {
                return;
            }
            if (!val.isEmpty() && !val.equals("NOP") && (!val.startsWith(";") || val.contains("##") || val.contains("SUBROUTINES END"))) continue;
            itty.remove();
        }
    }

    private void updateLineMap(List<String> input) {
        this.lines.clear();
        int cnt = 0;
        int skip = 0;
        block0: for (String line : input) {
            int hc;
            List<Line> hcs;
            if ((line = line.trim()).contains("##END_COMPACT")) {
                return;
            }
            if (line.startsWith("RTS") || line.contains("##") || line.startsWith("NOP") || skip-- > 0 || line.contains("$FFFF") || line.startsWith("JSR COMPACT") || line.contains("JMP") || line.contains("JSR NEXT")) {
                ++cnt;
                continue;
            }
            if (line.contains("MOVBSELF") && line.startsWith("ST")) {
                int p1 = line.indexOf(" ");
                int p2 = line.indexOf("+");
                if (p1 != -1 && p2 != -1) {
                    String lab = line.substring(p1, p2).trim();
                    int lc = cnt;
                    while (lc < input.size()) {
                        String subl = input.get(lc);
                        if (subl.startsWith(String.valueOf(lab) + ":")) {
                            skip = lc + 2 - ++cnt;
                            continue block0;
                        }
                        ++lc;
                    }
                    continue;
                }
            }
            if ((hcs = this.lines.get(hc = line.hashCode())) == null) {
                hcs = new ArrayList<Line>();
            }
            hcs.add(new Line(line, cnt));
            ++cnt;
            this.lines.put(hc, hcs);
        }
    }

    private static class Line {
        public String txt;
        public int position;

        public Line(String txt, int position) {
            this.txt = txt;
            this.position = position;
        }
    }
}

