/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.cbmnative;

import com.sixtyfour.Basic;
import com.sixtyfour.Logger;
import com.sixtyfour.cbmnative.Compactor;
import com.sixtyfour.cbmnative.NativeOptimizer;
import com.sixtyfour.cbmnative.PCode;
import com.sixtyfour.cbmnative.PlatformProvider;
import com.sixtyfour.cbmnative.TermHelper;
import com.sixtyfour.cbmnative.Transformer;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.config.MemoryConfig;
import com.sixtyfour.elements.commands.Command;
import com.sixtyfour.extensions.BasicExtension;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Line;
import com.sixtyfour.parser.Term;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.parser.optimize.ConstantFolder;
import com.sixtyfour.parser.optimize.ConstantPropagator;
import com.sixtyfour.parser.optimize.DeadCodeChecker;
import com.sixtyfour.parser.optimize.DeadStoreEliminator;
import com.sixtyfour.parser.optimize.TermOptimizer;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.CompilerException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class NativeCompiler {
    private static final Set<String> SINGLES = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("!");
            this.add("SIN");
            this.add("COS");
            this.add("TAN");
            this.add("ATN");
            this.add("EXP");
            this.add("LOG");
            this.add("INT");
            this.add("ABS");
            this.add("SGN");
            this.add("SQR");
            this.add("RND");
            this.add("CHR");
            this.add("ASC");
            this.add("STR");
            this.add("VAL");
            this.add("POS");
            this.add("TAB");
            this.add("SPC");
            this.add("TABCHANNEL");
            this.add("SPCCHANNEL");
            this.add("LEN");
            this.add("USR");
            this.add("PEEK");
            this.add("MID");
            this.add("PAR");
            this.add("LEFT");
            this.add("RIGHT");
            this.add("ARRAYACCESS");
        }
    };
    private static final Set<String> STRING_OPERATORS = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("CHR");
            this.add(".");
            this.add("STR");
            this.add("MID");
            this.add("LEFT");
            this.add("RIGHT");
            this.add("TAB");
            this.add("SPC");
            this.add("TABCHANNEL");
            this.add("SPCCHANNEL");
            this.add("SCMP");
        }
    };
    private static NativeCompiler instance = new NativeCompiler();
    private String lastProcessedLine = null;

    public static NativeCompiler getCompiler() {
        return instance;
    }

    public List<String> compile(Basic basic, PlatformProvider platform) {
        return this.compile(new CompilerConfig(), basic, new MemoryConfig(), platform);
    }

    public List<String> compile(CompilerConfig conf, Basic basic, MemoryConfig memConfig, PlatformProvider platform) {
        platform.overrideConfig(conf);
        Logger.log("Running native compiler...");
        Logger.log("Parsing BASIC program into AST...");
        basic.compile(conf);
        List<String> mCode = NativeCompiler.getCompiler().compileToPseudoCode(conf, basic);
        boolean adjusted = basic.adjustMemoryConfig(memConfig);
        if (adjusted) {
            Logger.log("Program memory adjusted to end at $" + Integer.toHexString(memConfig.getStringEnd()));
        }
        Transformer tf = platform.getTransformer();
        tf.setVariableStart(memConfig.getVariableStart());
        tf.setOptimizedTempStorage(memConfig.isOptimizedTempStorage());
        if (memConfig.getStringEnd() != -1) {
            tf.setStringMemoryEnd(memConfig.getStringEnd());
        }
        if (memConfig.getProgramStart() != -1) {
            tf.setStartAddress(memConfig.getProgramStart());
        }
        if (memConfig.getRuntimeStart() != -1) {
            tf.setRuntimeStart(memConfig.getRuntimeStart());
        }
        if (!memConfig.isValid()) {
            throw new RuntimeException("String memory (" + memConfig.getStringEnd() + ") must not be lower than variable memory (" + memConfig.getVariableStart() + ")!");
        }
        List<String> nCode = tf.transform(conf, memConfig, basic.getMachine(), platform, mCode);
        if (platform.getOptimizer() != null && conf.isNativeLanguageOptimizations()) {
            nCode = platform.getOptimizer().optimize(conf, platform, nCode, conf.getProgressListener());
        }
        if (platform.getUnlinker() != null && conf.isOptimizedLinker()) {
            nCode = platform.getUnlinker().unlink(nCode);
        }
        if (conf.isOptimizeConstants()) {
            Compactor comp = new Compactor(0);
            nCode = comp.inlineIntegerConstants(nCode);
            nCode = comp.removeUnusedConstants(nCode);
        }
        if (conf.getCompactThreshold() > 1) {
            nCode = new Compactor(conf.getCompactThreshold()).compact(conf, nCode);
        }
        return nCode;
    }

    public List<String> compileToPseudoCode(CompilerConfig config, Basic basic) {
        Logger.log("Compiling into intermediate code...");
        long s = System.currentTimeMillis();
        Machine machine = basic.getMachine();
        PCode pCode = basic.getPCode();
        if (config.isDeadCodeElimination()) {
            pCode = DeadCodeChecker.removeDeadCode(pCode);
        }
        if (!config.isConstantFolding()) {
            DeadStoreEliminator.eliminateDeadStores(config, basic);
        } else {
            ConstantPropagator.propagateConstants(config, machine);
            ConstantFolder.foldConstants(config, machine);
            DeadStoreEliminator.eliminateDeadStores(config, basic);
        }
        if (config.isPcodeOptimize()) {
            pCode.optimize();
        }
        basic.modifyDelayLoops(config);
        TermOptimizer.handleConstantConditions(config, machine, basic);
        List<Command> cmds = basic.getMachine().getCommandList();
        for (Command cmd : cmds) {
            if (!cmd.isCommand("DIM")) continue;
            cmd.evalToCode(config, machine);
        }
        List<String> mCode = new ArrayList<String>();
        for (Integer lineNumber : pCode.getLineNumbers()) {
            Line line = pCode.getLines().get(lineNumber);
            this.lastProcessedLine = String.valueOf(line.getNumber()) + " " + line.getLine();
            mCode.add(lineNumber + ":");
            boolean condi = false;
            for (Command cmd : line.getCommands()) {
                int codeStart = mCode.size();
                if (!condi) {
                    mCode.addAll(this.compileToPseudoCode(config, machine, cmd));
                } else {
                    int i = mCode.size() - 1;
                    while (i >= 0) {
                        if (!mCode.get(i).startsWith("SKIP")) {
                            mCode.addAll(i + 1, this.compileToPseudoCode(config, machine, cmd));
                            break;
                        }
                        --i;
                    }
                }
                if (cmd.isConditional()) {
                    condi = true;
                }
                if (mCode.size() <= codeStart || mCode.get(codeStart).equalsIgnoreCase("NOP")) continue;
                mCode.add(codeStart, "NOP");
            }
        }
        if (!this.getLastEntry(mCode).equals("RTS")) {
            this.addEndCode(mCode);
        }
        int os = mCode.size();
        mCode = this.optimize(config, mCode);
        Logger.log("Code optimized: " + os + " => " + mCode.size() + " lines!");
        if (mCode.isEmpty()) {
            this.addEndCode(mCode);
        }
        if (!mCode.get(0).equals("0:")) {
            mCode.add(0, "0:");
        }
        mCode.add(0, "JSR START");
        mCode.add(0, "PROGRAMSTART:");
        Logger.log("Compiled to intermediate code in: " + (System.currentTimeMillis() - s) + "ms");
        return mCode;
    }

    public List<String> compileToPseudoCode(CompilerConfig config, Machine machine, Command command) {
        return this.compileToPseudoCodeInternal(config, machine, command);
    }

    public List<String> compileToPseudoCode(CompilerConfig config, Machine machine, Term term) {
        Term atom = TermHelper.linearize(config, machine, term);
        List<String> ret = this.compileToPseudoCode(config, machine, (Atom)atom);
        ret.add(0, "NOP");
        return ret;
    }

    public List<String> compileToPseudoCode(CompilerConfig config, Machine machine, Atom atom) {
        String tr = null;
        String sr = null;
        boolean pointerMode = false;
        boolean contextMode = false;
        int modeSwitchCnt = 0;
        HashSet<String> floatRegs = new HashSet<String>(){
            private static final long serialVersionUID = 1L;
            {
                this.add("X");
                this.add("Y");
            }
        };
        ArrayList<String> code = new ArrayList<String>();
        List<String> expr = atom.evalToCode(config, machine).get(0).getExpression();
        LinkedList<String> stack = new LinkedList<String>();
        LinkedList<String> yStack = new LinkedList<String>();
        LinkedList<Boolean> stringStack = new LinkedList<Boolean>();
        boolean withStrings = false;
        boolean left = false;
        boolean right = false;
        boolean isArrayAccess = false;
        HashSet<Integer> fromAbove = new HashSet<Integer>();
        int expCnt = 0;
        for (String exp : expr) {
            boolean isOp;
            block222: {
                boolean dontPush;
                block223: {
                    boolean isStringArrayAccess;
                    ++expCnt;
                    isOp = exp.startsWith(":");
                    boolean isBreak = exp.equals("_");
                    isArrayAccess = false;
                    String osr = sr;
                    if (exp.contains("{")) {
                        if (exp.contains("{STRING") || exp.contains("[]")) {
                            String add = null;
                            if (!pointerMode && ++modeSwitchCnt > 1 && !code.isEmpty() && exp.contains("{STRING") && !contextMode) {
                                add = "CHGCTX #1";
                            }
                            contextMode = true;
                            pointerMode = true;
                            if (!exp.contains("[]")) {
                                tr = "A";
                                sr = "B";
                            } else {
                                tr = "G";
                                sr = "G";
                                isArrayAccess = true;
                                if (exp.contains("{STRING")) {
                                    stringStack.push(true);
                                } else {
                                    stringStack.push(false);
                                }
                                if (this.getLastEntry(code).equals("PUSH X")) {
                                    yStack.pop();
                                    code.remove(code.size() - 1);
                                }
                                if (right && left) {
                                    code.add("PUSH " + osr);
                                    yStack.push(null);
                                    right = false;
                                }
                            }
                            if (add != null) {
                                if (right && !isArrayAccess) {
                                    code.add("PUSH Y");
                                    yStack.push(null);
                                    right = false;
                                }
                                if (left && !isArrayAccess) {
                                    code.add("PUSH X");
                                    yStack.push(null);
                                    left = false;
                                }
                                code.add(add);
                            }
                        } else {
                            if (pointerMode && ++modeSwitchCnt > 1 && !code.isEmpty() && contextMode) {
                                code.add("CHGCTX #0");
                                if (right) {
                                    code.add("PUSH B");
                                    yStack.push(null);
                                    right = false;
                                }
                                if (left) {
                                    code.add("PUSH A");
                                    yStack.push(null);
                                    left = false;
                                }
                            }
                            contextMode = false;
                            pointerMode = false;
                            tr = "X";
                            sr = "Y";
                        }
                    }
                    if (!isBreak && !isOp) {
                        if (!right || isArrayAccess) {
                            code.add("MOV " + (isArrayAccess ? "G" : sr) + "," + exp);
                            right = true;
                        } else if (!left) {
                            code.add("MOV " + tr + "," + exp);
                            left = true;
                        }
                    }
                    if (isOp && right && !left) {
                        String lc = this.getLastEntry(code);
                        if (lc.startsWith("MOV " + sr) && !lc.contains("[]")) {
                            yStack.push(lc);
                            code.remove(code.size() - 1);
                        } else if (!this.isParameterRegister(sr)) {
                            code.add("PUSH " + sr);
                            yStack.push(null);
                        }
                        right = false;
                    }
                    if (!isBreak) break block222;
                    String ex = (String)stack.pop();
                    String op = ex.replace(":", "");
                    String opStart = op;
                    if (opStart.indexOf(" ") != -1) {
                        opStart = opStart.substring(0, opStart.indexOf(" "));
                    }
                    boolean isSingle = this.isSingle(op);
                    if (op.startsWith("ARRAYACCESS")) {
                        String lastFilled = this.getLastFilledRegister(code, 1, (Set<String>)floatRegs);
                        int pos = code.size() - (((String)code.get(code.size() - 2)).startsWith("CHGCTX") ? 2 : 1);
                        if ("Y".equals(lastFilled)) {
                            code.add(pos, "MOV X,Y");
                        } else if (lastFilled.startsWith("POP")) {
                            code.add(pos, lastFilled);
                        }
                    }
                    boolean bl = isStringArrayAccess = !stringStack.isEmpty() && (Boolean)stringStack.peek() != false && contextMode;
                    if (!left && !isSingle) {
                        if (code.size() >= 1 && this.getLastEntry(code).equals("PUSH " + tr)) {
                            code.remove(code.size() - 1);
                            yStack.pop();
                        } else if (code.size() >= 2 && ((String)code.get(code.size() - 2)).equals("PUSH " + tr) && this.getLastEntry(code).startsWith("MOV " + sr)) {
                            code.remove(code.size() - 2);
                            yStack.pop();
                        } else if (this.popy(code, sr, tr, sr, tr, false)) {
                            yStack.pop();
                        }
                        left = true;
                    }
                    if (!right) {
                        boolean mayPop;
                        String ntr = tr;
                        String nsr = sr;
                        if (STRING_OPERATORS.contains(opStart) || isStringArrayAccess) {
                            if (!(pointerMode && !isStringArrayAccess || modeSwitchCnt <= 1 || code.isEmpty())) {
                                ntr = "A";
                                nsr = "B";
                            }
                        } else if (pointerMode && modeSwitchCnt > 1 && !code.isEmpty()) {
                            ntr = "X";
                            nsr = "Y";
                        }
                        boolean bl2 = mayPop = !op.equals("ARRAYACCESS");
                        if (mayPop) {
                            if (yStack.isEmpty()) {
                                this.popy(code, tr, sr, ntr, nsr, true);
                            } else {
                                String v = (String)yStack.pop();
                                if (v == null) {
                                    if (!this.popy(code, tr, sr, ntr, nsr, false)) {
                                        yStack.push(null);
                                    }
                                } else {
                                    code.add(v);
                                    fromAbove.add(code.size() - 1);
                                }
                            }
                        }
                        right = true;
                    }
                    if (tr == null) {
                        throw new CompilerException();
                    }
                    if (!tr.equals(sr)) {
                        if (!code.isEmpty() && this.getLastEntry(code).startsWith("MOV " + sr) && !this.getLastEntry(code).equals("MOV " + sr + "," + tr) && !fromAbove.contains(code.size() - 1)) {
                            code.add(code.size() - 1, "MOV " + sr + "," + tr);
                            code.set(code.size() - 1, this.getLastEntry(code).replace("MOV " + sr + ",", "MOV " + tr + ","));
                        } else if (isSingle && !code.isEmpty() && this.getLastEntry(code).startsWith("MOV " + tr)) {
                            String lmt = this.getLastMoveTarget(code, 2);
                            code.add(code.size() - 1, "PUSH " + lmt);
                            code.set(code.size() - 1, this.getLastEntry(code).replace("MOV " + tr + ",", "MOV " + sr + ","));
                            yStack.push(null);
                        }
                    }
                    if (STRING_OPERATORS.contains(op) || isStringArrayAccess) {
                        if (!(pointerMode || ++modeSwitchCnt <= 1 || code.isEmpty() || contextMode)) {
                            code.add("CHGCTX #1");
                        }
                        contextMode = true;
                        pointerMode = true;
                        tr = "A";
                        sr = "B";
                    } else {
                        if (pointerMode && ++modeSwitchCnt > 1 && !code.isEmpty() && contextMode) {
                            code.add("CHGCTX #0");
                        }
                        contextMode = false;
                        pointerMode = false;
                        tr = "X";
                        sr = "Y";
                    }
                    String regs = pointerMode ? "A,B" : "X,Y";
                    dontPush = false;
                    boolean added = this.applyOperation(op, code);
                    if (added) break block223;
                    switch (op) {
                        case "+": {
                            code.add("ADD " + regs);
                            break;
                        }
                        case "-": {
                            code.add("SUB " + regs);
                            break;
                        }
                        case "*": {
                            code.add("MUL " + regs);
                            break;
                        }
                        case "/": {
                            code.add("DIV " + regs);
                            break;
                        }
                        case "^": {
                            code.add("POW " + regs);
                            break;
                        }
                        case "|": {
                            code.add("OR " + regs);
                            break;
                        }
                        case "&": {
                            code.add("AND " + regs);
                            break;
                        }
                        case "!": {
                            code.add("NOT " + regs);
                            break;
                        }
                        case "SIN": {
                            code.add("SIN " + regs);
                            break;
                        }
                        case "COS": {
                            code.add("COS " + regs);
                            break;
                        }
                        case "LOG": {
                            code.add("LOG " + regs);
                            break;
                        }
                        case "SQR": {
                            code.add("SQR " + regs);
                            break;
                        }
                        case "INT": {
                            code.add("INT " + regs);
                            break;
                        }
                        case "ABS": {
                            code.add("ABS " + regs);
                            break;
                        }
                        case "SGN": {
                            code.add("SGN " + regs);
                            break;
                        }
                        case "TAN": {
                            code.add("TAN " + regs);
                            break;
                        }
                        case "ATN": {
                            code.add("ATN " + regs);
                            break;
                        }
                        case "EXP": {
                            code.add("EXP " + regs);
                            break;
                        }
                        case "RND": {
                            code.add("RND " + regs);
                            break;
                        }
                        case "PEEK": {
                            code.add("MOVB " + regs.replace(",", ",(") + ")");
                            break;
                        }
                        case ".": {
                            withStrings = true;
                            code.add("JSR CONCAT");
                            break;
                        }
                        case "USR": {
                            code.add("JSR USR");
                            break;
                        }
                        case "CHR": {
                            withStrings = true;
                            code.add("JSR CHR");
                            break;
                        }
                        case "STR": {
                            withStrings = true;
                            code.add("JSR STR");
                            break;
                        }
                        case "VAL": {
                            code.add("JSR VAL");
                            break;
                        }
                        case "ASC": {
                            code.add("JSR ASC");
                            break;
                        }
                        case "LEN": {
                            code.add("JSR LEN");
                            break;
                        }
                        case "TAB": {
                            code.add("JSR TAB");
                            break;
                        }
                        case "SPC": {
                            code.add("JSR SPC");
                            break;
                        }
                        case "TABCHANNEL": {
                            code.add("JSR TABCHANNEL");
                            break;
                        }
                        case "SPCCHANNEL": {
                            code.add("JSR SPCCHANNEL");
                            break;
                        }
                        case "POS": {
                            code.add("JSR POS");
                            break;
                        }
                        case "FRE": {
                            code.add("JSR FRE");
                            break;
                        }
                        case "ARRAYACCESS": {
                            code.add("JSR ARRAYACCESS");
                            stringStack.pop();
                            break;
                        }
                        case "MID": {
                            withStrings = true;
                            code.add("POP D");
                            code.add("POP C");
                            code.add("JSR MID");
                            break;
                        }
                        case "LEFT": {
                            withStrings = true;
                            code.add("POP C");
                            code.add("JSR LEFT");
                            break;
                        }
                        case "RIGHT": {
                            withStrings = true;
                            code.add("POP C");
                            code.add("JSR RIGHT");
                            break;
                        }
                        case "CMP =": {
                            code.add("EQ " + regs);
                            break;
                        }
                        case "CMP >": {
                            code.add("GT " + regs);
                            break;
                        }
                        case "CMP <": {
                            code.add("LT " + regs);
                            break;
                        }
                        case "CMP >=": {
                            code.add("GTEQ " + regs);
                            break;
                        }
                        case "CMP <=": {
                            code.add("LTEQ " + regs);
                            break;
                        }
                        case "CMP <>": {
                            code.add("NEQ " + regs);
                            break;
                        }
                        case "SCMP =": {
                            code.add("JSR SEQ");
                            break;
                        }
                        case "SCMP >": {
                            code.add("JSR SGT");
                            break;
                        }
                        case "SCMP <": {
                            code.add("JSR SLT");
                            break;
                        }
                        case "SCMP >=": {
                            code.add("JSR SGTEQ");
                            break;
                        }
                        case "SCMP <=": {
                            code.add("JSR SLTEQ");
                            break;
                        }
                        case "SCMP <>": {
                            code.add("JSR SNEQ");
                            break;
                        }
                        case "PAR": {
                            if (this.getLastEntry(code).startsWith("MOV " + sr)) {
                                code.add("MOV C," + sr);
                            } else {
                                code.add("MOV C," + tr);
                            }
                            code.add("PUSH C");
                            dontPush = true;
                            break;
                        }
                        default: {
                            if (op.startsWith("FN ")) {
                                String label = op.substring(2).trim();
                                code.add("PUSH " + sr);
                                yStack.push(null);
                                code.add("JSR " + label);
                                if (expCnt >= expr.size()) {
                                    code.add("POP " + tr);
                                }
                                dontPush = true;
                                break;
                            }
                            throw new RuntimeException("Unknown operator: " + op);
                        }
                    }
                }
                if (!dontPush && !this.isParameterRegister(tr)) {
                    code.add("PUSH " + tr);
                    yStack.push(null);
                }
                dontPush = false;
                left = false;
                right = false;
            }
            if (!isOp) continue;
            stack.push(exp);
        }
        if (!stack.isEmpty()) {
            throw new RuntimeException("Operator stack not empty, " + stack.size() + " element(s) remaining!");
        }
        if (!code.isEmpty() && !this.getLastEntry(code).equals("PUSH " + tr)) {
            String cl = this.getLastEntry(code);
            if (cl.startsWith("MOV " + sr)) {
                if (!this.isParameterRegister(sr)) {
                    code.add("PUSH " + sr);
                }
            } else if (!this.isParameterRegister(tr)) {
                code.add("PUSH " + tr);
            }
        }
        if (withStrings) {
            code.add(0, "JSR COMPACTMAX");
        }
        return this.optimizeInternal(config, code);
    }

    public String getLastProcessedLine() {
        return this.lastProcessedLine;
    }

    private List<String> optimize(CompilerConfig config, List<String> code) {
        return NativeOptimizer.optimizeNative(config, code, config.getProgressListener());
    }

    private List<String> optimizeInternal(CompilerConfig config, List<String> code) {
        return NativeOptimizer.optimizeNativeInternal(config, code, null);
    }

    private String getLastMoveTarget(List<String> code, int offset) {
        int i = code.size() - offset;
        while (i >= 0) {
            String reg;
            if (code.get(i).startsWith("MOV ") && (reg = code.get(i).substring(4, code.get(i).indexOf(",")).trim()).length() == 1) {
                return reg;
            }
            --i;
        }
        return null;
    }

    private String getLastFilledRegister(List<String> code, int offset, Set<String> allowed) {
        int i = code.size() - offset;
        while (i >= 0) {
            String codeS = code.get(i).replace("MOVB", "MOV");
            if (codeS.indexOf(" ") == 3) {
                int pos = codeS.indexOf(",");
                if (pos > 4) {
                    String reg = codeS.substring(4, pos).trim();
                    if (reg.length() == 1 && allowed.contains(reg)) {
                        return reg;
                    }
                } else if (codeS.startsWith("JSR ")) {
                    String addr = codeS.substring(4).toUpperCase(Locale.ENGLISH);
                    if (this.isSingle(addr)) {
                        return "X";
                    }
                    if (addr.startsWith("DEF")) {
                        return "POP X";
                    }
                }
            }
            --i;
        }
        return null;
    }

    private String getLastEntry(List<String> code) {
        if (code.size() > 0) {
            return code.get(code.size() - 1);
        }
        return null;
    }

    private boolean popy(List<String> code, String tr, String sr, String ntr, String nsr, boolean stackEmpty) {
        if (this.getLastEntry(code) != null) {
            if (this.getLastEntry(code).equals("PUSH " + tr)) {
                code.set(code.size() - 1, "MOV " + sr + "," + tr);
            } else if (this.getLastEntry(code).equals("PUSH " + nsr)) {
                code.remove(code.size() - 1);
            } else if (!stackEmpty && !this.isParameterRegister(nsr)) {
                code.add("POP " + nsr);
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean isSingle(String op) {
        for (BasicExtension ext : Basic.getExtensions()) {
            if (!ext.isSingleSided(op)) continue;
            return true;
        }
        return SINGLES.contains(op.toUpperCase(Locale.ENGLISH)) || op.startsWith("FN ");
    }

    private boolean applyOperation(String op, List<String> code) {
        for (BasicExtension ext : Basic.getExtensions()) {
            if (!ext.applyOperation(op, code)) continue;
            return true;
        }
        return false;
    }

    private boolean isParameterRegister(String reg) {
        return reg.equals("C") || reg.equals("D") || reg.equals("G");
    }

    private List<String> compileToPseudoCodeInternal(CompilerConfig config, Machine machine, Atom atom) {
        ArrayList<String> mCode = new ArrayList<String>();
        List<CodeContainer> ccs = atom.evalToCode(config, machine);
        for (CodeContainer cc : ccs) {
            mCode.addAll(cc.getPseudoBefore());
            mCode.addAll(cc.getExpression());
            mCode.addAll(cc.getPseudoAfter());
        }
        return mCode;
    }

    private void addEndCode(List<String> mCode) {
        mCode.add("NOP");
        mCode.add("JSR END");
        mCode.add("RTS");
    }
}

