/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.cbmnative;

import com.sixtyfour.Logger;
import com.sixtyfour.cbmnative.ProgressListener;
import com.sixtyfour.config.CompilerConfig;
import java.util.ArrayList;
import java.util.List;

public class NativeOptimizer {
    private static final int MAX_AHEAD = 19;
    private static List<NativePattern> patterns = new ArrayList<NativePattern>();

    static {
        patterns.add(new NativePattern(new String[]{"PUSH*", "POP*"}, new String[]{"MOV p1,p0"}));
        patterns.add(new NativePattern(new String[]{"PUSH X", "MOV C*|*[]*", "POP Y"}, new String[]{"{1}"}));
        patterns.add(new NativePattern(new String[]{"PUSH Y", "MOV Y,*", "POP X"}, new String[]{"MOV X,Y", "{1}"}));
        patterns.add(new NativePattern(new String[]{"MOV Y,#*", "MOV X,#-1{INTEGER}", "MUL X,Y"}, new String[]{"{0:MOV Y,#>MOV X,#-}"}));
        patterns.add(new NativePattern(new String[]{"MOV Y,*", "MOV X,Y"}, new String[]{"{0:MOV Y,>MOV X,}"}));
        patterns.add(new NativePattern(new String[]{"MOV B,*", "MOV A,B"}, new String[]{"{0:MOV B,>MOV A,}"}));
        patterns.add(new NativePattern(new String[]{"MOV Y*", "PUSH Y", "JSR COMPACT", "MOV A*", "POP X"}, new String[]{"{2}", "{3}", "{0:MOV Y,>MOV X,}"}));
        patterns.add(new NativePattern(new String[]{"MOV Y*", "PUSH Y", "JSR COMPACTMAX", "MOV A*", "POP X"}, new String[]{"{2}", "{3}", "{0:MOV Y,>MOV X,}"}));
        patterns.add(new NativePattern(new String[]{"MOV Y*", "PUSH Y", "MOV A*", "POP X"}, new String[]{"{2}", "{0:MOV Y,>MOV X,}"}));
        patterns.add(new NativePattern(new String[]{"PUSH X", "JSR COMPACT", "MOV A*", "POP X"}, new String[]{"{1}", "{2}"}));
        patterns.add(new NativePattern(new String[]{"PUSH X", "JSR COMPACTMAX", "MOV A*", "POP X"}, new String[]{"{1}", "{2}"}));
        patterns.add(new NativePattern(new String[]{"PUSH X", "MOV A*", "POP X"}, new String[]{"{1}"}));
        patterns.add(new NativePattern(new String[]{"MOV Y,X", "MOV X*", "ADD X,Y"}, new String[]{"{1:MOV X,>MOV Y,}", "{2}"}));
        patterns.add(new NativePattern(new String[]{"MOV Y,X", "MOV X*", "MUL X,Y"}, new String[]{"{1:MOV X,>MOV Y,}", "{2}"}));
        patterns.add(new NativePattern(new String[]{"PUSH C", "CHGCTX #1", "MOV B*", "POP C"}, new String[]{"{1}", "{2}"}));
        patterns.add(new NativePattern(new String[]{"MOV X,X"}, new String[0]));
        patterns.add(new NativePattern(new String[]{"MOV Y,Y"}, new String[0]));
        patterns.add(new NativePattern(new String[]{"PUSH X", "MOV X,#*", "POP Y"}, new String[]{"MOV Y,X", "{1}"}));
        patterns.add(new NativePattern(new String[]{"PUSH Y", "MOV X,#*", "POP Y"}, new String[]{"{1}"}));
        patterns.add(new NativePattern(new String[]{"MOV X,#*", "MOVB (Y),X"}, new String[]{"{0:MOV X,>MOVB (Y),}"}));
        patterns.add(new NativePattern(new String[]{"MOV Y,#*", "MOV G,Y"}, new String[]{"{0:MOV Y,>MOV G,}"}));
        patterns.add(new NativePattern(new String[]{"MOV X,#*", "MOV G,Y"}, new String[]{"{0:MOV X,>MOV G,}"}));
        patterns.add(new NativePattern(new String[]{"INT X,Y", "INT X,X"}, new String[]{"{0}"}));
        patterns.add(new NativePattern(new String[]{"POP C", "PUSH C"}, new String[0]));
        patterns.add(new NativePattern(new String[]{"PUSH C", "MOV C*", "PUSH C", "CHGCTX #1", "MOV B*", "POP D", "POP C"}, new String[]{"{1:MOV C,>MOV D,}", "{3}", "{4}"}));
        patterns.add(new NativePattern(new String[]{"MOV Y,?}", "POP X"}, new String[]{"{1}", "{0}"}));
        patterns.add(new NativePattern(new String[]{"PUSH X", "NOP", "POP X"}, new String[]{"NOP"}));
        patterns.add(new NativePattern(new String[]{"PUSH Y", "NOP", "POP Y"}, new String[]{"NOP"}));
        patterns.add(new NativePattern(new String[]{"MOV X,#-1{INTEGER}", "MUL X,Y"}, new String[]{"{0}", "NEG X,Y"}));
        patterns.add(new NativePattern(new String[]{"MOV Y,#-1{INTEGER}", "MUL X,Y"}, new String[]{"MOV Y,X", "NEG X,Y"}));
        patterns.add(new NativePattern(new String[]{"MOV C,X", "PUSH C"}, new String[]{"PUSH X"}));
        patterns.add(new NativePattern(new String[]{"PUSH C", "MOV Y,#*", "POP C"}, new String[]{"{1}"}));
        patterns.add(new NativePattern(new String[]{"MOV Y*", "MOV X*", "PUSH Y", "MOV G*", "CHGCTX #0", "JSR ARRAYACCESS", "POP Y"}, new String[]{"{1}", "{3}", "{4}", "{5}", "{0}"}));
    }

    public static List<String> optimizeNative(CompilerConfig config, List<String> code, ProgressListener pg) {
        if (config.isIntermediateLanguageOptimizations()) {
            Logger.log("Running intermediate code optimizer...");
            code = NativeOptimizer.optimizeNativeInternal(config, code, pg);
        }
        return code;
    }

    static List<String> optimizeNativeInternal(CompilerConfig config, List<String> code, ProgressListener pg) {
        if (config.isIntermediateLanguageOptimizations()) {
            int oldCode = 0;
            if (pg != null) {
                pg.start();
            }
            do {
                if (pg == null) continue;
                pg.nextStep();
            } while ((oldCode = code.size()) != (code = NativeOptimizer.applyPatterns(config, code)).size());
            if (pg != null) {
                pg.done();
            }
        }
        return code;
    }

    /*
     * Unable to fully structure code
     */
    private static List<String> applyPatterns(CompilerConfig config, List<String> code) {
        block47: {
            block38: {
                ret = new ArrayList<String>();
                lines = new String[19];
                splittedLines = new String[19][];
                if (code.size() <= 1) break block38;
                i = 0;
                while (i < code.size() - 1) {
                    block37: {
                        block46: {
                            block45: {
                                block41: {
                                    block44: {
                                        block43: {
                                            block42: {
                                                block39: {
                                                    block40: {
                                                        cont = false;
                                                        p = 0;
                                                        line0 = code.get(i);
                                                        while (p < 19 && p + i < code.size()) {
                                                            lines[p] = line = code.get(p + i);
                                                            splittedLines[p] = lines[p].split(" |,");
                                                            ++p;
                                                        }
                                                        while (p < 19) {
                                                            lines[p] = null;
                                                            splittedLines[p] = null;
                                                            ++p;
                                                        }
                                                        for (NativePattern pattern : NativeOptimizer.patterns) {
                                                            toReplace = pattern.getToReplace();
                                                            replaceWith = pattern.getReplaceWith();
                                                            match = true;
                                                            p = 0;
                                                            while (p < toReplace.length) {
                                                                if (lines[p] == null) {
                                                                    match = false;
                                                                    break;
                                                                }
                                                                sf = toReplace[p];
                                                                parts = sf.split("\\|");
                                                                subMatch = true;
                                                                var20_33 = parts;
                                                                var19_32 = parts.length;
                                                                var18_31 = 0;
                                                                while (var18_31 < var19_32) {
                                                                    sfs = var20_33[var18_31];
                                                                    sfo = sfs.replace("*", "");
                                                                    if (!sfo.contains("?")) ** GOTO lbl45
                                                                    pps = sfo.split("\\?");
                                                                    if (lines[p].startsWith(pps[0]) && lines[p].endsWith(pps[1])) {
                                                                        subMatch = true;
                                                                    } else {
                                                                        subMatch = false;
                                                                        break;
lbl45:
                                                                        // 1 sources

                                                                        if (sfs.startsWith("*") != false && sfs.endsWith("*") != false && lines[p].contains(sfo) != false || sfs.startsWith("*") != false && lines[p].endsWith(sfo) != false || sfs.endsWith("*") != false && lines[p].startsWith(sfo) != false || sfs.equals(lines[p])) {
                                                                            subMatch = true;
                                                                        } else {
                                                                            subMatch = false;
                                                                            break;
                                                                        }
                                                                    }
                                                                    ++var18_31;
                                                                }
                                                                match = subMatch;
                                                                if (!match) break;
                                                                ++p;
                                                            }
                                                            if (!match) continue;
                                                            p = 0;
                                                            while (p < replaceWith.length) {
                                                                rw = replaceWith[p];
                                                                rs = null;
                                                                if (rw != null && !rw.isEmpty()) {
                                                                    if (rw.startsWith("{") && rw.endsWith("}")) {
                                                                        pos = rw.indexOf(":");
                                                                        num = null;
                                                                        num = pos == -1 ? rw.substring(1, rw.length() - 1) : rw.substring(1, pos);
                                                                        rs = lines[Integer.parseInt(num)];
                                                                        if (pos != -1) {
                                                                            pos2 = rw.indexOf(">", pos);
                                                                            if (rw.indexOf("\u00a7", pos2) == -1) {
                                                                                rs = rs.replace(rw.substring(pos + 1, pos2), rw.substring(pos2 + 1, rw.length() - 1));
                                                                            } else {
                                                                                pos3 = rw.indexOf("\u00a7", pos2);
                                                                                fun = rw.substring(pos3 + 1, pos4 = rw.indexOf("\u00a7", pos3 + 1));
                                                                                if (fun.equalsIgnoreCase("chr")) {
                                                                                    rs = rs.replace(rw.substring(pos + 1, pos2), rw.substring(pos2 + 1, pos3));
                                                                                    pos3 = rs.indexOf(",");
                                                                                    rs = String.valueOf(rs.substring(0, pos3 + 1)) + "#{" + rs.substring(pos3 + 2, rs.indexOf("{", pos3)) + "}{STRING}";
                                                                                } else {
                                                                                    throw new RuntimeException("Unknown optimizer function: " + fun);
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                    if (rs == null) {
                                                                        rs = replaceWith[p];
                                                                        u = 0;
                                                                        while (u < 19 && splittedLines[u] != null) {
                                                                            if (splittedLines[u].length > 1) {
                                                                                rs = rs.replace("p" + u, splittedLines[u][1]);
                                                                            }
                                                                            ++u;
                                                                        }
                                                                    }
                                                                }
                                                                ret.add(rs);
                                                                ++p;
                                                            }
                                                            cont = true;
                                                            i += toReplace.length - 1;
                                                        }
                                                        if (cont) break block37;
                                                        if (!config.isIntOptimizations()) break block39;
                                                        if (!lines[0].equals("MOV Y,#1{INTEGER}") || !lines[1].startsWith("MOV X") || !lines[1].endsWith("%{INTEGER}") || !lines[2].equals("ADD X,Y")) break block40;
                                                        ret.add(lines[1]);
                                                        ret.add("JSR FINX");
                                                        i += 2;
                                                        break block37;
                                                    }
                                                    if (!lines[0].equals("MOV Y,#1{INTEGER}") || !lines[1].startsWith("MOV X") || !lines[1].endsWith("%{INTEGER}") || !lines[2].equals("SUB X,Y")) break block39;
                                                    ret.add(lines[1]);
                                                    ret.add("JSR FDEX");
                                                    i += 2;
                                                    break block37;
                                                }
                                                if (!config.isShiftOptimizations()) break block41;
                                                if (!lines[0].startsWith("MOV Y,#") || !lines[0].endsWith("{INTEGER}") && !lines[0].endsWith(".0{REAL}") || !lines[1].startsWith("MOV X,") || !lines[2].equals("DIV X,Y")) break block42;
                                                val = lines[0].replace("MOV Y,#", "").replace("{INTEGER}", "").replace(".0{REAL}", "");
                                                vf = Float.parseFloat(val);
                                                if ((vf = (float)(Math.log(vf) / Math.log(2.0))) != (float)((int)vf) || !(vf >= 1.0f) || !(vf <= 8.0f)) break block42;
                                                ret.add("MOV A,#" + (int)vf + "{INTEGER}");
                                                ret.add(lines[1]);
                                                ret.add("SHR X,A");
                                                i += 2;
                                                break block37;
                                            }
                                            if (!lines[0].startsWith("MOV Y,#") || !lines[0].endsWith("{INTEGER}") && !lines[0].endsWith(".0{REAL}") || !lines[1].startsWith("MOV X,") || !lines[2].equals("MUL X,Y")) break block43;
                                            val = lines[0].replace("MOV Y,#", "").replace("{INTEGER}", "").replace(".0{REAL}", "");
                                            vf = Float.parseFloat(val);
                                            if ((vf = (float)(Math.log(vf) / Math.log(2.0))) != (float)((int)vf) || !(vf >= 1.0f) || !(vf <= 8.0f)) break block43;
                                            ret.add("MOV A,#" + (int)vf + "{INTEGER}");
                                            ret.add(lines[1]);
                                            ret.add("SHL X,A");
                                            i += 2;
                                            break block37;
                                        }
                                        if (!lines[0].startsWith("MOV Y,#") || !lines[0].endsWith("{INTEGER}") && !lines[0].endsWith(".0{REAL}") || !lines[1].equals("DIV X,Y")) break block44;
                                        val = lines[0].replace("MOV Y,#", "").replace("{INTEGER}", "").replace(".0{REAL}", "");
                                        vf = Float.parseFloat(val);
                                        if ((vf = (float)(Math.log(vf) / Math.log(2.0))) != (float)((int)vf) || !(vf >= 1.0f) || !(vf <= 8.0f)) break block44;
                                        ret.add("MOV A,#" + (int)vf + "{INTEGER}");
                                        ret.add("SHR X,A");
                                        ++i;
                                        break block37;
                                    }
                                    if (!lines[0].startsWith("MOV Y,#") || !lines[0].endsWith("{INTEGER}") && !lines[0].endsWith(".0{REAL}") || !lines[1].equals("MUL X,Y")) break block41;
                                    val = lines[0].replace("MOV Y,#", "").replace("{INTEGER}", "").replace(".0{REAL}", "");
                                    vf = Float.parseFloat(val);
                                    if ((vf = (float)(Math.log(vf) / Math.log(2.0))) != (float)((int)vf) || !(vf >= 1.0f) || !(vf <= 8.0f)) break block41;
                                    ret.add("MOV A,#" + (int)vf + "{INTEGER}");
                                    ret.add("SHL X,A");
                                    ++i;
                                    break block37;
                                }
                                if (!lines[0].startsWith("MOV X,#") || !lines[1].startsWith("MOVB") || !lines[1].endsWith(",X") || lines[1].contains("(")) break block45;
                                ret.add(lines[1].replace(",X", lines[0].substring(lines[0].indexOf(","))));
                                ++i;
                                break block37;
                            }
                            if (lines[0].contains("INTEGER") && lines[0].startsWith("MOV Y,#") && (lines[1].equals("MOV X,(Y)") || lines[1].equals("MOVB X,(Y)"))) {
                                try {
                                    addr = Integer.parseInt(lines[0].substring(lines[0].indexOf("#") + 1, lines[0].indexOf("{")));
                                    if (lines[1].equals("MOVB X,(Y)")) {
                                        ret.add("MOVB X," + addr);
                                    } else {
                                        ret.add("MOV X," + addr);
                                    }
                                    ++i;
                                    break block37;
                                }
                                catch (Exception addr) {
                                    // empty catch block
                                }
                            }
                            if (splittedLines[0].length != 3 || splittedLines[1].length != 3) ** GOTO lbl-1000
                            if (!splittedLines[0][0].equals("MOV") || !splittedLines[0][2].equals("X")) break block46;
                            if (!splittedLines[1][1].equals("Y") || !splittedLines[0][1].equals(splittedLines[1][2]) || !splittedLines[0][1].contains("{")) ** GOTO lbl-1000
                            ret.add(lines[0]);
                            ret.add("MOV Y,X");
                            ++i;
                            break block37;
                        }
                        if (splittedLines[0][0].equals("MOV") && splittedLines[0][2].equals("Y") && splittedLines[1][1].equals("X") && splittedLines[0][1].equals(splittedLines[1][2]) && splittedLines[0][1].contains("{")) {
                            ret.add(lines[0]);
                            ret.add("MOV X,Y");
                            ++i;
                        } else if (splittedLines[2] != null && splittedLines[2].length > 2 && splittedLines[0].length > 2 && lines[3] != null && splittedLines[0][0].equals("MOV") && splittedLines[0][2].equals("X") && splittedLines[2][2].equals(splittedLines[0][1]) && lines[1].startsWith("MOV Y") && (lines[3].equals("ADD X,Y") || lines[3].equals("SUB X,Y") || lines[3].equals("MUL X,Y") || lines[3].equals("DIV X,Y"))) {
                            ret.add(lines[0]);
                            ret.add(lines[1]);
                            ret.add(lines[3]);
                            i += 3;
                        } else if (config.isLoopOptimizations() && lines[18] != null && lines[0].startsWith("MOV Y,") && (lines[0].endsWith("{INTEGER}") || lines[0].endsWith(".0{REAL}")) && lines[1].startsWith("MOV") && lines[1].endsWith(",Y") && lines[2].equals("NOP") && lines[3].startsWith("MOV Y,") && (lines[3].endsWith("{INTEGER}") || lines[3].endsWith(".0{REAL}")) && lines[4].equals("PUSH Y") && lines[5].equals("NOP") && lines[6].startsWith("MOV Y,") && (lines[6].endsWith("{INTEGER}") || lines[6].endsWith(".0{REAL}")) && lines[7].equals("PUSH Y") && lines[8].startsWith("MOV A,(") && lines[9].equals("JSR INITFOR") && lines[10].equals("NOP") && lines[11].startsWith("MOV Y,") && lines[12].equals("PUSH Y") && lines[13].startsWith("MOV X,") && lines[14].equals("POP Y") && lines[15].equals("MOVB (Y),X") && lines[16].equals("NOP") && lines[17].startsWith("MOV A,") && lines[18].equals("JSR NEXT") && lines[8].replace("(", "").replace(")", "").replace("A,", "Y,").equals(lines[11]) && (lines[17].contains(String.valueOf(var = (parts = lines[7].split(" |\\{"))[1]) + "{}") || lines[17].contains("#0{"))) {
                            ret.add(lines[0]);
                            ret.add(lines[1]);
                            ret.add(lines[3]);
                            ret.add(lines[4]);
                            ret.add(lines[6]);
                            ret.add(lines[7]);
                            ret.add(lines[8]);
                            ret.add(lines[13]);
                            ret.add("JSR FASTFOR");
                            i += 18;
                        } else {
                            rep = false;
                            var13_24 = new char[]{'C', 'D'};
                            var12_22 = var13_24.length;
                            var11_20 = 0;
                            while (var11_20 < var12_22) {
                                c = var13_24[var11_20];
                                if (lines[1].startsWith("MOV " + c + ",") && lines[0].startsWith("MOV ") && (r0 = lines[0].substring(4, pos = lines[0].indexOf(",")).trim()).equals(r1 = lines[1].substring(6).trim())) {
                                    right = lines[0].substring(pos + 1).trim();
                                    ret.add("MOV " + c + "," + right);
                                    rep = true;
                                    break;
                                }
                                ++var11_20;
                            }
                            if (!rep) {
                                ret.add(line0);
                            } else {
                                ++i;
                            }
                        }
                    }
                    ++i;
                }
                ret.add(code.get(code.size() - 1));
                break block47;
            }
            ret.addAll(code);
        }
        return ret;
    }

    private static class NativePattern {
        private String[] toReplace;
        private String[] replaceWith;

        public NativePattern(String[] toReplace, String[] replaceWith) {
            this.toReplace = toReplace;
            this.replaceWith = replaceWith;
        }

        public String[] getToReplace() {
            return this.toReplace;
        }

        public String[] getReplaceWith() {
            return this.replaceWith;
        }
    }
}

