/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.cbmnative;

import com.sixtyfour.elements.Type;
import java.util.HashSet;
import java.util.Set;

public class Operand {
    private static final Set<String> INT_REGS = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("A");
            this.add("B");
            this.add("G");
        }
    };
    private String register;
    private Type type;
    private String address;
    private String value;
    private boolean array;
    private boolean indexed;

    public String getRegister() {
        return this.register;
    }

    public String getRegisterName() {
        return String.valueOf(this.register) + "_REG";
    }

    public void setRegister(String register) {
        this.register = register;
        if (register != null) {
            this.type = Type.REAL;
            if (register.equalsIgnoreCase("A") || register.equalsIgnoreCase("B") || register.equalsIgnoreCase("G")) {
                this.type = Type.INTEGER;
            }
        }
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public boolean isConstant() {
        return this.address != null && this.address.startsWith("CONST");
    }

    public boolean isIntegerRegister() {
        return INT_REGS.contains(this.register);
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public void setIndexed(boolean indexed) {
        this.indexed = indexed;
    }

    public boolean isRegister() {
        return this.register != null;
    }

    public boolean isAddress() {
        return this.address != null;
    }

    public String toString() {
        return String.valueOf(this.register) + " / " + (Object)((Object)this.type) + " / " + this.address + " / " + this.indexed;
    }

    public boolean isArray() {
        return this.array;
    }

    public void setArray(boolean array) {
        this.array = array;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

