/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.cbmnative;

import com.sixtyfour.cbmnative.Operand;
import com.sixtyfour.elements.Type;
import java.util.Locale;
import java.util.Map;

public class Operands {
    private Operand target;
    private Operand source;

    public Operands(String command, Map<String, String> name2label) {
        int pos = command.indexOf(" ");
        if (pos == -1) {
            throw new RuntimeException("Can't parse command: " + command);
        }
        if ((pos = (command = command.substring(pos).trim()).indexOf(",")) == -1) {
            String left = command.trim();
            this.target = new Operand();
            this.fill(this.target, left, name2label);
            this.source = this.target;
        } else {
            String left = command.substring(0, pos).trim();
            String right = command.substring(pos + 1).trim();
            this.target = new Operand();
            this.source = new Operand();
            this.fill(this.target, left, name2label);
            this.fill(this.source, right, name2label);
        }
    }

    public Operand getTarget() {
        return this.target;
    }

    public void setTarget(Operand target) {
        this.target = target;
    }

    public Operand getSource() {
        return this.source;
    }

    public void setSource(Operand source) {
        this.source = source;
    }

    private void fill(Operand op, String txt, Map<String, String> name2label) {
        op.setIndexed(false);
        op.setAddress(null);
        op.setRegister(null);
        op.setArray(false);
        op.setType(this.getType(txt));
        String shorty = txt;
        int start = shorty.lastIndexOf("{");
        if (start != -1) {
            shorty = shorty.substring(0, start);
        }
        if (shorty.endsWith("[]")) {
            op.setArray(true);
        }
        if (txt.length() == 1 && !Character.isDigit(txt.charAt(0))) {
            op.setRegister(txt.toUpperCase(Locale.ENGLISH));
        } else {
            String otxt = txt;
            if (txt.startsWith("(")) {
                op.setIndexed(true);
                if (txt.endsWith("})")) {
                    String label;
                    txt = this.removeBrackets(txt);
                    if (op.getType() == Type.STRING && txt.startsWith("#")) {
                        txt = this.removePostfix(otxt);
                        txt = "$" + txt.substring(1);
                    }
                    op.setAddress((label = name2label.get(txt)) == null ? txt : label);
                    op.setValue(txt);
                } else {
                    txt = this.removeBrackets(txt);
                    op.setRegister(txt);
                }
            } else {
                String label;
                txt = this.removeBrackets(txt);
                if (op.getType() == Type.STRING && txt.startsWith("#")) {
                    txt = this.removePostfix(otxt);
                    txt = "$" + txt.substring(1);
                }
                op.setAddress((label = name2label.get(txt)) == null ? txt : label);
                op.setValue(txt);
            }
        }
    }

    private Type getType(String txt) {
        int end = txt.lastIndexOf("}");
        int start = txt.lastIndexOf("{");
        if (start != -1 && end != -1 && start + 1 != end) {
            String name = txt.substring(0, start);
            Type type = Type.valueOf(txt.substring(start + 1, end));
            if (name.startsWith("#")) {
                int num;
                name = name.substring(1);
                if (type == Type.INTEGER && ((num = Integer.parseInt(name)) < Short.MIN_VALUE || num > Short.MAX_VALUE)) {
                    name = String.valueOf(name) + ".0";
                    type = Type.REAL;
                }
            }
            return type;
        }
        if (txt.contains(".")) {
            return Type.REAL;
        }
        return Type.INTEGER;
    }

    private String removeBrackets(String txt) {
        txt = txt.replace("(", "").replace(")", "");
        txt = this.removePostfix(txt);
        return txt;
    }

    private String removePostfix(String txt) {
        int pos = txt.lastIndexOf("{");
        if (pos != -1) {
            txt = txt.substring(0, pos);
        }
        return txt;
    }
}

