/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.cbmnative;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Pattern
implements Cloneable {
    private static volatile int instanceCnt = 0;
    private int instance = instanceCnt++;
    private List<String> pattern;
    private List<Integer> spacePos;
    private List<Integer> partRightP0;
    private List<Integer> partRightP1;
    private List<String> command;
    private List<String> partP0;
    private List<Boolean> isJump;
    private List<String> partRights;
    private List<String> partRightsReg;
    private List<String> partLefts;
    private int pos = 0;
    private String[] regs = new String[10];
    private String[] mems = new String[10];
    private String[] consts = new String[10];
    private String[] replacement;
    private int index = -1;
    private int end = -1;
    private String name;
    private int loopCnt = 0;
    private boolean looseTypes = false;
    private boolean simple = true;
    private boolean skipComments = false;

    public Pattern(String name, String[] replacement, String ... parts) {
        this.pattern = new ArrayList<String>(Arrays.asList(parts));
        this.spacePos = new ArrayList<Integer>();
        this.command = new ArrayList<String>();
        this.isJump = new ArrayList<Boolean>();
        this.partP0 = new ArrayList<String>();
        this.partRights = new ArrayList<String>();
        this.partRightP0 = new ArrayList<Integer>();
        this.partRightP1 = new ArrayList<Integer>();
        this.partLefts = new ArrayList<String>();
        this.partRightsReg = new ArrayList<String>();
        for (String part : this.pattern) {
            int p0 = part.indexOf(" ");
            this.spacePos.add(p0);
            String ft = part.substring(0, 3);
            this.command.add(ft);
            this.partP0.add(p0 != -1 ? part.substring(0, p0) : null);
            String pr = part.substring(p0 + 1).trim();
            this.partRights.add(pr);
            int prP0 = pr.indexOf("{");
            this.partRightP0.add(prP0);
            this.partLefts.add(prP0 != -1 ? pr.substring(0, prP0) : null);
            int prP1 = pr.lastIndexOf("}");
            this.partRightP1.add(prP1);
            this.partRightsReg.add(prP1 != -1 && prP0 != -1 ? pr.substring(prP0 + 1, prP1) : null);
            this.isJump.add(ft.equals("JSR") || ft.equals("JMP") || ft.equals("BEQ") || ft.endsWith("JMP") || ft.equals("BNE") || ft.equals("BCC") || ft.equals("BCS"));
        }
        this.replacement = replacement;
        this.name = name;
    }

    public Pattern(boolean simple, String name, String[] replacement, String ... parts) {
        this(name, replacement, parts);
        this.simple = simple;
    }

    public Pattern(String name, boolean looseTypes, String[] replacement, String ... parts) {
        this(name, replacement, parts);
        this.looseTypes = looseTypes;
    }

    public int getPos() {
        return this.pos;
    }

    public String getCurrentLine() {
        return this.pattern.get(this.pos);
    }

    public String getName() {
        return this.name;
    }

    public List<String> apply(List<String> code) {
        if (this.pos == this.pattern.size()) {
            List<String> first = code.subList(0, this.index);
            List<String> last = code.subList(this.end + 1, code.size());
            String[] replacement = null;
            boolean cntInc = false;
            if (this.replacement != null) {
                replacement = Arrays.copyOf(this.replacement, this.replacement.length);
                ArrayList<String> sub = new ArrayList<String>();
                for (String subline : code.subList(this.index, this.end + 1)) {
                    if (subline.startsWith(";")) continue;
                    sub.add(subline);
                }
                int i = 0;
                while (i < replacement.length) {
                    int pos;
                    String from = "";
                    String to = "";
                    if (replacement[i].contains("|")) {
                        pos = replacement[i].indexOf("|");
                        int pos2 = replacement[i].indexOf(">", pos);
                        from = replacement[i].substring(pos + 1, pos2).trim();
                        to = replacement[i].substring(pos2 + 1).trim();
                        replacement[i] = replacement[i].substring(0, pos).trim();
                    }
                    if (replacement[i].startsWith("{LINE")) {
                        String postFix = "";
                        if (!replacement[i].endsWith("}")) {
                            int pos2 = replacement[i].indexOf("}");
                            postFix = replacement[i].substring(pos2 + 1);
                            replacement[i] = replacement[i].substring(0, pos2 + 1);
                        }
                        int num = Integer.parseInt(replacement[i].substring(5, replacement[i].length() - 1));
                        replacement[i] = String.valueOf((String)sub.get(num)) + postFix;
                    } else {
                        pos = replacement[i].indexOf("{REG");
                        if (pos != -1) {
                            this.replace(replacement, i, pos, 4, this.regs);
                        } else {
                            pos = replacement[i].indexOf("{CONST");
                            if (pos != -1) {
                                this.replace(replacement, i, pos, 6, this.consts);
                            } else {
                                pos = replacement[i].indexOf("{MEM");
                                if (pos != -1) {
                                    this.replace(replacement, i, pos, 4, this.mems);
                                } else {
                                    pos = replacement[i].indexOf("{cnt}");
                                    if (pos != -1) {
                                        if (!cntInc) {
                                            cntInc = true;
                                            ++this.loopCnt;
                                        }
                                        replacement[i] = replacement[i].replace("{cnt}", String.valueOf(this.instance) + "_" + this.loopCnt);
                                    }
                                }
                            }
                        }
                    }
                    replacement[i] = replacement[i].replace(from, to);
                    ++i;
                }
            }
            ArrayList eternity = replacement != null ? new ArrayList(Arrays.asList(replacement)) : new ArrayList();
            eternity.add("; Optimizer rule: " + this.name + "/" + (replacement == null ? 0 : replacement.length));
            ArrayList<String> res = new ArrayList<String>(first);
            res.addAll(eternity);
            res.addAll(last);
            this.resetPattern();
            return res;
        }
        this.resetPattern();
        return code;
    }

    public boolean matches(String line, int ix, Map<String, Number> const2Value) {
        if (line.startsWith(";")) {
            return false;
        }
        String part = this.pattern.get(this.pos);
        int p0 = this.spacePos.get(this.pos);
        int p1 = line.indexOf(" ");
        if (p0 == -1 && p1 == -1 && part.equalsIgnoreCase(line)) {
            return this.inc(ix);
        }
        if (part.equals("{LABEL}") && line.endsWith(":")) {
            return this.inc(ix);
        }
        String ft = this.command.get(this.pos);
        if (this.isJump.get(this.pos).booleanValue() && part.endsWith("{*}") && line.startsWith(ft)) {
            String stripped = part.replaceFirst(ft, "").trim().replace("{*}", "").trim();
            String sline = line.replaceFirst(ft, "").trim();
            if (stripped.isEmpty() || sline.startsWith(stripped)) {
                return this.inc(ix);
            }
        }
        if (p0 != -1 && p1 != -1 && !line.contains("SKIP") && this.partP0.get(this.pos).equalsIgnoreCase(line.substring(0, p1))) {
            String lineRight;
            String partRight = this.partRights.get(this.pos);
            if (partRight.equalsIgnoreCase(lineRight = line.substring(p1 + 1).trim())) {
                return this.inc(ix);
            }
            p0 = this.partRightP0.get(this.pos);
            if (p0 != -1) {
                String leftPart = this.partLefts.get(this.pos);
                if (lineRight.startsWith(leftPart)) {
                    p1 = this.partRightP1.get(this.pos);
                    String reg = this.partRightsReg.get(this.pos);
                    if (reg.equals("*")) {
                        return this.inc(ix);
                    }
                    if (reg.startsWith("#")) {
                        String num = reg.substring(1);
                        boolean isReal = num.contains(".");
                        double val = Double.parseDouble(num);
                        if (!isReal) {
                            val = (int)val;
                        }
                        int pos = lineRight.indexOf("CONST_");
                        if (lineRight.equals(reg) || pos != -1 && const2Value.containsKey(lineRight.substring(pos)) && const2Value.get(lineRight.substring(pos)).doubleValue() == val) {
                            return this.inc(ix);
                        }
                        return this.resetPattern();
                    }
                    String value = lineRight.substring(p0);
                    if (reg.startsWith("REG") && lineRight.contains("_REG")) {
                        int num = Integer.parseInt(reg.substring(3));
                        int pv = value.lastIndexOf("+");
                        if (pv != -1) {
                            value = value.substring(0, pv);
                        }
                        if (this.regs[num] == null) {
                            this.regs[num] = value;
                            return this.inc(ix);
                        }
                        if (this.regs[num].equalsIgnoreCase(value)) {
                            return this.inc(ix);
                        }
                        return this.resetPattern();
                    }
                    if (reg.startsWith("MEM") && (lineRight.contains("VAR_") || lineRight.contains("CONST_") || this.isNumber(lineRight))) {
                        int num;
                        int pv = value.lastIndexOf("+");
                        if (pv != -1) {
                            value = value.substring(0, pv);
                        }
                        if (this.mems[num = Integer.parseInt(reg.substring(3))] == null) {
                            this.mems[num] = value;
                            return this.inc(ix);
                        }
                        if (this.mems[num].equalsIgnoreCase(value)) {
                            return this.inc(ix);
                        }
                        return this.resetPattern();
                    }
                    if (reg.startsWith("CONST") && lineRight.contains("CONST_")) {
                        int num;
                        int pv = value.lastIndexOf("+");
                        if (pv != -1) {
                            value = value.substring(0, pv);
                        }
                        if (this.consts[num = Integer.parseInt(reg.substring(5))] == null) {
                            this.consts[num] = value;
                            return this.inc(ix);
                        }
                        if (this.consts[num].equalsIgnoreCase(value)) {
                            return this.inc(ix);
                        }
                        return this.resetPattern();
                    }
                    return this.resetPattern();
                }
                return this.resetPattern();
            }
            return this.resetPattern();
        }
        return this.resetPattern();
    }

    private void replace(String[] replacement, int i, int pos, int offset, String[] values) {
        int endi = replacement[i].indexOf("}");
        int posi = Integer.parseInt(replacement[i].substring(pos + offset, endi));
        String fp = replacement[i].substring(0, pos);
        if (!fp.endsWith("#<") && !fp.endsWith("#>")) {
            fp = String.valueOf(fp) + " ";
        }
        if (fp.endsWith("  ")) {
            fp = fp.substring(0, fp.length() - 1);
        }
        replacement[i] = String.valueOf(fp) + values[posi] + (endi < replacement[i].length() - 1 ? replacement[i].substring(endi + 1) : "");
    }

    private boolean isNumber(String lineRight) {
        int i = 0;
        while (i < lineRight.length()) {
            char c = lineRight.charAt(i);
            if (c < '0' || c > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean resetPattern() {
        this.pos = 0;
        this.index = -1;
        this.end = -1;
        this.clearArray(this.regs);
        this.clearArray(this.mems);
        this.clearArray(this.consts);
        return false;
    }

    private void clearArray(String[] array) {
        int i = 0;
        while (i < array.length) {
            array[i] = null;
            ++i;
        }
    }

    private boolean inc(int ix) {
        ++this.pos;
        if (this.index == -1) {
            this.index = ix;
        }
        this.end = ix;
        return this.pos == this.pattern.size();
    }

    public boolean isLooseTypes() {
        return this.looseTypes;
    }

    public void setLooseTypes(boolean looseTypes) {
        this.looseTypes = looseTypes;
    }

    public boolean isSimple() {
        return this.simple;
    }

    public void setSimple(boolean simple) {
        this.simple = simple;
    }

    public int getSourceSize() {
        return this.pattern.size();
    }

    public boolean isSkipComments() {
        return this.skipComments;
    }

    public void setSkipComments(boolean skipComments) {
        this.skipComments = skipComments;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

