/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.cbmnative;

import com.sixtyfour.Logger;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.Variable;
import com.sixtyfour.elements.functions.Asc;
import com.sixtyfour.elements.functions.Chr;
import com.sixtyfour.elements.functions.Function;
import com.sixtyfour.elements.functions.Left;
import com.sixtyfour.elements.functions.Len;
import com.sixtyfour.elements.functions.Mid;
import com.sixtyfour.elements.functions.Pos;
import com.sixtyfour.elements.functions.Right;
import com.sixtyfour.elements.functions.Spc;
import com.sixtyfour.elements.functions.Str;
import com.sixtyfour.elements.functions.Tab;
import com.sixtyfour.elements.functions.Val;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.plugins.DeviceProvider;
import com.sixtyfour.plugins.SystemCallListener;
import com.sixtyfour.system.DataStore;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.ConstantExtractor;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PseudoCpu {
    private static final int MEM_SIZE = 32768;
    private static final int PRG_START = 2064;
    private static final int A = 5;
    private static final int B = 6;
    private static final int C = 7;
    private static final int D = 8;
    private static final int E = 9;
    private static final int F = 10;
    private static final int G = 11;
    private static final int X = 0;
    private static final int Y = 1;
    private Deque<Number> stack = new LinkedList<Number>();
    private Deque<Number> jumpStack = new LinkedList<Number>();
    private byte[] forStack = new byte[1024];
    private int forStackPos;
    private Number[] regs = new Number[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private Machine machine;
    private CompilerConfig config;
    private boolean zeroFlag = false;
    private boolean halt = false;
    private int[] memory = null;
    private int addr = 0;
    private int datasAddr = 32768;
    private int datasPointer = 32768;
    private int datasSize = 0;
    private int emptyReal = 0;
    private int emptyString = 0;
    private int emptyInteger = 0;
    private int dynamicStart = 0;
    private int initialJumpStackSize = 0;
    private int outputChannel = 0;
    private List<String> inputQueue = new ArrayList<String>();
    private int jumpTargetAddr = 32764;
    private Map<String, Integer> memLocations = new HashMap<String, Integer>();
    private Map<Integer, String> varLocations = new HashMap<Integer, String>();
    private List<String> stringNames = new ArrayList<String>();
    private int memPointer = 0;
    private int stringStart = 0;
    private int bufferPos = 32768;
    private int bufferStart = 32768;
    private Function chr = new Chr();
    private Function asc = new Asc();
    private Function str = new Str();
    private Function val = new Val();
    private Function len = new Len();
    private Function mid = new Mid();
    private Function left = new Left();
    private Function right = new Right();
    private Function pos = new Pos();
    private Function tab = new Tab();
    private Function spc = new Spc();
    private Map<String, Long> label2line = new HashMap<String, Long>();
    private SystemCallListener callListener = null;
    private int memoryLimit = 32768;
    private boolean sharedRam = false;
    private Map<String, Integer> constMap = ConstantExtractor.getAllConstantMaps();

    public final synchronized void execute(CompilerConfig config, Machine machine, List<String> code) {
        Tab.setLimitedToPrint(false);
        Spc.setLimitedToPrint(false);
        this.machine = machine;
        this.config = config;
        this.stack.clear();
        this.label2line.clear();
        this.memLocations.clear();
        this.varLocations.clear();
        this.inputQueue.clear();
        this.outputChannel = 0;
        this.zeroFlag = false;
        this.addr = 0;
        this.datasSize = 0;
        this.emptyReal = 0;
        this.emptyString = 0;
        this.emptyInteger = 0;
        this.forStackPos = 0;
        this.stringStart = 0;
        this.bufferPos = 32768;
        this.bufferStart = 32768;
        this.datasAddr = 32768;
        this.datasPointer = 32768;
        this.halt = false;
        this.regs = new Number[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        this.memory = new int[65536];
        this.memPointer = 2064;
        if (this.memory.length == machine.getRam().length) {
            this.memory = machine.getRam();
            this.sharedRam = true;
        } else {
            System.arraycopy(machine.getRam(), 0, this.memory, 0, this.memory.length);
            this.sharedRam = false;
        }
        this.createDatas();
        this.createEmtpyVariables();
        this.createVariables();
        this.createStringConstants(code);
        this.createArrays();
        this.createStringVariables();
        this.dynamicStart = this.memPointer;
        long cnt = 0L;
        for (String line : code) {
            String[] parts = line.split(" ");
            if (parts.length > 0 && parts[0].endsWith(":")) {
                this.label2line.put(parts[0], cnt);
            }
            ++cnt;
        }
        this.addr = 0;
        ArrayList<String[]> splittedCode = new ArrayList<String[]>();
        for (String line : code) {
            splittedCode.add(this.split(line, " "));
        }
        do {
            this.executeCommand(code, splittedCode);
        } while (!this.halt && this.addr < code.size());
    }

    public int getMemoryLimit() {
        return this.memoryLimit;
    }

    public void setMemoryLimit(int memoryLimit) {
        this.memoryLimit = memoryLimit;
    }

    public void compactMemory() {
        this.collectGarbage();
    }

    public Deque<Number> getStack() {
        return this.stack;
    }

    public String getStringFromStack() {
        Integer num = (Integer)this.stack.pop();
        return this.readString(num);
    }

    public Object getVariableValue(String name) {
        if ((name = name.toUpperCase(Locale.ENGLISH)).contains("$")) {
            return this.readString(this.memLocations.get(name));
        }
        return this.machine.getVariable(name).eval(this.machine);
    }

    public Object getVariableValue(String name, int ... pos) {
        if (!(name = name.toUpperCase(Locale.ENGLISH)).endsWith("[]")) {
            name = String.valueOf(name) + "[]";
        }
        Variable var = this.machine.getVariable(name);
        int offset = this.calcArrayOffset(var, pos);
        int val = this.memLocations.get(name) + 2 + offset;
        if (name.contains("$")) {
            return this.readString(this.memory[val]);
        }
        if (name.contains("%")) {
            return this.memory[val];
        }
        return Float.valueOf(Float.intBitsToFloat(this.memory[val]));
    }

    public int[] getRam() {
        return this.memory;
    }

    public SystemCallListener getSystemCallListener() {
        return this.callListener;
    }

    public void setSystemCallListener(SystemCallListener callListener) {
        this.callListener = callListener;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void executeCommand(List<String> code, List<String[]> splittedCode) {
        String[] parts = splittedCode.get(this.addr++);
        try {
            if (parts.length <= 0) return;
            if (parts[0].endsWith(":") && (Character.isDigit(parts[0].charAt(parts[0].length() - 2)) || parts[0].startsWith("PROGRAM"))) {
                return;
            }
            switch (parts[0]) {
                case "MOV": {
                    this.mov(parts);
                    return;
                }
                case "MOVB": {
                    this.mov(parts);
                    return;
                }
                case "PUSH": {
                    this.push(parts);
                    return;
                }
                case "POP": {
                    this.pop(parts);
                    return;
                }
                case "MUL": {
                    this.mul(parts);
                    return;
                }
                case "NEG": {
                    this.neg(parts);
                    return;
                }
                case "DIV": {
                    this.div(parts);
                    return;
                }
                case "SHR": {
                    this.shr(parts);
                    return;
                }
                case "SHL": {
                    this.shl(parts);
                    return;
                }
                case "SUB": {
                    this.sub(parts);
                    return;
                }
                case "ADD": {
                    this.add(parts);
                    return;
                }
                case "AND": {
                    this.and(parts);
                    return;
                }
                case "XOR": {
                    this.xor(parts);
                    return;
                }
                case "NOT": {
                    this.not(parts);
                    return;
                }
                case "OR": {
                    this.or(parts);
                    return;
                }
                case "POW": {
                    this.pow(parts);
                    return;
                }
                case "SIN": {
                    this.sin(parts);
                    return;
                }
                case "COS": {
                    this.cos(parts);
                    return;
                }
                case "LOG": {
                    this.log(parts);
                    return;
                }
                case "SQR": {
                    this.sqr(parts);
                    return;
                }
                case "INT": {
                    this.inty(parts);
                    return;
                }
                case "ABS": {
                    this.abs(parts);
                    return;
                }
                case "SGN": {
                    this.sgn(parts);
                    return;
                }
                case "TAN": {
                    this.tan(parts);
                    return;
                }
                case "ATN": {
                    this.atn(parts);
                    return;
                }
                case "EXP": {
                    this.exp(parts);
                    return;
                }
                case "RND": {
                    this.rnd(parts);
                    return;
                }
                case "SWAP": {
                    this.swap(parts);
                    return;
                }
                case "JSR": {
                    this.jsr(parts);
                    return;
                }
                case "JMP": {
                    this.jmp(parts);
                    return;
                }
                case "JE": {
                    this.je(parts);
                    return;
                }
                case "JNE": {
                    this.jne(parts);
                    return;
                }
                case "RTS": {
                    this.rts(parts);
                    return;
                }
                case "BRK": {
                    this.halt = true;
                    return;
                }
                case "CHGCTX": {
                    this.nop(parts);
                    return;
                }
                case "EQ": {
                    this.equal(parts);
                    return;
                }
                case "CMP": {
                    this.compare(parts);
                    return;
                }
                case "NEQ": {
                    this.notEqual(parts);
                    return;
                }
                case "GT": {
                    this.greaterThan(parts);
                    return;
                }
                case "LT": {
                    this.lowerThan(parts);
                    return;
                }
                case "GTEQ": {
                    this.greaterThanOrEqual(parts);
                    return;
                }
                case "LTEQ": {
                    this.lowerThanOrEqual(parts);
                    return;
                }
                default: {
                    throw new RuntimeException("Unknown instruction: " + parts[0]);
                }
                case "NOP": {
                    return;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while executing: " + code.get(this.addr - 1) + "/" + this.addr, e);
        }
    }

    private String[] split(String line, String delimiter) {
        int pos = line.indexOf(delimiter);
        if (pos != -1) {
            String[] parts = new String[]{line.substring(0, pos), line.substring(pos + delimiter.length())};
            return parts;
        }
        return new String[]{line};
    }

    private void createStringConstants(List<String> code) {
        for (String line : code) {
            String val;
            String op;
            if (!line.startsWith("MOV") || !(op = this.split(line, ",")[1]).endsWith("{STRING}") || !op.startsWith("#") || this.memLocations.containsKey("#" + (val = op.substring(1, op.lastIndexOf("{"))))) continue;
            System.arraycopy(this.toIntArray(val), 0, this.memory, this.memPointer + 1, val.length());
            this.memory[this.memPointer] = val.length();
            this.memLocations.put("#" + val, this.memPointer);
            this.memPointer += val.length() + 1;
            if (this.memPointer <= 32768) continue;
            throw new RuntimeException("Out of memory error: " + val + "/" + this.memPointer);
        }
    }

    private void createVariables() {
        Map<String, Variable> vars = this.machine.getVariables();
        for (Map.Entry<String, Variable> entry : vars.entrySet()) {
            String name = entry.getKey();
            Variable var = entry.getValue();
            if (var.getType() == Type.STRING) continue;
            this.varLocations.put(System.identityHashCode(var), name);
        }
    }

    private void createEmtpyVariables() {
        this.emptyString = this.memPointer;
        this.storeString(null, "");
        this.emptyInteger = this.memPointer++;
        this.memory[this.emptyInteger] = 0;
        this.emptyReal = this.memPointer++;
        this.memory[this.emptyReal] = Float.floatToIntBits(0.0f);
    }

    private void createStringVariables() {
        this.stringStart = this.memPointer;
        Map<String, Variable> vars = this.machine.getVariables();
        for (Map.Entry<String, Variable> entry : vars.entrySet()) {
            String name = entry.getKey();
            Variable var = entry.getValue();
            if (!name.endsWith("$") || name.equals("TI$")) continue;
            String val = (String)var.eval(this.machine);
            if (this.memLocations.containsKey(name)) {
                throw new RuntimeException("Variable defined twice: " + name);
            }
            this.stringNames.add(name);
            if (val.isEmpty()) {
                this.memLocations.put(name, this.emptyString);
                continue;
            }
            this.storeString(name, val);
        }
    }

    private void createDatas() {
        this.datasAddr = this.memPointer++;
        DataStore datas = this.machine.getDataStore();
        datas.restore();
        Object obj = null;
        while ((obj = datas.read()) != null) {
            Type type = Type.STRING;
            if (VarUtils.isInteger(obj)) {
                type = Type.INTEGER;
            } else if (VarUtils.isFloat(obj) || VarUtils.isDouble(obj)) {
                type = Type.REAL;
            }
            if (obj.toString().equals("\\0")) {
                obj = "";
            }
            if (type == Type.INTEGER) {
                this.memory[this.memPointer++] = 0;
                this.memory[this.memPointer++] = Integer.valueOf(obj.toString());
                continue;
            }
            if (type == Type.REAL) {
                this.memory[this.memPointer++] = 1;
                this.memory[this.memPointer++] = Float.floatToIntBits(Float.valueOf(obj.toString()).floatValue());
                continue;
            }
            this.memory[this.memPointer++] = 2;
            this.storeString(null, obj.toString());
        }
        this.memory[this.datasAddr] = this.memPointer - this.datasAddr;
        this.restore(null);
    }

    private void createArrays() {
        Map<String, Variable> vars = this.machine.getVariables();
        for (Map.Entry<String, Variable> entry : vars.entrySet()) {
            String name = entry.getKey();
            Variable var = entry.getValue();
            if (!var.isArray()) continue;
            List vals = (List)var.getInternalValue();
            int[] mems = new int[vals.size()];
            int pos = 0;
            for (Object val : vals) {
                if (!VarUtils.isString(val)) continue;
                if (!val.toString().isEmpty()) {
                    mems[pos++] = this.memPointer;
                    this.storeString(null, val.toString());
                    continue;
                }
                mems[pos++] = this.emptyString;
            }
            if (this.memLocations.containsKey(name)) {
                throw new RuntimeException("Variable defined twice: " + name);
            }
            this.memLocations.put(name, this.memPointer);
            boolean flagged = false;
            pos = 0;
            for (Object val : vals) {
                if (VarUtils.isFloat(val)) {
                    if (!flagged) {
                        this.memory[this.memPointer++] = 1;
                        this.memory[this.memPointer++] = vals.size();
                        flagged = true;
                    }
                    this.memory[this.memPointer++] = Float.floatToIntBits(((Float)val).floatValue());
                    continue;
                }
                if (VarUtils.isDouble(val)) {
                    if (!flagged) {
                        this.memory[this.memPointer++] = 1;
                        this.memory[this.memPointer++] = vals.size();
                        flagged = true;
                    }
                    this.memory[this.memPointer++] = Float.floatToIntBits(((Double)val).floatValue());
                    continue;
                }
                if (VarUtils.isInteger(val)) {
                    if (!flagged) {
                        this.memory[this.memPointer++] = 0;
                        this.memory[this.memPointer++] = vals.size();
                        flagged = true;
                    }
                    this.memory[this.memPointer++] = (Integer)val;
                    continue;
                }
                if (!flagged) {
                    this.memory[this.memPointer++] = 2;
                    this.memory[this.memPointer++] = vals.size();
                    flagged = true;
                    this.stringNames.add(name);
                }
                int addr = mems[pos++];
                this.memory[this.memPointer++] = addr;
            }
        }
    }

    private void storeString(String name, String val) {
        this.storeString(name, val, 0);
    }

    private void storeString(String name, String val, int bufferPos) {
        if (bufferPos == 0 && this.memPointer + val.length() + 1 > 32768) {
            throw new RuntimeException("Out of memory error: " + val + "/" + this.memPointer);
        }
        if (val.length() > 0) {
            System.arraycopy(this.toIntArray(val), 0, this.memory, bufferPos == 0 ? this.memPointer + 1 : bufferPos + 1, val.length());
        }
        this.memory[bufferPos == 0 ? this.memPointer : bufferPos] = val.length();
        if (name != null) {
            this.memLocations.put(name, this.memPointer);
        }
        if (bufferPos == 0) {
            this.memPointer += val.length() + 1;
        }
    }

    private int[] toIntArray(String val) {
        char[] chars = val.toCharArray();
        int[] ret = new int[chars.length];
        int i = 0;
        while (i < chars.length) {
            ret[i] = chars[i];
            ++i;
        }
        return ret;
    }

    private int calcArrayOffset(Variable var, int ... pos) {
        int ap = 0;
        int cnt = 0;
        if (pos.length == 1) {
            ap = pos[0];
        } else {
            int m = 1;
            int[] nArray = pos;
            int n = pos.length;
            int n2 = 0;
            while (n2 < n) {
                int p = nArray[n2];
                ap += m * p;
                m *= var.getDimensions()[cnt] + 1;
                ++cnt;
                ++n2;
            }
        }
        return ap;
    }

    private String readString(Integer num) {
        if (this.memory[num] == 0) {
            return "";
        }
        return new String(this.memory, num + 1, this.memory[num]);
    }

    private void nop(String[] parts) {
    }

    private void jmp(String[] parts) {
        String addry = parts[1].trim();
        try {
            this.jumpTo(addry);
        }
        catch (Exception e) {
            if (this.callListener != null) {
                try {
                    if (addry.startsWith("$")) {
                        addry = String.valueOf(Integer.parseInt(addry.substring(1, addry.length()), 16));
                    }
                    this.callListener.sys(Integer.valueOf(addry), new Object[0]);
                    this.jumpStack.pop();
                }
                catch (Exception e2) {
                    throw new RuntimeException("Undefined call address: " + parts[1]);
                }
            }
            throw new RuntimeException("Undefined call address: " + parts[1]);
        }
    }

    private void je(String[] parts) {
        if (this.zeroFlag) {
            this.condJump(parts);
        }
    }

    private void jne(String[] parts) {
        if (!this.zeroFlag) {
            this.condJump(parts);
        }
    }

    private void condJump(String[] parts) {
        String addry = parts[1].trim();
        try {
            if (addry.startsWith("(") && addry.endsWith(")")) {
                addry = addry.contains("$JUMP") ? String.valueOf(32764) : addry.substring(1, addry.length() - 1);
                int ia = Integer.parseInt(addry);
                this.addr = (this.memory[ia] & 0xFF) + ((this.memory[ia + 1] & 0xFF) << 8) + ((this.memory[ia + 2] & 0xFF) << 16) + ((this.memory[ia + 3] & 0xFF) << 24);
            } else {
                this.jumpTo(addry);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Undefined call address: " + parts[1] + " in " + (this.addr - 1));
        }
    }

    private void jsr(String[] parts) {
        switch (parts[1]) {
            case "CONCAT": {
                this.concat(parts);
                return;
            }
            case "CHR": {
                this.chr(parts);
                return;
            }
            case "EXTRAIGNORED": {
                this.strOutAbs("?extra ignored", 0);
                return;
            }
            case "USR": {
                this.usr(parts);
                return;
            }
            case "ASC": {
                this.asc(parts);
                return;
            }
            case "STR": {
                this.str(parts);
                return;
            }
            case "FRE": {
                this.intOut(parts, 0);
                return;
            }
            case "VAL": {
                this.val(parts);
                return;
            }
            case "TABOUT": {
                this.regs[1] = 1;
                this.tab(parts);
                return;
            }
            case "LEN": {
                this.len(parts);
                return;
            }
            case "MID": {
                this.mid(parts);
                return;
            }
            case "BUFFERRESET": {
                return;
            }
            case "LEFT": {
                this.left(parts);
                return;
            }
            case "RIGHT": {
                this.right(parts);
                return;
            }
            case "CRSRRIGHT": {
                this.crsrright(parts, 0);
                return;
            }
            case "TABCHANNEL": 
            case "TAB": {
                this.tab(parts);
                return;
            }
            case "SPC": 
            case "SPCCHANNEL": {
                this.spc(parts);
                return;
            }
            case "POS": {
                this.pos(parts);
                return;
            }
            case "ARRAYACCESS": {
                this.arrayAccess(parts);
                return;
            }
            case "ARRAYSTORE": {
                this.arrayStore(parts);
                return;
            }
            case "COMPACT": {
                this.collectGarbage();
                return;
            }
            case "COMPACTMAX": {
                this.collectGarbage();
                return;
            }
            case "CHECKCMD": {
                return;
            }
            case "SEQ": {
                this.strEqual(parts);
                return;
            }
            case "SNEQ": {
                this.strNotEqual(parts);
                return;
            }
            case "SGT": {
                this.strGreaterThan(parts);
                return;
            }
            case "SLT": {
                this.strLowerThan(parts);
                return;
            }
            case "SGTEQ": {
                this.strGreaterThanOrEqual(parts);
                return;
            }
            case "SLTEQ": {
                this.strLowerThanOrEqual(parts);
                return;
            }
            case "INTOUT": {
                this.intOut(parts, 0);
                return;
            }
            case "REALOUT": {
                this.realOut(parts, 0);
                return;
            }
            case "STROUT": {
                this.strOut(parts, 0);
                return;
            }
            case "QMARKOUT1": {
                this.qMarkOut1(parts, 0);
                return;
            }
            case "QMARKOUT2": {
                this.qMarkOut2(parts, 0);
                return;
            }
            case "LINEBREAK": {
                this.lineBreak(parts, 0);
                return;
            }
            case "INTOUTCHANNEL": {
                this.intOutChannel(parts);
                return;
            }
            case "REALOUTCHANNEL": {
                this.realOutChannel(parts);
                return;
            }
            case "STROUTCHANNEL": {
                this.strOutChannel(parts);
                return;
            }
            case "LINEBREAKCHANNEL": {
                this.lineBreakChannel(parts);
                return;
            }
            case "INITFOR": {
                this.initFor(parts);
                return;
            }
            case "FASTFOR": {
                this.fastFor(parts);
                return;
            }
            case "NEXT": {
                this.next(parts);
                return;
            }
            case "GOSUB": {
                this.gosub(parts);
                return;
            }
            case "RETURN": {
                this.returny(parts);
                return;
            }
            case "COPYSTR": {
                this.copyString(parts);
                return;
            }
            case "RESTORE": {
                this.restore(parts);
                return;
            }
            case "RESTARTPRG": {
                this.restart(parts);
                return;
            }
            case "READSTR": {
                this.readString(parts);
                return;
            }
            case "READNUMBER": {
                this.readNumber(parts);
                return;
            }
            case "GETSTR": {
                this.getString(parts);
                return;
            }
            case "GETNUMBER": {
                this.getNumber(parts);
                return;
            }
            case "GETSTRCHANNEL": {
                this.getStringChannel(parts);
                return;
            }
            case "GETNUMBERCHANNEL": {
                this.getNumberChannel(parts);
                return;
            }
            case "CMD": {
                this.cmd(parts);
                return;
            }
            case "OPEN": {
                this.open(parts);
                return;
            }
            case "VPEEK": {
                this.vpeek(parts);
                return;
            }
            case "JOY": {
                return;
            }
            case "COLOR": {
                return;
            }
            case "CLS": {
                return;
            }
            case "SYSTEMCALLDYN": {
                return;
            }
            case "SETUPMULTIPARS": {
                return;
            }
            case "COPYSTRINGPAR": {
                return;
            }
            case "COPYREALPAR": {
                return;
            }
            case "ADDCOLON": {
                return;
            }
            case "PULLDOWNMULTIPARS": {
                return;
            }
            case "RESET": {
                return;
            }
            case "DOSCALL": {
                return;
            }
            case "GEOS": {
                return;
            }
            case "SCREEN": {
                return;
            }
            case "MOUSE": {
                return;
            }
            case "PSET": {
                return;
            }
            case "LINE": {
                return;
            }
            case "FRAME": {
                return;
            }
            case "RECT": {
                return;
            }
            case "DOSSTAT": {
                return;
            }
            case "FINX": {
                this.finx(parts);
                return;
            }
            case "FDEX": {
                this.fdex(parts);
                return;
            }
            case "CLOSE": {
                this.close(parts);
                return;
            }
            case "INPUTSTR": {
                this.inputString(parts);
                return;
            }
            case "INPUTNUMBER": {
                this.inputNumber(parts);
                return;
            }
            case "INPUTSTRCHANNEL": {
                this.inputStringChannel(parts);
                return;
            }
            case "INPUTNUMBERCHANNEL": {
                this.inputNumberChannel(parts);
                return;
            }
            case "QUEUESIZE": {
                this.queueSize(parts);
                return;
            }
            case "CLEARQUEUE": {
                this.clearQueue(parts);
                return;
            }
            case "CLR": {
                this.clearVars(parts);
                return;
            }
            case "RUN": {
                this.run(parts);
                return;
            }
            case "END": {
                this.end(parts);
                return;
            }
            case "START": {
                this.start(parts);
                return;
            }
        }
        this.jumpStack.push(this.addr);
        this.jmp(parts);
    }

    private void restart(String[] parts) {
        this.forStackPos = 0;
        this.addr = 0;
    }

    private void fdex(String[] parts) {
        this.regs[0] = this.regs[0].intValue() - 1;
    }

    private void finx(String[] parts) {
        this.regs[0] = this.regs[0].intValue() + 1;
    }

    private void crsrright(String[] parts, int channel) {
        if (channel == 0) {
            this.machine.getOutputChannel().print(channel, " ");
        } else {
            this.machine.getDeviceProvider().print(channel, " ");
        }
    }

    private void usr(String[] parts) {
    }

    private void returny(String[] parts) {
        int fsp = this.forStackPos;
        while (fsp >= 0) {
            ForStackEntry fse = new ForStackEntry(fsp);
            if (fse.type == 0) {
                this.forStackPos = fsp - fse.size;
                return;
            }
            fsp -= fse.size;
        }
        throw new RuntimeException("Stack underflow!");
    }

    private void gosub(String[] parts) {
        ForStackEntry fse = new ForStackEntry();
        this.forStackPos = fse.push(this.forStackPos);
    }

    private void lineBreak(String[] parts, int channel) {
        if (channel == 0) {
            this.machine.getOutputChannel().println(channel, "");
        } else {
            this.machine.getDeviceProvider().println(channel, "");
        }
    }

    private void strOut(String[] parts, int channel) {
        if (channel == 0) {
            this.machine.getOutputChannel().print(channel, this.readString(this.regs[5].intValue()));
        } else {
            this.machine.getDeviceProvider().print(channel, this.readString(this.regs[5].intValue()));
        }
    }

    private void qMarkOut(String[] parts, int channel, int cnt) {
        String qs = "?????";
        if (channel == 0) {
            this.machine.getOutputChannel().print(channel, qs.substring(0, cnt));
        } else {
            this.machine.getDeviceProvider().print(channel, qs.substring(0, cnt));
        }
    }

    private void qMarkOut1(String[] parts, int channel) {
        this.qMarkOut(parts, channel, 1);
    }

    private void qMarkOut2(String[] parts, int channel) {
        this.qMarkOut(parts, channel, 2);
    }

    private void strOutAbs(String strg, int channel) {
        if (channel == 0) {
            this.machine.getOutputChannel().print(channel, strg);
        } else {
            this.machine.getDeviceProvider().print(channel, strg);
        }
    }

    private void realOut(String[] parts, int channel) {
        Number toPrint = this.regs[0];
        String out = toPrint.toString();
        if (VarUtils.getFloat(toPrint) >= 0.0f) {
            out = " " + out;
        }
        if (out.endsWith(".0")) {
            out = out.substring(0, out.length() - 2);
        }
        if (channel == 0) {
            this.machine.getOutputChannel().print(channel, out);
        } else {
            this.machine.getDeviceProvider().print(channel, out);
        }
    }

    private void intOut(String[] parts, int channel) {
        Number toPrint = this.regs[0];
        String out = String.valueOf(toPrint.intValue());
        if (VarUtils.getInt(toPrint) >= 0) {
            out = " " + out;
        }
        if (channel == 0) {
            this.machine.getOutputChannel().print(channel, out);
        } else {
            this.machine.getDeviceProvider().print(channel, out);
        }
    }

    private void intOutChannel(String[] parts) {
        this.intOut(parts, this.regs[7].intValue());
    }

    private void lineBreakChannel(String[] parts) {
        this.lineBreak(parts, this.regs[7].intValue());
    }

    private void strOutChannel(String[] parts) {
        this.strOut(parts, this.regs[7].intValue());
    }

    private void realOutChannel(String[] parts) {
        this.realOut(parts, this.regs[7].intValue());
    }

    private void cmd(String[] parts) {
        int fn = this.regs[0].intValue();
        if (!this.machine.getDeviceProvider().isOpen(fn)) {
            throw new RuntimeException("File not open error: " + this);
        }
        this.machine.getOutputChannel().setPrintConsumer(this.machine.getDeviceProvider(), fn);
        this.outputChannel = fn;
    }

    private void open(String[] parts) {
        DeviceProvider device = this.machine.getDeviceProvider();
        int size = this.regs[1].intValue();
        try {
            switch (size) {
                case 1: {
                    device.open(VarUtils.getInt(this.regs[0]));
                    break;
                }
                case 2: {
                    device.open(VarUtils.getInt(this.regs[0]), VarUtils.getInt(this.regs[7]));
                    break;
                }
                case 3: {
                    device.open(VarUtils.getInt(this.regs[0]), VarUtils.getInt(this.regs[7]), VarUtils.getInt(this.regs[8]));
                    break;
                }
                case 4: {
                    device.open(VarUtils.getInt(this.regs[0]), VarUtils.getInt(this.regs[7]), VarUtils.getInt(this.regs[8]), this.readString(this.regs[11].intValue()));
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid parameter count: " + size);
                }
            }
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Invalid parameter type!");
        }
    }

    private void close(String[] parts) {
        int fn = this.regs[0].intValue();
        if (this.machine.getOutputChannel().getPrintConsumer() != null && this.machine.getOutputChannel().getChannel() == fn) {
            this.machine.getOutputChannel().setPrintConsumer(null, 0);
        }
        this.machine.getDeviceProvider().close(fn);
    }

    private void jumpTo(String newAddr) {
        String label = String.valueOf(newAddr) + ":";
        this.addr = this.label2line.get(label).intValue();
    }

    private void rts(String[] parts) {
        if (this.jumpStack.isEmpty()) {
            this.halt = true;
        } else {
            this.addr = this.jumpStack.pop().intValue();
        }
    }

    private void xToStack() {
        int size = this.initialJumpStackSize;
        while (this.jumpStack.size() > size) {
            this.jumpStack.pop();
        }
    }

    private void stackToX() {
        this.initialJumpStackSize = this.jumpStack.size();
    }

    private void start(String[] parts) {
        this.stackToX();
    }

    private void end(String[] parts) {
        this.xToStack();
    }

    private void adjustStack() {
        ForStackEntry fse;
        int varAddr = this.regs[5].intValue();
        for (int fsp = this.forStackPos; fsp > 0; fsp -= fse.size) {
            fse = new ForStackEntry(fsp);
            if (fse.type != 0) continue;
            return;
        }
    }

    private void initFor(String[] parts) {
        this.adjustStack();
        Number stepVal = this.getStack().pop();
        Number endVal = this.getStack().pop();
        ForStackEntry fse = new ForStackEntry(this.regs[5].intValue(), this.addr, endVal, stepVal);
        this.forStackPos = fse.push(this.forStackPos);
    }

    private void fastFor(String[] parts) {
        Number stepVal = this.getStack().pop();
        Number endVal = this.getStack().pop();
        int varAddr = this.regs[5].intValue();
        ForStackEntry fse = new ForStackEntry(varAddr, this.addr, endVal, stepVal);
        Variable var = this.machine.getVariableUpperCase(this.varLocations.get(fse.varPointer));
        int val = ((Number)var.eval(this.machine)).intValue();
        int to = fse.to.intValue();
        int step = fse.step.intValue();
        int pval = this.regs[0].intValue();
        int i = val;
        while (i <= to) {
            this.memory[i] = pval & 0xFF;
            i += step;
        }
        var.setValue(to + step);
    }

    private void next(String[] parts) {
        int varAddr = this.regs[5].intValue();
        int fsp = this.forStackPos;
        while (fsp > 0) {
            ForStackEntry fse = new ForStackEntry(fsp);
            if (fse.type == 0) break;
            if (fse.type == 1 && (varAddr == 0 || varAddr == fse.varPointer)) {
                Variable var = this.machine.getVariableUpperCase(this.varLocations.get(fse.varPointer));
                double val = ((Number)var.eval(this.machine)).doubleValue();
                double to = fse.to.doubleValue();
                double step = fse.step.doubleValue();
                var.setValue(val += step);
                if (step < 0.0) {
                    if (val >= to) {
                        this.regs[5] = 0;
                        this.memory[this.jumpTargetAddr] = (byte)(fse.addr & 0xFF);
                        this.memory[this.jumpTargetAddr + 1] = (byte)(fse.addr >> 8 & 0xFF);
                        this.memory[this.jumpTargetAddr + 2] = (byte)(fse.addr >> 16 & 0xFF);
                        this.memory[this.jumpTargetAddr + 3] = (byte)(fse.addr >> 24);
                    } else {
                        this.regs[5] = 1;
                        this.forStackPos = fsp - fse.size;
                    }
                } else if (val <= to) {
                    this.regs[5] = 0;
                    this.memory[this.jumpTargetAddr] = (byte)(fse.addr & 0xFF);
                    this.memory[this.jumpTargetAddr + 1] = (byte)(fse.addr >> 8 & 0xFF);
                    this.memory[this.jumpTargetAddr + 2] = (byte)(fse.addr >> 16 & 0xFF);
                    this.memory[this.jumpTargetAddr + 3] = (byte)(fse.addr >> 24);
                    this.forStackPos = fsp;
                } else {
                    this.regs[5] = 1;
                    this.forStackPos = fsp - fse.size;
                }
                return;
            }
            fsp -= fse.size;
        }
        throw new RuntimeException("Next without for!");
    }

    private void concat(String[] parts) {
        int sp = this.regs[5].intValue();
        String s1 = this.readString(sp);
        String s2 = this.readString(this.regs[6].intValue());
        if (sp != this.bufferStart) {
            this.bufferStart = this.bufferPos;
            this.checkBufferSpace(s1);
            System.arraycopy(this.toIntArray(s1), 0, this.memory, this.bufferStart + 1, s1.length());
            this.bufferPos += s1.length() + 1;
            this.memory[this.bufferStart] = s1.length();
        }
        this.checkBufferSpace(s2);
        this.regs[5] = this.bufferStart;
        System.arraycopy(this.toIntArray(s2), 0, this.memory, this.bufferStart + 1 + this.memory[this.bufferStart], s2.length());
        this.memory[this.bufferStart] = this.memory[this.bufferStart] + s2.length();
        this.bufferPos += s2.length() + 1;
    }

    private void mid(String[] parts) {
        String ch = this.readString(this.regs[6].intValue());
        int end = this.regs[8].intValue();
        int start = this.regs[7].intValue();
        if (end != -1) {
            this.mid.setTerm(Parser.getTerm(this.config, "\"" + ch + "\"," + start + "," + end, this.machine, false, false));
        } else {
            this.mid.setTerm(Parser.getTerm(this.config, "\"" + ch + "\"," + start, this.machine, false, false));
        }
        String snum = this.mid.eval(this.machine).toString();
        this.copyStringResult(snum);
    }

    private void vpeek(String[] parts) {
        int bank = this.regs[1].intValue();
        int addr = this.regs[7].intValue();
        int ti = this.getIndex("X");
        this.regs[ti] = this.memory[addr];
    }

    private void left(String[] parts) {
        String ch = this.readString(this.regs[6].intValue());
        int end = this.regs[7].intValue();
        this.left.setTerm(Parser.getTerm(this.config, "\"" + ch + "\"," + end, this.machine, false, false));
        String snum = this.left.eval(this.machine).toString();
        this.copyStringResult(snum);
    }

    private void right(String[] parts) {
        String ch = this.readString(this.regs[6].intValue());
        int end = this.regs[7].intValue();
        this.right.setTerm(Parser.getTerm(this.config, "\"" + ch + "\"," + end, this.machine, false, false));
        String snum = this.right.eval(this.machine).toString();
        this.copyStringResult(snum);
    }

    private void tab(String[] parts) {
        this.runIntStringFunction(parts, this.tab, true);
    }

    private void spc(String[] parts) {
        this.runIntStringFunction(parts, this.spc, true);
    }

    private void pos(String[] parts) {
        Number num;
        this.pos.setTerm(Parser.getTerm(this.config, "0", this.machine, false, false));
        this.regs[0] = num = (Number)this.pos.eval(this.machine);
    }

    private void copyString(String[] parts) {
        int fromAddr = this.regs[5].intValue();
        if (fromAddr >= 32768) {
            String toCopy = this.readString(fromAddr);
            this.copyStringResult(toCopy);
        }
        this.bufferPos = 32768;
        this.bufferStart = 32768;
    }

    private void run(String[] parts) {
        this.clearVars(parts);
        this.forStackPos = 0;
        this.addr = 0;
    }

    private void clearVars(String[] parts) {
        for (Variable var : this.machine.getVariables().values()) {
            if (var.isArray()) {
                int addr = this.memLocations.get(var.getName());
                int type = this.memory[addr++];
                int size = this.memory[addr++];
                int i = 0;
                while (i < size) {
                    if (type == 0) {
                        this.memory[addr + i] = 0;
                    } else if (type == 1) {
                        this.memory[addr + i] = Float.floatToIntBits(0.0f);
                    } else if (type == 2) {
                        this.memory[addr + i] = this.emptyString;
                    } else {
                        throw new RuntimeException("Unknown type: " + type);
                    }
                    ++i;
                }
                continue;
            }
            if (var.getType() == Type.INTEGER) {
                var.setValue(0);
                continue;
            }
            if (var.getType() == Type.REAL) {
                var.setValue(Float.valueOf(0.0f));
                continue;
            }
            if (!this.memLocations.containsKey(var.getName())) continue;
            this.memLocations.put(var.getName(), this.emptyString);
        }
        this.restore(parts);
        this.memPointer = this.dynamicStart;
        this.bufferPos = 32768;
        this.bufferStart = 32768;
    }

    private void restore(String[] parts) {
        this.datasPointer = this.datasAddr;
        this.datasSize = this.memory[this.datasPointer++];
    }

    private void getString(String[] parts) {
        Character c = this.machine.getInputProvider().readKey();
        if (c == null) {
            this.regs[5] = this.emptyString;
        } else {
            this.copyStringResult(c.toString());
        }
        this.machine.getOutputChannel().setPrintConsumer(null, 0);
    }

    private void getNumber(String[] parts) {
        Character c = this.machine.getInputProvider().readKey();
        if (c == null) {
            this.regs[1] = this.emptyReal;
        } else {
            c = this.ensureNumberKey(this.machine, c, true);
            this.regs[1] = Integer.valueOf(c.toString());
        }
        this.machine.getOutputChannel().setPrintConsumer(null, 0);
    }

    private void clearQueue(String[] parts) {
        this.inputQueue.clear();
    }

    private void queueSize(String[] parts) {
        this.regs[0] = this.inputQueue.size();
    }

    private void inputNumber(String[] parts) {
        String inp = this.inputNext();
        this.regs[0] = 0;
        try {
            Float num = Float.valueOf(inp);
            this.regs[1] = num;
        }
        catch (NumberFormatException nfe) {
            this.regs[0] = 1;
            this.inputQueue.clear();
        }
    }

    private void inputString(String[] parts) {
        String inp = this.inputNext();
        this.copyStringResult(inp);
        this.regs[0] = 0;
    }

    private String inputNext() {
        String input = null;
        if (this.inputQueue.isEmpty()) {
            String[] parts;
            input = this.machine.getInputProvider().readString();
            this.machine.getOutputChannel().println(0, "");
            if (input == null) {
                input = "";
            }
            if ((parts = input.split(",")).length > 1) {
                int p = 1;
                while (p < parts.length) {
                    this.inputQueue.add(parts[p]);
                    ++p;
                }
            }
            input = parts[0];
        } else {
            input = this.inputQueue.remove(0);
        }
        return input;
    }

    private void getStringChannel(String[] parts) {
        int fn = this.regs[7].intValue();
        DeviceProvider device = this.machine.getDeviceProvider();
        Character c = Character.valueOf(device.getChar(fn));
        this.copyStringResult(c.toString());
    }

    private void getNumberChannel(String[] parts) {
        int fn = this.regs[7].intValue();
        DeviceProvider device = this.machine.getDeviceProvider();
        Character c = Character.valueOf(device.getChar(fn));
        c = this.ensureNumberKey(this.machine, c, true);
        this.regs[1] = Integer.valueOf(c.toString());
    }

    private void inputNumberChannel(String[] parts) {
        int fn = this.regs[7].intValue();
        DeviceProvider device = this.machine.getDeviceProvider();
        float num = device.inputNumber(fn).floatValue();
        this.regs[1] = Float.valueOf(num);
    }

    private void inputStringChannel(String[] parts) {
        int fn = this.regs[7].intValue();
        DeviceProvider device = this.machine.getDeviceProvider();
        String str = device.inputString(fn);
        this.copyStringResult(str);
    }

    private void readString(String[] parts) {
        this.checkDataPointer();
        int type = this.memory[this.datasPointer++];
        if (type != 2) {
            Number n = null;
            n = type == 0 ? (Number)this.memory[this.datasPointer++] : (Number)Float.valueOf(Float.intBitsToFloat(this.memory[this.datasPointer++]));
            this.copyStringResult(n.toString());
        } else {
            this.regs[5] = this.datasPointer;
            this.datasPointer += this.memory[this.datasPointer++] + 1;
        }
    }

    private Character ensureNumberKey(Machine machine, Character input, boolean checkColon) {
        if (input.charValue() == '+' || input.charValue() == '-' || input.charValue() == '.' || input.charValue() == ',' || input.charValue() == 'e') {
            input = Character.valueOf('0');
        }
        if (checkColon && input.charValue() == ':') {
            machine.getOutputChannel().systemPrintln(0, "?Extra ignored:" + this);
            input = Character.valueOf('0');
        }
        if (input.charValue() < '0' || input.charValue() > '9') {
            throw new RuntimeException("Invalid key!");
        }
        return input;
    }

    private void readNumber(String[] parts) {
        this.checkDataPointer();
        int type = this.memory[this.datasPointer++];
        int obj = this.memory[this.datasPointer++];
        if (type == 2) {
            if (obj == 0 || obj == 1 && (char)this.memory[this.datasPointer++] == '.') {
                obj = 0;
            } else {
                throw new RuntimeException("Type mismatch: " + type);
            }
        }
        this.regs[1] = type == 0 ? (Number)obj : (Number)Float.valueOf(Float.intBitsToFloat(obj));
    }

    private void checkDataPointer() {
        if (this.datasPointer - this.datasAddr >= this.datasSize) {
            throw new RuntimeException("Out of data: " + this.datasPointer + "/" + this.datasAddr + "/" + this.datasSize);
        }
    }

    private void copyStringResult(String snum) {
        this.checkMemory(snum.length());
        this.regs[5] = this.memPointer;
        this.memory[this.memPointer] = snum.length();
        System.arraycopy(this.toIntArray(snum), 0, this.memory, this.memPointer + 1, snum.length());
        this.memPointer += snum.length() + 1;
        this.bufferPos = 32768;
        this.bufferStart = 32768;
    }

    private void asc(String[] parts) {
        this.runStringIntFunction(parts, this.asc, true);
    }

    private void val(String[] parts) {
        this.runStringIntFunction(parts, this.val, false);
    }

    private void len(String[] parts) {
        this.runStringIntFunction(parts, this.len, true);
    }

    private void runStringIntFunction(String[] parts, Function func, boolean inty) {
        String ch = this.readString(this.regs[6].intValue());
        func.setTerm(Parser.getTerm(this.config, "\"" + ch + "\"", this.machine, false, false));
        Number num = (Number)func.eval(this.machine);
        if (inty) {
            num = num.intValue();
        }
        this.regs[0] = num;
    }

    private void chr(String[] parts) {
        this.runIntStringFunction(parts, this.chr, true);
    }

    private void str(String[] parts) {
        this.runIntStringFunction(parts, this.str, false);
    }

    private void runIntStringFunction(String[] parts, Function func, boolean inty) {
        Number num = this.regs[1];
        func.setTerm(Parser.getTerm(this.config, String.valueOf(inty ? (float)num.intValue() : num.floatValue()), this.machine, false, false));
        String snum = func.eval(this.machine).toString();
        this.copyStringResult(snum);
    }

    private void checkBufferSpace(String ss) {
        int max = this.bufferPos + ss.length();
        if (max >= this.memory.length) {
            throw new RuntimeException("Out of memory: [" + ss + "] - " + max + "/" + this.bufferPos + "/" + this.memory.length);
        }
    }

    private void checkMemory(int addSize) {
        if (this.memPointer + addSize >= this.memoryLimit) {
            throw new RuntimeException("Out of memory: " + this.memoryLimit + "/" + addSize);
        }
    }

    private void collectGarbage() {
        int lookFor = this.stringStart;
        int closest = this.memPointer;
        int highest = this.stringStart;
        do {
            closest = this.memPointer;
            highest = 0;
            int i = 0;
            while (i < this.stringNames.size()) {
                block18: {
                    String name;
                    block16: {
                        int memAddr;
                        block17: {
                            name = this.stringNames.get(i);
                            if (name.endsWith("[]")) break block16;
                            memAddr = this.memLocations.get(name);
                            if (lookFor > highest) {
                                highest = lookFor;
                            }
                            if (lookFor != memAddr) break block17;
                            i = -1;
                            lookFor = memAddr + this.memory[memAddr] + 1;
                            closest = this.memPointer;
                            break block18;
                        }
                        if (memAddr <= lookFor || memAddr >= closest) break block18;
                        closest = memAddr;
                        break block18;
                    }
                    int addr = this.memLocations.get(name);
                    int type = this.memory[addr++];
                    int size = this.memory[addr++];
                    if (type != 2) {
                        throw new RuntimeException("Unknown array type: " + type);
                    }
                    int p = 0;
                    while (p < size) {
                        int memAddr = this.memory[addr + p];
                        if (lookFor > highest) {
                            highest = lookFor;
                        }
                        if (lookFor == memAddr) {
                            i = -1;
                            lookFor = memAddr + this.memory[memAddr] + 1;
                            closest = this.memPointer;
                        } else if (memAddr > lookFor && memAddr < closest) {
                            closest = memAddr;
                        }
                        ++p;
                    }
                }
                ++i;
            }
            if (closest >= this.memPointer) continue;
            int size = this.memPointer - closest;
            if (lookFor > closest) {
                throw new RuntimeException("Invalid memory locations: " + closest + "/" + lookFor + "/" + this.memPointer);
            }
            System.arraycopy(this.memory, closest, this.memory, lookFor, size);
            int oldLookFor = lookFor;
            lookFor = lookFor + this.memory[lookFor] + 1;
            int dif = closest - oldLookFor;
            for (String strName : this.stringNames) {
                if (!strName.endsWith("[]")) {
                    int memAddr = this.memLocations.get(strName);
                    if (memAddr < oldLookFor) continue;
                    this.memLocations.put(strName, memAddr - dif);
                    continue;
                }
                int addr = this.memLocations.get(strName);
                int type = this.memory[addr++];
                int sz = this.memory[addr++];
                if (type != 2) {
                    throw new RuntimeException("Unknown array type: " + type);
                }
                int p = 0;
                while (p < sz) {
                    int memAddr = this.memory[addr + p];
                    if (memAddr >= oldLookFor) {
                        this.memory[addr + p] = memAddr - dif;
                    }
                    ++p;
                }
            }
        } while (closest < this.memPointer);
        if (highest != this.memPointer) {
            this.memPointer = highest;
        }
    }

    private void sin(String[] parts) {
        this.calc(parts, new Calc(){

            @Override
            public Number calc(Number n1, Number n2) {
                return Math.sin(n2.doubleValue());
            }

            @Override
            public String op() {
                return "SIN(_)";
            }
        });
    }

    private void arrayStore(String[] parts) {
        int addr = this.regs[11].intValue();
        int offset = this.regs[0].intValue();
        float val = this.regs[1].floatValue();
        int valStr = this.regs[5].intValue();
        int type = this.memory[addr];
        int size = this.memory[addr + 1];
        if (offset >= size) {
            throw new RuntimeException("Array index out of bounds: " + offset + "/" + (size - 1) + " in " + (this.addr - 1));
        }
        int pos = addr + offset + 2;
        this.memory[pos] = type == 1 ? Float.floatToIntBits(val) : (type == 0 ? (int)val : valStr);
    }

    private void arrayAccess(String[] parts) {
        int addr = this.regs[11].intValue();
        int offset = this.regs[0].intValue();
        int type = this.memory[addr];
        int size = this.memory[addr + 1];
        if (offset >= size) {
            throw new RuntimeException("Array index out of bounds: " + offset + "/" + (size - 1));
        }
        int pos = addr + offset + 2;
        int val = this.memory[pos];
        if (type == 1) {
            this.regs[0] = Float.valueOf(Float.intBitsToFloat(val));
        } else if (type == 0) {
            this.regs[0] = val;
        } else {
            this.regs[5] = val;
        }
    }

    private void rnd(String[] parts) {
        this.calc(parts, new Calc(){

            @Override
            public Number calc(Number n1, Number n2) {
                return Math.random();
            }

            @Override
            public String op() {
                return "RND(_)";
            }
        });
    }

    private void cos(String[] parts) {
        this.calc(parts, new Calc(){

            @Override
            public Number calc(Number n1, Number n2) {
                return Math.cos(n2.doubleValue());
            }

            @Override
            public String op() {
                return "COS(_)";
            }
        });
    }

    private void tan(String[] parts) {
        this.calc(parts, new Calc(){

            @Override
            public Number calc(Number n1, Number n2) {
                return Math.tan(n2.doubleValue());
            }

            @Override
            public String op() {
                return "TAN(_)";
            }
        });
    }

    private void atn(String[] parts) {
        this.calc(parts, new Calc(){

            @Override
            public Number calc(Number n1, Number n2) {
                return Math.atan(n2.doubleValue());
            }

            @Override
            public String op() {
                return "ATN(_)";
            }
        });
    }

    private void exp(String[] parts) {
        this.calc(parts, new Calc(){

            @Override
            public Number calc(Number n1, Number n2) {
                return Math.exp(n2.doubleValue());
            }

            @Override
            public String op() {
                return "EXP(_)";
            }
        });
    }

    private void log(String[] parts) {
        this.calc(parts, new Calc(){

            @Override
            public Number calc(Number n1, Number n2) {
                return Math.log(n2.doubleValue());
            }

            @Override
            public String op() {
                return "LOG(_)";
            }
        });
    }

    private void sqr(String[] parts) {
        this.calc(parts, new Calc(){

            @Override
            public Number calc(Number n1, Number n2) {
                return Math.sqrt(n2.doubleValue());
            }

            @Override
            public String op() {
                return "SQR(_)";
            }
        });
    }

    private void sgn(String[] parts) {
        this.calc(parts, new Calc(){

            @Override
            public Number calc(Number n1, Number n2) {
                return Math.signum(n2.doubleValue());
            }

            @Override
            public String op() {
                return "SGN(_)";
            }
        });
    }

    private void inty(String[] parts) {
        this.calc(parts, new Calc(){

            @Override
            public Number calc(Number n1, Number n2) {
                return n2.intValue();
            }

            @Override
            public String op() {
                return "INT(_)";
            }
        });
    }

    private void abs(String[] parts) {
        this.calc(parts, new Calc(){

            @Override
            public Number calc(Number n1, Number n2) {
                return Math.abs(n2.doubleValue());
            }

            @Override
            public String op() {
                return "ABS(_)";
            }
        });
    }

    private void not(String[] parts) {
        this.calc(parts, new Calc(){

            @Override
            public Number calc(Number n1, Number n2) {
                return ~n2.intValue();
            }

            @Override
            public String op() {
                return "!_";
            }
        });
    }

    private void lowerThanOrEqual(String[] parts) {
        this.calc(parts, new Calc(){

            @Override
            public Number calc(Number n1, Number n2) {
                return n1.doubleValue() <= n2.doubleValue() ? -1 : 0;
            }

            @Override
            public String op() {
                return "LTEQ_";
            }
        });
    }

    private void greaterThanOrEqual(String[] parts) {
        this.calc(parts, new Calc(){

            @Override
            public Number calc(Number n1, Number n2) {
                return n1.doubleValue() >= n2.doubleValue() ? -1 : 0;
            }

            @Override
            public String op() {
                return "GTEQ_";
            }
        });
    }

    private void lowerThan(String[] parts) {
        this.calc(parts, new Calc(){

            @Override
            public Number calc(Number n1, Number n2) {
                return n1.doubleValue() < n2.doubleValue() ? -1 : 0;
            }

            @Override
            public String op() {
                return "LT_";
            }
        });
    }

    private void greaterThan(String[] parts) {
        this.calc(parts, new Calc(){

            @Override
            public Number calc(Number n1, Number n2) {
                return n1.doubleValue() > n2.doubleValue() ? -1 : 0;
            }

            @Override
            public String op() {
                return "GT_";
            }
        });
    }

    private void notEqual(String[] parts) {
        this.calc(parts, new Calc(){

            @Override
            public Number calc(Number n1, Number n2) {
                return n1.doubleValue() == n2.doubleValue() ? 0 : -1;
            }

            @Override
            public String op() {
                return "NEQ_";
            }
        });
    }

    private void equal(String[] parts) {
        this.calc(parts, new Calc(){

            @Override
            public Number calc(Number n1, Number n2) {
                return n1.doubleValue() == n2.doubleValue() ? -1 : 0;
            }

            @Override
            public String op() {
                return "EQ_";
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void compare(String[] parts) {
        int pos;
        String[] ops = this.split(parts[1], ",");
        String target = ops[0];
        String source = ops[1];
        int ti = 0;
        int si = 0;
        ti = this.getIndex(target);
        si = this.getIndex(source);
        Type type = Type.INTEGER;
        Object v0 = null;
        Number v1 = null;
        if (ti == -1 && si != -1) {
            pos = target.lastIndexOf("{");
            if (pos == -1) throw new RuntimeException("Unknown opcode: " + Arrays.toString(parts));
            String ts = target.substring(pos + 1, target.lastIndexOf("}"));
            String val = target.substring(0, pos);
            type = Type.valueOf(ts);
            if (type == Type.STRING) {
                throw new RuntimeException("Comparing a string isn't supported!");
            }
            v0 = this.machine.getVariableUpperCase(val).getValue();
            v1 = this.regs[si];
        } else {
            pos = source.lastIndexOf("{");
            if (pos == -1) {
                v0 = this.regs[ti];
                v1 = this.regs[si];
            } else {
                String ts = source.substring(pos + 1, source.lastIndexOf("}"));
                String val = source.substring(0, pos);
                type = Type.valueOf(ts);
                if (type == Type.STRING) {
                    throw new RuntimeException("Comparing a string isn't supported!");
                }
                if (val.startsWith("#")) {
                    void var13_18;
                    Float f = Float.valueOf(val.replace("#", ""));
                    if (type == Type.INTEGER) {
                        Integer n = ((Number)f).intValue();
                    }
                    v0 = this.regs[ti];
                    v1 = var13_18;
                } else {
                    Number number = (Number)this.machine.getVariableUpperCase(val).eval(this.machine);
                    v0 = this.regs[ti];
                    v1 = number;
                }
            }
        }
        double cmp = 1.0;
        if (!(v0 instanceof Number) || !(v1 instanceof Number)) {
            throw new RuntimeException("Can't compare " + v0.getClass() + " with " + v1.getClass());
        }
        cmp = ((Number)v0).doubleValue() - v1.doubleValue();
        this.updateZeroFlag(cmp);
    }

    private void strLowerThanOrEqual(String[] parts) {
        String n2;
        String n1 = this.readString(this.regs[6].intValue());
        this.regs[0] = n1.compareTo(n2 = this.readString(this.regs[5].intValue())) >= 0 ? -1 : 0;
    }

    private void strGreaterThanOrEqual(String[] parts) {
        String n2;
        String n1 = this.readString(this.regs[6].intValue());
        this.regs[0] = n1.compareTo(n2 = this.readString(this.regs[5].intValue())) <= 0 ? -1 : 0;
    }

    private void strLowerThan(String[] parts) {
        String n2;
        String n1 = this.readString(this.regs[6].intValue());
        this.regs[0] = n1.compareTo(n2 = this.readString(this.regs[5].intValue())) > 0 ? -1 : 0;
    }

    private void strGreaterThan(String[] parts) {
        String n2;
        String n1 = this.readString(this.regs[6].intValue());
        this.regs[0] = n1.compareTo(n2 = this.readString(this.regs[5].intValue())) < 0 ? -1 : 0;
    }

    private void strNotEqual(String[] parts) {
        String n2;
        String n1 = this.readString(this.regs[6].intValue());
        this.regs[0] = n1.compareTo(n2 = this.readString(this.regs[5].intValue())) != 0 ? -1 : 0;
    }

    private void strEqual(String[] parts) {
        String n2;
        String n1 = this.readString(this.regs[6].intValue());
        this.regs[0] = n1.compareTo(n2 = this.readString(this.regs[5].intValue())) == 0 ? -1 : 0;
    }

    private void or(String[] parts) {
        this.calc(parts, new Calc(){

            @Override
            public Number calc(Number n1, Number n2) {
                return n1.intValue() | n2.intValue();
            }

            @Override
            public String op() {
                return "|_";
            }
        });
    }

    private void xor(String[] parts) {
        this.calc(parts, new Calc(){

            @Override
            public Number calc(Number n1, Number n2) {
                return n1.intValue() ^ n2.intValue();
            }

            @Override
            public String op() {
                return "~_";
            }
        });
    }

    private void and(String[] parts) {
        this.calc(parts, new Calc(){

            @Override
            public Number calc(Number n1, Number n2) {
                return n1.intValue() & n2.intValue();
            }

            @Override
            public String op() {
                return "&_";
            }
        });
    }

    private void add(String[] parts) {
        this.calc(parts, new Calc(){

            @Override
            public Number calc(Number n1, Number n2) {
                return Float.valueOf(n1.floatValue() + n2.floatValue());
            }

            @Override
            public String op() {
                return "+_";
            }
        });
    }

    private void pow(String[] parts) {
        this.calc(parts, new Calc(){

            @Override
            public Number calc(Number n1, Number n2) {
                return Math.pow(n1.floatValue(), n2.floatValue());
            }

            @Override
            public String op() {
                return "^_";
            }
        });
    }

    private void sub(String[] parts) {
        this.calc(parts, new Calc(){

            @Override
            public Number calc(Number n1, Number n2) {
                return Float.valueOf(n1.floatValue() - n2.floatValue());
            }

            @Override
            public String op() {
                return "-_";
            }
        });
    }

    private void div(String[] parts) {
        this.calc(parts, new Calc(){

            @Override
            public Number calc(Number n1, Number n2) {
                return Float.valueOf(n1.floatValue() / n2.floatValue());
            }

            @Override
            public String op() {
                return "/_";
            }
        });
    }

    private void shr(String[] parts) {
        this.calc(parts, new Calc(){

            @Override
            public Number calc(Number n1, Number n2) {
                return (double)n1.floatValue() / Math.pow(2.0, n2.floatValue());
            }

            @Override
            public String op() {
                return ">_";
            }
        });
    }

    private void shl(String[] parts) {
        this.calc(parts, new Calc(){

            @Override
            public Number calc(Number n1, Number n2) {
                return (double)n1.floatValue() * Math.pow(2.0, n2.floatValue());
            }

            @Override
            public String op() {
                return "<_";
            }
        });
    }

    private void mul(String[] parts) {
        this.calc(parts, new Calc(){

            @Override
            public Number calc(Number n1, Number n2) {
                return Float.valueOf(n1.floatValue() * n2.floatValue());
            }

            @Override
            public String op() {
                return "*_";
            }
        });
    }

    private void neg(String[] parts) {
        this.calc(parts, new Calc(){

            @Override
            public Number calc(Number n1, Number n2) {
                return Float.valueOf(-1.0f * n2.floatValue());
            }

            @Override
            public String op() {
                return "NEG(_)";
            }
        });
    }

    private void calc(String[] parts, Calc calc) {
        String[] ops = new String[]{"X", "Y"};
        if (parts.length > 1) {
            ops = this.split(parts[1], ",");
        }
        String target = ops[0];
        int ti = this.getIndex(target);
        Number n1 = this.regs[ti];
        String source = ops[1];
        int si = this.getIndex(source);
        Number n2 = this.regs[si];
        this.regs[ti] = calc.calc(n1, n2);
        this.updateZeroFlag(this.regs[ti]);
    }

    private void pop(String[] parts) {
        try {
            String target = parts[1];
            int ti = this.getIndex(target);
            this.regs[ti] = this.stack.pop();
        }
        catch (Throwable t) {
            Logger.log("Illegal opcode: " + Arrays.toString(parts), t);
            throw new RuntimeException(t);
        }
    }

    private void push(String[] parts) {
        String target = parts[1];
        int ti = this.getIndex(target);
        this.stack.push(this.regs[ti]);
    }

    private void swap(String[] parts) {
        String[] ops = this.split(parts[1], ",");
        String target = ops[0];
        String source = ops[1];
        int ti = 0;
        int si = 0;
        ti = this.getIndex(target);
        si = this.getIndex(source);
        Number rti = this.regs[ti];
        this.regs[ti] = this.regs[si];
        this.regs[si] = rti;
    }

    private int parseInt(String txt) {
        if (txt.equals("0.0")) {
            txt = "0";
        }
        if (txt.endsWith(".0")) {
            txt = txt.replace(".0", "");
        }
        try {
            return Integer.parseInt(txt);
        }
        catch (NumberFormatException e) {
            if (this.constMap.containsKey(txt)) {
                return this.constMap.get(txt);
            }
            throw e;
        }
    }

    private void mov(String[] parts) {
        String[] ops = this.split(parts[1], ",");
        String target = ops[0];
        String source = ops[1];
        int ti = 0;
        int si = 0;
        ti = this.getIndex(target);
        si = this.getIndex(source);
        Type type = Type.INTEGER;
        if (ti == -1 && si == -1) {
            int val;
            int addr = this.parseInt(target);
            this.memory[addr] = val = this.parseInt(source.substring(0, source.indexOf("{")).replace("#", "").trim()) & 0xFF;
            return;
        }
        if (ti == -1 && si != -1) {
            int pos = target.lastIndexOf("{");
            if (pos != -1) {
                String ts = target.substring(pos + 1, target.lastIndexOf("}"));
                String val = target.substring(0, pos);
                type = Type.valueOf(ts);
                if (type == Type.STRING) {
                    Integer addr = this.regs[si].intValue();
                    this.memLocations.put(val, addr);
                } else {
                    if (val.contains("[]")) {
                        throw new RuntimeException("Writing into '" + val + "' isn't supported!");
                    }
                    this.machine.getVariableUpperCase(val).setValue(this.regs[si]);
                }
            } else if (!target.contains(":")) {
                int val;
                int addr = this.parseInt(target);
                this.memory[addr] = val = this.regs[si].intValue() & 0xFF;
                if (this.sharedRam) {
                    this.machine.getMemoryListener().poke(addr, val);
                }
            } else {
                String[] trs = target.split(":");
                int val = this.regs[si].intValue() & 0xFF;
                int lo = val & 0xFF;
                int hi = val >> 8;
                int addr = this.parseInt(trs[0].trim());
                this.memory[addr] = lo;
                if (this.sharedRam) {
                    this.machine.getMemoryListener().poke(addr, lo);
                }
                addr = this.parseInt(trs[1].trim());
                this.memory[addr] = hi;
                if (this.sharedRam) {
                    this.machine.getMemoryListener().poke(addr, hi);
                }
            }
        } else {
            int pos = source.lastIndexOf("{");
            if (pos == -1) {
                if (source.startsWith("(") && source.endsWith(")")) {
                    this.regs[ti] = this.memory[this.regs[si].intValue()] & 0xFF;
                } else if (target.startsWith("(") && target.endsWith(")")) {
                    int val;
                    int addr = this.regs[ti].intValue();
                    this.memory[addr] = val = this.regs[si].intValue() & 0xFF;
                    if (this.sharedRam) {
                        this.machine.getMemoryListener().poke(addr, val);
                    }
                } else {
                    String val = source;
                    if (this.isNumber(val)) {
                        int vally = Integer.parseInt(val);
                        this.regs[ti] = this.memory[vally];
                    } else {
                        this.regs[ti] = this.regs[si];
                    }
                }
            } else {
                String ts = source.substring(pos + 1, source.lastIndexOf("}"));
                String val = source.substring(0, pos);
                if (source.startsWith("(") && source.endsWith(")")) {
                    val = val.substring(1);
                    this.regs[ti] = System.identityHashCode(this.machine.getVariableUpperCase(val));
                } else {
                    type = Type.valueOf(ts);
                    if (type == Type.STRING) {
                        Integer addr = this.memLocations.get(val);
                        if (addr == null) {
                            throw new RuntimeException("Unknown string: " + val);
                        }
                        this.regs[ti] = addr;
                    } else if (val.startsWith("#")) {
                        Number n = Float.valueOf(val.replace("#", ""));
                        if (type == Type.INTEGER) {
                            n = ((Number)n).intValue();
                        }
                        this.regs[ti] = n;
                    } else if (val.contains("[]")) {
                        Integer addr = this.memLocations.get(val);
                        if (addr == null) {
                            throw new RuntimeException("Unknown pointer to: " + val);
                        }
                        this.regs[ti] = addr;
                    } else {
                        Number n;
                        this.regs[ti] = n = (Number)this.machine.getVariableUpperCase(val).eval(this.machine);
                    }
                }
            }
        }
        if (ti > -1) {
            this.updateZeroFlag(this.regs[ti]);
        }
    }

    private boolean isNumber(String val) {
        int i = 0;
        while (i < val.length()) {
            if (!Character.isDigit(val.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void updateZeroFlag(Number value) {
        this.zeroFlag = value.doubleValue() == 0.0;
    }

    private int getIndex(String target) {
        int ti = -1;
        if (target.length() > 3) {
            return ti;
        }
        if (target.equals("X") || target.equals("(X)")) {
            ti = 0;
        } else if (target.equals("Y") || target.equals("(Y)")) {
            ti = 1;
        } else if (target.equals("A") || target.equals("(A)")) {
            ti = 5;
        } else if (target.equals("B") || target.equals("(B)")) {
            ti = 6;
        } else if (target.equals("C") || target.equals("(C)")) {
            ti = 7;
        } else if (target.equals("D") || target.equals("(D)")) {
            ti = 8;
        } else if (target.equals("E") || target.equals("(E)")) {
            ti = 9;
        } else if (target.equals("F") || target.equals("(F)")) {
            ti = 10;
        } else if (target.equals("G") || target.equals("(G)")) {
            ti = 11;
        }
        return ti;
    }

    private static interface Calc {
        public Number calc(Number var1, Number var2);

        public String op();
    }

    private class ForStackEntry {
        byte size;
        byte type;
        int varPointer;
        int addr;
        Number to;
        Number step;

        public ForStackEntry() {
            this.type = 0;
        }

        public ForStackEntry(int varPointer, int addr, Number to, Number step) {
            this.varPointer = varPointer;
            this.addr = addr;
            this.to = to;
            this.step = step;
            this.type = 1;
        }

        public ForStackEntry(int stackPos) {
            this.size = PseudoCpu.this.forStack[stackPos - 1];
            this.type = PseudoCpu.this.forStack[stackPos - 2];
            if (this.type == 0) {
                return;
            }
            int sp = stackPos - this.size;
            this.varPointer = this.getInt(sp);
            this.addr = this.getInt(sp + 4);
            Number[] sc = this.getNumbers(sp + 8);
            this.to = sc[0];
            this.step = sc[1];
        }

        public int push(int stackPos) {
            int s = 0;
            if (this.type != 0) {
                this.store(this.varPointer, stackPos);
                this.store(this.addr, stackPos + (s += 4));
                s += 4;
                int h = 0;
                if (VarUtils.isInteger(this.to)) {
                    h = this.to.intValue();
                    ((PseudoCpu)PseudoCpu.this).forStack[stackPos + s++] = 0;
                } else {
                    h = Float.floatToIntBits(this.to.floatValue());
                    ((PseudoCpu)PseudoCpu.this).forStack[stackPos + s++] = 1;
                }
                this.store(h, stackPos + s);
                s += 4;
                if (VarUtils.isInteger(this.step)) {
                    h = this.step.intValue();
                    ((PseudoCpu)PseudoCpu.this).forStack[stackPos + s++] = 0;
                } else {
                    h = Float.floatToIntBits(this.step.floatValue());
                    ((PseudoCpu)PseudoCpu.this).forStack[stackPos + s++] = 1;
                }
                this.store(h, stackPos + s);
                s += 4;
            }
            ((PseudoCpu)PseudoCpu.this).forStack[stackPos + s++] = this.type;
            ((PseudoCpu)PseudoCpu.this).forStack[stackPos + s] = (byte)(++s);
            return s + stackPos;
        }

        private void store(int h, int sp) {
            ((PseudoCpu)PseudoCpu.this).forStack[sp] = (byte)(h & 0xFF);
            ((PseudoCpu)PseudoCpu.this).forStack[sp + 1] = (byte)(h >> 8 & 0xFF);
            ((PseudoCpu)PseudoCpu.this).forStack[sp + 2] = (byte)(h >> 16 & 0xFF);
            ((PseudoCpu)PseudoCpu.this).forStack[sp + 3] = (byte)(h >> 24);
        }

        private Number[] getNumbers(int sp) {
            Number[] ret = new Number[2];
            int p = 0;
            do {
                byte type;
                if ((type = PseudoCpu.this.forStack[sp]) == 0) {
                    int h = this.getInt(sp + 1);
                    ret[p] = h;
                    sp += 5;
                    continue;
                }
                float h = Float.intBitsToFloat(this.getInt(sp + 1));
                ret[p] = Float.valueOf(h);
                sp += 5;
            } while (++p < 2);
            return ret;
        }

        private int getInt(int sp) {
            return (PseudoCpu.this.forStack[sp] & 0xFF) + ((PseudoCpu.this.forStack[sp + 1] & 0xFF) << 8) + ((PseudoCpu.this.forStack[sp + 2] & 0xFF) << 16) + ((PseudoCpu.this.forStack[sp + 3] & 0xFF) << 24);
        }
    }
}

