/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.cbmnative;

import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.Term;
import com.sixtyfour.parser.TermEnhancer;
import com.sixtyfour.system.Machine;

public class TermHelper {
    public static Term linearize(CompilerConfig config, Machine machine, Term term) {
        if (term == null) {
            throw new RuntimeException("Term is null!");
        }
        return Parser.getTerm(config, TermHelper.linearize(term.getInitial(), config.isNonDecimalNumbersAware()), machine, false, true);
    }

    public static String linearize(String term, boolean nonDecimals) {
        String t = term;
        boolean inString = false;
        int start = -1;
        int end = -1;
        char[] ct = term.toCharArray();
        int i = 0;
        while (i < term.length()) {
            char c = t.charAt(i);
            boolean nd = false;
            if (nonDecimals && i < term.length() - 1) {
                char cn = Character.toLowerCase(t.charAt(i + 1));
                boolean bl = nd = cn >= '0' && cn <= '9' || cn >= 'a' && cn <= 'f';
            }
            if (c == '\"') {
                if (!inString && i > 0) {
                    start = TermHelper.findStart(t, i);
                    end = TermHelper.findEnd(t, i);
                }
                inString = !inString;
            }
            boolean isLogic = false;
            if (!inString && c == '$' && !nd) {
                start = TermHelper.findStart(t, i);
                end = TermHelper.findEnd(t, i);
            }
            while (start != -1 && end != -1) {
                boolean iss = false;
                int p = start;
                while (p < end) {
                    char c2 = t.charAt(p);
                    if (c2 == '\"') {
                        boolean bl = iss = !iss;
                    }
                    if (!(iss || c2 != '=' && c2 != '<' && c2 != '>')) {
                        isLogic = true;
                        break;
                    }
                    ++p;
                }
                boolean rep = false;
                if (start >= 0 && ct[start] == '(') {
                    char cp;
                    if (start > 0 && ((cp = t.charAt(start - 1)) == '$' || cp == '%' || Character.isLetterOrDigit(cp))) {
                        start = -1;
                        end = -1;
                        break;
                    }
                    ct[start] = isLogic ? 40 : 32;
                    boolean bl = rep = !isLogic;
                }
                if (end < term.length() && ct[end] == ')') {
                    ct[end] = isLogic ? 41 : 32;
                    rep = !isLogic;
                }
                start = -1;
                end = -1;
                if (!rep) continue;
                t = new String(ct);
                start = TermHelper.findStart(t, i);
                end = TermHelper.findEnd(t, i);
            }
            ++i;
        }
        return TermEnhancer.removeWhiteSpace(new String(ct));
    }

    private static int findEnd(String term, int pos) {
        int brackets = 0;
        boolean inString = false;
        int i = pos;
        while (i < term.length()) {
            char c = term.charAt(i);
            if (c == '\"') {
                boolean bl = inString = !inString;
            }
            if (!inString) {
                if (brackets == 0 && c == ')') {
                    return i;
                }
                if (c == '(') {
                    ++brackets;
                } else if (c == ')' && brackets > 0) {
                    --brackets;
                }
            }
            ++i;
        }
        return term.length();
    }

    private static int findStart(String term, int pos) {
        int brackets = 0;
        boolean inString = false;
        int i = pos - 1;
        while (i >= 0) {
            char c = term.charAt(i);
            if (c == '\"') {
                boolean bl = inString = !inString;
            }
            if (!inString) {
                if (brackets == 0 && c == '(') {
                    return i;
                }
                if (c == ')') {
                    ++brackets;
                } else if (c == '(' && brackets > 0) {
                    --brackets;
                }
            }
            --i;
        }
        return 0;
    }
}

