/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.cbmnative.crossoptimizer.common;

import com.sixtyfour.Basic;
import com.sixtyfour.cbmnative.PCode;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.parser.Line;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class OrderedPCode {
    private final List<Line> allLines = new ArrayList<Line>();
    private final SortedMap<Integer, Integer> rowMapping = new TreeMap<Integer, Integer>();

    public OrderedPCode(PCode pCode) {
        Collection<Line> lines = pCode.getLines().values();
        TreeMap<Integer, Line> orderedLines = new TreeMap<Integer, Line>();
        for (Line line : lines) {
            line.setLine(line.getLine().toUpperCase());
            orderedLines.put(line.getNumber(), line);
        }
        int pos = 0;
        for (Line orderedLine : orderedLines.values()) {
            this.allLines.add(orderedLine);
            this.rowMapping.put(orderedLine.getNumber(), pos);
            ++pos;
        }
    }

    public List<Line> getLines() {
        return this.allLines;
    }

    public Line getLine(int lineNumber) {
        int targetLine = this.getLineIndex(lineNumber);
        return this.getLineDirect(targetLine);
    }

    public int getLineIndex(int lineNumber) {
        return (Integer)this.rowMapping.get(lineNumber);
    }

    public Line getLineDirect(int targetLine) {
        return this.allLines.get(targetLine);
    }

    public void removeRow(int number) {
        int rowIndex = this.getLineIndex(number);
        this.allLines.remove(rowIndex);
        this.rebuildIndex();
    }

    private void rebuildIndex() {
        this.rowMapping.clear();
        int pos = 0;
        for (Line l : this.allLines) {
            this.rowMapping.put(l.getNumber(), pos);
            ++pos;
        }
    }

    public OrderedPCode cloneInstance() {
        Basic basic = new Basic(this.getCode());
        basic.compile(new CompilerConfig());
        return new OrderedPCode(basic.getPCode());
    }

    public OrderedPCode cloneInstanceWithLineReplaced(int line, String lineText) {
        StringBuilder sb = new StringBuilder();
        for (Line l : this.allLines) {
            sb.append(l.getNumber()).append(" ");
            if (line != l.getNumber()) {
                sb.append(l.getLine());
            } else {
                sb.append(lineText);
            }
            sb.append('\n');
        }
        Basic basic = new Basic(sb.toString());
        basic.compile(new CompilerConfig());
        return new OrderedPCode(basic.getPCode());
    }

    public void reset(OrderedPCode other) {
        this.allLines.clear();
        this.allLines.addAll(other.allLines);
        this.rowMapping.clear();
        this.rowMapping.putAll(other.rowMapping);
    }

    public String getCode() {
        String result = this.getLines().stream().map(line -> String.valueOf(line.getNumber()) + " " + line.getLine()).collect(Collectors.joining("\n"));
        return result;
    }
}

