/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.cbmnative.crossoptimizer.common;

import com.sixtyfour.cbmnative.crossoptimizer.common.OrderedPCode;
import com.sixtyfour.elements.commands.Command;
import com.sixtyfour.parser.Line;
import java.util.List;

public class PCodeVisitor {
    private final OrderedPCode pCode;

    public PCodeVisitor(OrderedPCode orderedPCode) {
        this.pCode = orderedPCode;
    }

    public void accept(String commandPrefix, IVisitor onHit) {
        String prefixSearch = commandPrefix.toLowerCase();
        this.accept((line, command, index) -> {
            String commandName = command.getName().toLowerCase();
            if (commandName.equals(prefixSearch)) {
                onHit.consume(line, command, index);
            }
        });
    }

    public void accept(IVisitor onHit) {
        List<Line> lines = this.pCode.getLines();
        for (Line line : lines) {
            int pos = 0;
            for (Command command : line.getCommands()) {
                onHit.consume(line, command, pos);
                ++pos;
            }
        }
    }

    public static interface IVisitor {
        public void consume(Line var1, Command var2, int var3);
    }
}

