/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.cbmnative.crossoptimizer.passes;

import com.sixtyfour.Logger;
import com.sixtyfour.cbmnative.crossoptimizer.common.OrderedPCode;
import com.sixtyfour.cbmnative.crossoptimizer.common.PCodeVisitor;
import com.sixtyfour.cbmnative.crossoptimizer.passes.HighLevelOptimizer;
import com.sixtyfour.elements.commands.Command;
import com.sixtyfour.elements.commands.End;
import com.sixtyfour.elements.commands.Gosub;
import com.sixtyfour.elements.commands.Goto;
import com.sixtyfour.elements.commands.If;
import com.sixtyfour.elements.commands.On;
import com.sixtyfour.elements.commands.Return;
import com.sixtyfour.elements.commands.Run;
import com.sixtyfour.parser.Line;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class GenerateBasicBlocks
implements HighLevelOptimizer {
    private Analysis analysis = new Analysis();

    @Override
    public boolean optimize(OrderedPCode orderedPCode) {
        this.analyze(orderedPCode);
        return this.applyOptimization(orderedPCode);
    }

    private boolean applyOptimization(OrderedPCode orderedPCode) {
        boolean result = false;
        List<Line> allLines = orderedPCode.getLines();
        ArrayList<Integer> rowsMerged = new ArrayList<Integer>();
        int rowIndex = 0;
        while (rowIndex < allLines.size() - 1) {
            Line currentRow = orderedPCode.getLineDirect(rowIndex);
            if (!this.analysis.isLineWithJumps(currentRow)) {
                rowsMerged.clear();
                rowsMerged.add(currentRow.getNumber());
                while (rowIndex + 1 < allLines.size()) {
                    Line nextRow = orderedPCode.getLineDirect(rowIndex + 1);
                    if (this.analysis.isLineTargetedByJump(nextRow)) break;
                    result = true;
                    this.joinTwoLines(orderedPCode, rowIndex, rowsMerged);
                    if (Analysis.isLineContainingJumps(currentRow)) break;
                }
                if (rowsMerged.size() > 1) {
                    String joinedRowsStr = rowsMerged.stream().map(Object::toString).collect(Collectors.joining(", "));
                    String logMessage = "Rows: " + joinedRowsStr + " were merged as: '" + currentRow.getLine() + "'";
                    Logger.log(logMessage);
                }
            }
            ++rowIndex;
        }
        return result;
    }

    private void joinTwoLines(OrderedPCode orderedPCode, int rowIndex, List<Integer> rowsMerged) {
        assert (orderedPCode.getLines().size() > rowIndex + 1);
        Line currentRow = orderedPCode.getLineDirect(rowIndex);
        Line nextRow = orderedPCode.getLineDirect(rowIndex + 1);
        currentRow.getCommands().addAll(nextRow.getCommands());
        currentRow.setLine(String.valueOf(currentRow.getLine()) + ":" + nextRow.getLine());
        rowsMerged.add(nextRow.getNumber());
        orderedPCode.removeRow(nextRow.getNumber());
    }

    private void analyze(OrderedPCode orderedPCode) {
        PCodeVisitor visitor = new PCodeVisitor(orderedPCode);
        visitor.accept((line, command, index) -> {
            if (command instanceof End) {
                this.analysis.rowsWithJumps.add(line.getNumber());
                return;
            }
            if (command instanceof Run) {
                this.analysis.rowsWithJumps.add(line.getNumber());
                return;
            }
            if (command instanceof If) {
                this.analysis.rowsWithJumps.add(line.getNumber());
                return;
            }
            this.analysis.addCommand(command);
            this.analysis.checkForJumps(line.getNumber(), command);
        });
    }

    private static class Analysis {
        public SortedSet<Integer> rowsWithGotoTarget = new TreeSet<Integer>();
        public SortedSet<Integer> rowsWithJumps = new TreeSet<Integer>();

        private Analysis() {
        }

        public void clear() {
            this.rowsWithGotoTarget.clear();
        }

        public void addStatement(Goto gotoStatement) {
            this.rowsWithGotoTarget.add(gotoStatement.getTargetLineNumber());
        }

        public void addStatement(On onStatement) {
            for (int jumpTarget : onStatement.getLineNumbers()) {
                this.rowsWithGotoTarget.add(jumpTarget);
            }
        }

        public void addStatement(Gosub gotoStatement) {
            this.rowsWithGotoTarget.add(gotoStatement.getTargetLineNumber());
        }

        public void addCommand(Command command) {
            if (command instanceof Gosub) {
                this.addStatement((Gosub)command);
            } else if (command instanceof Goto) {
                this.addStatement((Goto)command);
            } else if (command instanceof On) {
                this.addStatement((On)command);
            } else {
                return;
            }
        }

        public void checkForJumps(int lineNumber, Command command) {
            if (Analysis.isJumpCommand(command)) {
                this.rowsWithJumps.add(lineNumber);
            }
        }

        public static boolean isLineContainingJumps(Line line) {
            for (Command c : line.getCommands()) {
                if (!Analysis.isJumpCommand(c)) continue;
                return true;
            }
            return false;
        }

        private static boolean isJumpCommand(Command command) {
            if (command instanceof Gosub) {
                return true;
            }
            if (command instanceof On) {
                return true;
            }
            if (command instanceof Goto) {
                return true;
            }
            return command instanceof Return;
        }

        public boolean isLineWithJumps(Line line) {
            return this.rowsWithJumps.contains(line.getNumber());
        }

        public boolean isLineTargetedByJump(Line line) {
            return this.rowsWithGotoTarget.contains(line.getNumber());
        }
    }
}

