/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.cbmnative.crossoptimizer.passes;

import com.sixtyfour.Logger;
import com.sixtyfour.cbmnative.crossoptimizer.PCodeOptimizer;
import com.sixtyfour.cbmnative.crossoptimizer.common.OrderedPCode;
import com.sixtyfour.cbmnative.crossoptimizer.common.PCodeVisitor;
import com.sixtyfour.cbmnative.crossoptimizer.passes.HighLevelOptimizer;
import com.sixtyfour.elements.commands.Gosub;
import com.sixtyfour.elements.commands.Goto;
import com.sixtyfour.elements.commands.Return;
import com.sixtyfour.parser.Line;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class InlineOneBlockGosub
implements HighLevelOptimizer {
    private void addCount(Map<Integer, Integer> countedGoSubs, int targetLine) {
        Integer getTargetCount = countedGoSubs.get(targetLine);
        if (getTargetCount == null) {
            countedGoSubs.put(targetLine, 1);
        } else {
            countedGoSubs.put(targetLine, 1 + getTargetCount);
        }
    }

    @Override
    public boolean optimize(OrderedPCode orderedPCode) {
        List<Integer> linesWithSingleGosub = this.getInlinableGosubs(orderedPCode);
        block0: for (int lineWithGosub : linesWithSingleGosub) {
            int targetGosubStart;
            Line line = orderedPCode.getLine(lineWithGosub);
            Gosub gosub = (Gosub)line.getFirstCommand();
            Goto replaceGoto = new Goto();
            replaceGoto.setTargetLineNumber(gosub.getTargetLineNumber());
            PCodeOptimizer.replaceLastCommandInLine(line, replaceGoto, "goto " + gosub.getTargetLineNumber());
            int targetReturn = targetGosubStart = orderedPCode.getLineIndex(gosub.getTargetLineNumber());
            while (true) {
                Line candidateReturnLine;
                Return retCommand;
                if ((retCommand = (candidateReturnLine = orderedPCode.getLineDirect(targetReturn)).getAnyCommand(Return.class)) != null) {
                    this.InlineCall(orderedPCode, lineWithGosub, gosub, candidateReturnLine);
                    continue block0;
                }
                ++targetReturn;
            }
        }
        int countReplacements = linesWithSingleGosub.size();
        if (countReplacements > 0) {
            Logger.log("Inline gosub count: " + countReplacements);
        }
        return countReplacements != 0;
    }

    private void InlineCall(OrderedPCode orderedPCode, int lineWithGosub, Gosub gosub, Line returnLine) {
        int gosubIndex = orderedPCode.getLineIndex(lineWithGosub);
        Goto gotoNext = new Goto();
        int nextLineIndex = orderedPCode.getLineDirect(gosubIndex + 1).getNumber();
        gotoNext.setTargetLineNumber(nextLineIndex);
        PCodeOptimizer.replaceLastCommandInLine(returnLine, gotoNext, "goto " + nextLineIndex);
        Logger.log(String.valueOf(lineWithGosub) + ": GOSUB " + gosub.getTargetLineNumber() + "' is converted to 'Goto' and method is inlined from range: (" + gosub.getTargetLineNumber() + ".." + returnLine.getNumber() + ")");
    }

    private List<Integer> getInlinableGosubs(OrderedPCode orderedPCode) {
        HashMap countedGoSubs = new HashMap();
        HashSet excludedCandidates = new HashSet();
        ArrayList linesWithSingleGoSub = new ArrayList();
        PCodeVisitor pCodeVisitor = new PCodeVisitor(orderedPCode);
        PCodeVisitor.IVisitor visitor = (l, command, idx) -> {
            Gosub gosub = (Gosub)command;
            int target = gosub.getTargetLineNumber();
            this.addCount(countedGoSubs, target);
            if (l.getCommands().size() != 1) {
                excludedCandidates.add(target);
            } else {
                linesWithSingleGoSub.add(l.getNumber());
            }
        };
        pCodeVisitor.accept("gosub", visitor);
        ArrayList<Integer> singleGosubs = new ArrayList<Integer>();
        Iterator iterator = linesWithSingleGoSub.iterator();
        while (iterator.hasNext()) {
            int lineIndex = (Integer)iterator.next();
            Line line = orderedPCode.getLine(lineIndex);
            Gosub gosub = (Gosub)line.getFirstCommand();
            int gosubTarget = gosub.getTargetLineNumber();
            int gosubCount = (Integer)countedGoSubs.get(gosubTarget);
            if (gosubCount != 1 || excludedCandidates.contains(gosubTarget)) continue;
            singleGosubs.add(lineIndex);
        }
        return singleGosubs;
    }
}

