/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.cbmnative.crossoptimizer.passes;

import com.sixtyfour.Logger;
import com.sixtyfour.cbmnative.crossoptimizer.common.OrderedPCode;
import com.sixtyfour.cbmnative.crossoptimizer.passes.HighLevelOptimizer;
import com.sixtyfour.elements.commands.Command;
import com.sixtyfour.elements.commands.Gosub;
import com.sixtyfour.elements.commands.If;
import com.sixtyfour.elements.commands.Return;
import com.sixtyfour.parser.Line;
import java.util.List;

public class InlineSimpleGosubBlock
implements HighLevelOptimizer {
    @Override
    public boolean optimize(OrderedPCode orderedPCode) {
        boolean found;
        boolean result = false;
        do {
            found = this.findGosubToInline(orderedPCode);
            result |= found;
        } while (found);
        return result;
    }

    private boolean findGosubToInline(OrderedPCode orderedPCode) {
        for (Line l : orderedPCode.getLines()) {
            List<Command> commands = l.getCommands();
            int i = 0;
            while (i < commands.size()) {
                List<Command> targetCommands;
                Command lastTargetCommand;
                Gosub gosub;
                Line targetLine;
                If anyIfInTarget;
                Command c = commands.get(i);
                if (c instanceof Gosub && (anyIfInTarget = (targetLine = orderedPCode.getLine((gosub = (Gosub)c).getTargetLineNumber())).getAnyCommand(If.class)) == null && (lastTargetCommand = (targetCommands = targetLine.getCommands()).get(targetCommands.size() - 1)) instanceof Return) {
                    this.inlineRow(l, i, targetLine, orderedPCode);
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static String removeLastCmd(String fullLine) {
        int lastIndex = fullLine.lastIndexOf(":");
        if (lastIndex == -1) {
            return "";
        }
        String bodyWithoutReturn = fullLine.substring(0, lastIndex);
        return bodyWithoutReturn;
    }

    private void inlineRow(Line line, int indexGosub, Line targetLine, OrderedPCode orderedPCode) {
        String newLine = InlineSimpleGosubBlock.inlineMethodCode(line, targetLine);
        Logger.log("Inline final GOSUB line:" + line.getNumber() + " at index: " + indexGosub + " and the code looks like this now: " + newLine);
        OrderedPCode newPcode = orderedPCode.cloneInstanceWithLineReplaced(line.getNumber(), newLine);
        orderedPCode.reset(newPcode);
    }

    private static String inlineMethodCode(Line line, Line targetLine) {
        String methodBody = InlineSimpleGosubBlock.removeLastCmd(targetLine.getLine());
        String lineCode = line.getLine();
        String gosubText = "GOSUB" + targetLine.getNumber();
        if (line.getLine().equals(gosubText)) {
            return methodBody;
        }
        lineCode = InlineSimpleGosubBlock.replaceInlineGosub(methodBody, lineCode, gosubText);
        gosubText = "GOSUB " + targetLine.getNumber();
        if (line.getLine().equals(gosubText)) {
            return methodBody;
        }
        lineCode = InlineSimpleGosubBlock.replaceInlineGosub(methodBody, lineCode, gosubText);
        return lineCode;
    }

    private static String replaceInlineGosub(String methodBody, String lineCode, String gosubText) {
        if ((lineCode = lineCode.replaceAll(String.valueOf(gosubText) + ":", String.valueOf(methodBody) + ":")).endsWith(gosubText)) {
            lineCode = lineCode.substring(0, lineCode.length() - gosubText.length());
            lineCode = String.valueOf(lineCode) + methodBody;
        }
        return lineCode;
    }
}

