/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.cbmnative.crossoptimizer.passes;

import com.sixtyfour.Logger;
import com.sixtyfour.cbmnative.crossoptimizer.common.OrderedPCode;
import com.sixtyfour.cbmnative.crossoptimizer.common.PCodeUtilities;
import com.sixtyfour.cbmnative.crossoptimizer.passes.HighLevelOptimizer;
import com.sixtyfour.elements.commands.Command;
import com.sixtyfour.elements.commands.Goto;
import com.sixtyfour.parser.Line;
import java.util.List;

public class InlineSimpleOneLineBlock
implements HighLevelOptimizer {
    @Override
    public boolean optimize(OrderedPCode orderedPCode) {
        boolean result = false;
        List<Line> lines = orderedPCode.getLines();
        int i = 0;
        int linesSize = lines.size() - 1;
        while (i < linesSize) {
            Line targetLine;
            Goto targetGoto;
            Line line = lines.get(i);
            int nextLineIndex = lines.get(i + 1).getNumber();
            Goto lineGoto = this.getLastCommandAsGoto(line);
            if (lineGoto != null && lineGoto.getTargetLineNumber() != line.getNumber() && (targetGoto = this.getLastCommandAsGoto(targetLine = orderedPCode.getLine(lineGoto.getTargetLineNumber()))) != null && targetGoto.getTargetLineNumber() == nextLineIndex) {
                this.inlineRow(line, targetLine, orderedPCode);
                result = true;
            }
            ++i;
        }
        return result;
    }

    private void inlineRow(Line line, Line targetLine, OrderedPCode orderedPCode) {
        Line cloneLine = PCodeUtilities.cloneLine(orderedPCode, targetLine.getNumber());
        List<Command> clonedCommands = cloneLine.getCommands();
        PCodeUtilities.removeLastLineCommand(cloneLine);
        if (!line.getLine().contains(":")) {
            line.setLine(cloneLine.getLine());
        } else {
            PCodeUtilities.removeLastLineCommand(line);
            String injectedInlinedCode = String.valueOf(line.getLine()) + ":" + cloneLine.getLine();
            line.setLine(injectedInlinedCode);
        }
        line.getCommands().addAll(clonedCommands);
        Logger.log("Inline final goto of line: " + line.getNumber() + " and the code looks like this now: " + line.getLine());
    }

    private Goto getLastCommandAsGoto(Line line) {
        List<Command> cmds = line.getCommands();
        Command last = cmds.get(cmds.size() - 1);
        if (last instanceof Goto) {
            return (Goto)last;
        }
        return null;
    }
}

