/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.cbmnative.javascript;

import com.sixtyfour.Logger;
import com.sixtyfour.cbmnative.Optimizer;
import com.sixtyfour.cbmnative.PlatformProvider;
import com.sixtyfour.cbmnative.ProgressListener;
import com.sixtyfour.config.CompilerConfig;
import java.util.ArrayList;
import java.util.List;

public class OptimizerJs
implements Optimizer {
    private static final int MAX_AHEAD = 9;

    @Override
    public List<String> optimize(CompilerConfig config, PlatformProvider platform, List<String> code, ProgressListener pg) {
        if (code.size() > 1) {
            Logger.log("Optimizing javascript code...");
            long s = System.currentTimeMillis();
            ArrayList<String> ret = new ArrayList<String>();
            String[] lines = new String[9];
            String[][] splittedLines = new String[9][];
            int i = 0;
            while (i < code.size() - 1) {
                int p = 0;
                while (p < 9 && p + i < code.size()) {
                    String line;
                    lines[p] = line = code.get(p + i);
                    splittedLines[p] = lines[p].split(" |,");
                    ++p;
                }
                while (p < 9) {
                    lines[p] = null;
                    splittedLines[p] = null;
                    ++p;
                }
                boolean replaced = false;
                if (lines[0].startsWith("this._stack.push(this.Y_REG);") && lines[1].startsWith("//") && lines[2].startsWith("this.X_REG=this._stack.pop();")) {
                    ret.add("this.X_REG=this.Y_REG;");
                    i += 2;
                    replaced = true;
                }
                if (lines[0].startsWith("this._zeroflag=(this.") && lines[1].startsWith("if (this._zeroflag")) {
                    int pos = lines[0].indexOf("(");
                    int pos2 = lines[0].lastIndexOf(")");
                    ret.add(lines[1].replace("this._zeroflag", lines[0].substring(pos, pos2 + 1)));
                    ++i;
                    replaced = true;
                }
                if (lines[0].startsWith("return") && lines[0].contains(" ") && (lines[4].startsWith("return") && lines[4].contains(" ") || lines[5].startsWith("return") && lines[5].contains(" ") && lines[4].startsWith("//"))) {
                    if (lines[4].startsWith("//")) {
                        int pp = 4;
                        while (pp < 8) {
                            lines[pp] = lines[pp + 1];
                            ++pp;
                        }
                    }
                    String label = lines[0].split(" ")[1].replace(";", "").trim();
                    String label4 = lines[4].split(" ")[1].replace(";", "").trim();
                    label = label.startsWith("\"") ? label.substring(1, label.length() - 1) : "line_" + label;
                    label4 = label4.startsWith("\"") ? label4.substring(1, label4.length() - 1) : "line_" + label4;
                    if (lines[1].startsWith("}") && lines[2].startsWith("//") && lines[3].startsWith("this." + label + " = function") && lines[5].startsWith("}") && lines[6].startsWith("//") && lines[7].startsWith("this." + label4 + " = function")) {
                        replaced = true;
                        ret.add(lines[4]);
                    }
                }
                if (!replaced) {
                    ret.add(lines[0]);
                }
                ++i;
            }
            Logger.log("Javascript code optimized in " + (System.currentTimeMillis() - s) + "ms");
            ret.add(code.get(code.size() - 1));
            return ret;
        }
        return code;
    }
}

