/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.cbmnative.javascript;

import com.sixtyfour.Loader;
import com.sixtyfour.Logger;
import com.sixtyfour.cbmnative.Generator;
import com.sixtyfour.cbmnative.GeneratorContext;
import com.sixtyfour.cbmnative.PlatformProvider;
import com.sixtyfour.cbmnative.Transformer;
import com.sixtyfour.cbmnative.javascript.generators.GeneratorListJs;
import com.sixtyfour.cbmnative.mos6502.AbstractTransformer;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.config.MemoryConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.system.DataStore;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.ConstantExtractor;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TransformerJs
implements Transformer {
    @Override
    public List<String> transform(CompilerConfig config, MemoryConfig memConfig, Machine machine, PlatformProvider platform, List<String> code) {
        Logger.log("Compiling into javascript code...");
        this.addContinues(code);
        ArrayList<String> res = new ArrayList<String>();
        ArrayList<String> consts = new ArrayList<String>();
        ArrayList<String> vars = new ArrayList<String>();
        ArrayList<String> mnems = new ArrayList<String>();
        ArrayList<String> subs = new ArrayList<String>();
        List<Object> datas = new ArrayList();
        subs.add("// *** SUBROUTINES ***");
        subs.addAll(Arrays.asList(Loader.loadProgram(this.getClass().getResourceAsStream("/subroutines.js"))));
        AbstractTransformer.addExtensionSubroutines(subs, "js");
        res.addAll(Arrays.asList(Loader.loadProgram(this.getClass().getResourceAsStream("/webworker.js"))));
        res.add("function Compiled(output) {");
        res.add("this.outputter=function(txt) {console.log(txt);}");
        res.add("if (output) {this.outputter=output;}");
        res.add("this.INIT = function() {");
        res.add("this.X_REG=0.0;");
        res.add("this.Y_REG=0.0;");
        res.add("this.C_REG=0.0;");
        res.add("this.D_REG=0.0;");
        res.add("this.E_REG=0.0;");
        res.add("this.F_REG=0.0;");
        res.add("this.A_REG=0;");
        res.add("this.B_REG=0;");
        res.add("this.G_REG=0;");
        res.add("this.CMD_NUM=0;");
        res.add("this.CHANNEL=0;");
        res.add("this.JUMP_TARGET=\"\";");
        res.add("this.USR_PARAM=0;");
        res.add("this._line=\"\";");
        res.add("this._stack=new Array();");
        res.add("this._forstack=new Array();");
        res.add("this._memory=new Array(65535);");
        res.add("this._zeroflag=0");
        res.add("this._timeOffset=0");
        res.add("this._time=0");
        res.add("this._inputQueue=new Array();");
        Map<String, Integer> map = ConstantExtractor.getAllConstantMaps();
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            res.add("this." + entry.getKey() + "=" + entry.getValue() + ";");
        }
        int cnt = 0;
        ArrayList<String> strVars = new ArrayList<String>();
        ArrayList<String> strArrayVars = new ArrayList<String>();
        HashMap<String, String> name2label = new HashMap<String, String>();
        GeneratorContext context = new GeneratorContext();
        Iterator<String> iterator = code.iterator();
        while (iterator.hasNext()) {
            String line;
            String cmd = line = iterator.next();
            String orgLine = line;
            int sp = line.indexOf(" ");
            if (sp != -1) {
                line = line.substring(sp).trim();
            }
            cnt = this.extractData(platform, machine, consts, vars, strVars, strArrayVars, name2label, cnt, line);
            Generator pm = GeneratorListJs.getGenerator(orgLine);
            if (pm != null) {
                pm.generateCode(context, orgLine, mnems, subs, name2label);
                continue;
            }
            if (cmd.endsWith(":") || cmd.startsWith("CONT")) {
                mnems.add(cmd);
                continue;
            }
            mnems.add("// ignored: " + cmd);
        }
        datas = this.createDatas(machine);
        mnems.add("}");
        res.addAll(consts);
        res.addAll(datas);
        vars.addAll(strVars);
        vars.addAll(strArrayVars);
        res.addAll(vars);
        res.add("}");
        res.addAll(mnems);
        res.addAll(subs);
        res.add("}");
        return res;
    }

    private List<String> createDatas(Machine machine) {
        DataStore datas = machine.getDataStore();
        ArrayList<String> ret = new ArrayList<String>();
        if (datas.size() > 0) {
            String strDat = "this._datas=[";
            ret.add("this._dataPtr=0;");
            datas.restore();
            Object obj = null;
            while ((obj = datas.read()) != null) {
                Type type = Type.STRING;
                if (VarUtils.isInteger(obj)) {
                    type = Type.INTEGER;
                } else if (VarUtils.isFloat(obj) || VarUtils.isDouble(obj)) {
                    type = Type.REAL;
                }
                if (obj.toString().equals("\\0")) {
                    obj = "";
                }
                strDat = type == Type.INTEGER ? String.valueOf(strDat) + obj.toString() + "," : (type == Type.REAL ? String.valueOf(strDat) + obj.toString() + "," : String.valueOf(strDat) + "\"" + obj.toString() + "\"" + ",");
            }
            strDat = String.valueOf(strDat.substring(0, strDat.length() - 1)) + "];";
            ret.add(strDat);
        }
        return ret;
    }

    private void addContinues(List<String> code) {
        int cnt = 0;
        int forCnt = 0;
        int i = 0;
        while (i < code.size()) {
            String cont;
            String line = code.get(i);
            if (line.equals("JSR GOSUB")) {
                cont = "GOSUBCONT" + cnt++;
                int add = 2;
                if (code.get(i + 1).equals("NOP")) {
                    add = 3;
                }
                code.add(i + add, String.valueOf(cont) + ":");
                code.set(i, "JSR GOSUB(\"" + cont + "\")");
            } else if (line.equals("JSR INITFOR")) {
                cont = "FORLOOP" + forCnt++;
                String var = code.get(i - 1);
                var = var.substring(var.indexOf("(") + 1, var.lastIndexOf("{"));
                code.add(i + 1, String.valueOf(cont) + ":");
                code.set(i, "JSR INITFOR(\"" + cont + "\",\"VAR_" + var + "\")");
                code.set(i - 1, "NOP");
            } else if (line.equals("JSR NEXT")) {
                String var = code.get(i - 1);
                var = var.contains("{}") ? "VAR_" + var.substring(var.indexOf("(") + 1, var.indexOf("{")) : "0";
                code.set(i - 1, "NOP");
                code.set(i, "JSR NEXT(\"" + var + "\")");
            }
            ++i;
        }
    }

    private int extractData(PlatformProvider platform, Machine machine, List<String> consts, List<String> vars, List<String> strVars, List<String> strArrayVars, Map<String, String> name2label, int cnt, String line) {
        String[] parts = line.split(",", 2);
        ArrayList<String> tmp = new ArrayList<String>();
        int p = 0;
        while (p < parts.length) {
            String part = parts[p];
            if (part.contains("{") && part.endsWith("}")) {
                int pos = part.lastIndexOf("{");
                String name = part.substring(0, pos);
                name = name.replace("%", "_int");
                if ((name = name.replace("[]", "_array")).startsWith("#")) {
                    Type type = Type.valueOf(part.substring(pos + 1, part.length() - 1));
                    String keyName = name;
                    if (type == Type.STRING) {
                        keyName = name = "$" + name.substring(1);
                    }
                    if (!name2label.containsKey(keyName)) {
                        String label = "CONST_" + cnt++;
                        name2label.put(keyName, label);
                        name = name.substring(1);
                        if (type == Type.INTEGER) {
                            consts.add("this." + label + "=" + name + ";");
                        } else if (type == Type.REAL) {
                            consts.add("this." + label + "=" + name + ";");
                        } else if (type == Type.STRING) {
                            consts.add("this." + label + "=\"" + name + "\";");
                        }
                    }
                } else if (!name2label.containsKey(name)) {
                    tmp.clear();
                    String label = "VAR_" + name;
                    name2label.put(name, label);
                    Type type = Type.valueOf(part.substring(pos + 1, part.length() - 1));
                    if (name.endsWith("_array")) {
                        tmp.add("this." + label + "=new Array();");
                    } else if (type == Type.INTEGER) {
                        tmp.add("this." + label + "=0;");
                    } else if (type == Type.REAL) {
                        tmp.add("this." + label + "=0.0;");
                    } else if (type == Type.STRING) {
                        tmp.add("this." + label + "=\"\";");
                    }
                    if (name.contains("$")) {
                        if (name.endsWith("_array")) {
                            strArrayVars.addAll(tmp);
                        } else {
                            strVars.addAll(tmp);
                        }
                    } else {
                        vars.addAll(tmp);
                    }
                }
            }
            ++p;
        }
        return cnt;
    }

    @Override
    public void setVariableStart(int variableStart) {
    }

    @Override
    public int getStringMemoryEnd() {
        return 0;
    }

    @Override
    public void setStringMemoryEnd(int stringMemoryEnd) {
    }

    @Override
    public int getVariableStart() {
        return 0;
    }

    @Override
    public int getStartAddress() {
        return 0;
    }

    @Override
    public void setStartAddress(int addr) {
    }

    @Override
    public int getRuntimeStart() {
        return 0;
    }

    @Override
    public void setRuntimeStart(int runtimeStart) {
    }

    @Override
    public boolean isOptimizedTempStorage() {
        return false;
    }

    @Override
    public void setOptimizedTempStorage(boolean optimizedTemp) {
    }

    @Override
    public List<String> createCaller(String calleeName) {
        List<String> res = Arrays.asList(Loader.loadProgram(this.getClass().getResourceAsStream("/caller.js")));
        ArrayList<String> ret = new ArrayList<String>();
        for (String line : res) {
            ret.add(line.replace("{*}", calleeName));
        }
        return ret;
    }
}

