/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.cbmnative.javascript.generators;

import com.sixtyfour.cbmnative.GeneratorContext;
import com.sixtyfour.cbmnative.Operand;
import com.sixtyfour.cbmnative.Operands;
import com.sixtyfour.cbmnative.javascript.generators.GeneratorBaseJs;
import com.sixtyfour.elements.Type;
import java.util.List;
import java.util.Map;

public class MovJs
extends GeneratorBaseJs {
    @Override
    public String getMnemonic() {
        return "MOV";
    }

    @Override
    public void generateCode(GeneratorContext context, String line, List<String> nCode, List<String> subCode, Map<String, String> name2label) {
        Operands ops = new Operands(line, name2label);
        Operand source = ops.getSource();
        Operand target = ops.getTarget();
        context.setLastMoveSource(source);
        context.setLastMoveTarget(target);
        if (!source.isIndexed() && !target.isIndexed()) {
            if (source.getType() == Type.STRING) {
                if (source.isArray()) {
                    this.sourceStringArray(nCode, source, target);
                } else {
                    this.sourceString(nCode, source, target);
                }
            } else if (target.getType() == Type.STRING) {
                this.targetString(nCode, source, target);
            } else if (source.isArray()) {
                this.noIndexArraySource(nCode, source, target);
            } else if (source.getType() == Type.INTEGER) {
                this.noIndexIntegerSource(nCode, source, target);
            } else {
                this.noIndexRealSource(nCode, source, target);
            }
        } else if (target.getType() == Type.INTEGER) {
            this.indexedTargetInteger(nCode, source, target);
        } else if (source.isIndexed() && source.isRegister()) {
            this.indexedSourceTargetReal(nCode, source, target);
        } else {
            throw new RuntimeException("Invalid index mode: " + line);
        }
        this.truncInteger(nCode, target);
    }

    private void targetString(List<String> nCode, Operand source, Operand target) {
        if (!this.checkSpecialWriteVars(nCode, target, source)) {
            String from = this.getOpName(source);
            String to = this.getOpName(target);
            nCode.add(String.valueOf(to) + "=" + from + ";");
        }
    }

    private void sourceString(List<String> nCode, Operand source, Operand target) {
        if (!this.checkSpecialReadVars(nCode, target, source)) {
            String from = this.getOpName(source);
            String to = this.getOpName(target);
            nCode.add(String.valueOf(to) + "=" + from + ";");
        } else {
            String to = this.getOpName(target);
            nCode.add(String.valueOf(to) + "=this.tmpy;");
        }
    }

    private void sourceStringArray(List<String> nCode, Operand source, Operand target) {
        this.sourceString(nCode, source, target);
    }

    private void noIndexArraySource(List<String> nCode, Operand source, Operand target) {
        String from = this.getOpName(source);
        String to = this.getOpName(target);
        nCode.add(String.valueOf(to) + "=" + from + ";");
    }

    private void indexedTargetInteger(List<String> nCode, Operand source, Operand target) {
        String from = this.getOpName(source);
        String to = this.getOpName(target);
        nCode.add("this._memory[" + to + "]" + "=" + from + ";");
    }

    private void indexedSourceTargetReal(List<String> nCode, Operand source, Operand target) {
        String from = this.getOpName(source);
        String to = this.getOpName(target);
        nCode.add(String.valueOf(to) + "=" + "this._memory[" + from + "];");
    }

    private void noIndexRealSource(List<String> nCode, Operand source, Operand target) {
        if (!this.checkSpecialReadVars(nCode, target, source)) {
            this.noIndexArraySource(nCode, source, target);
        } else {
            String to = this.getOpName(target);
            nCode.add(String.valueOf(to) + "=this.tmpy;");
        }
    }

    private void noIndexIntegerSource(List<String> nCode, Operand source, Operand target) {
        this.noIndexArraySource(nCode, source, target);
    }
}

