/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.cbmnative.javascript.generators;

import com.sixtyfour.cbmnative.GeneratorContext;
import com.sixtyfour.cbmnative.Operand;
import com.sixtyfour.cbmnative.Operands;
import com.sixtyfour.cbmnative.javascript.generators.MovJs;
import com.sixtyfour.elements.Type;
import java.util.List;
import java.util.Map;

public class MovbJs
extends MovJs {
    @Override
    public String getMnemonic() {
        return "MOVB";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void generateCode(GeneratorContext context, String line, List<String> nCode, List<String> subCode, Map<String, String> name2label) {
        Operands ops = new Operands(line, name2label);
        Operand source = ops.getSource();
        Operand target = ops.getTarget();
        context.setLastMoveSource(source);
        context.setLastMoveTarget(target);
        if (!source.isIndexed() && !target.isIndexed()) {
            if (source.getType() == Type.INTEGER) {
                this.noIndexIntegerSource(nCode, source, target);
                return;
            } else {
                this.noIndexRealSource(nCode, source, target);
            }
            return;
        } else {
            if (target.isIndexed() && source.isIndexed()) {
                throw new RuntimeException("Invalid index mode (both sides are indexed!): " + line);
            }
            if (!target.isRegister() || !source.isRegister()) {
                if (!target.isRegister() || !source.isConstant()) throw new RuntimeException("Invalid index mode (at least one side isn't a register and source isn't a constant value either!): " + line);
                this.indexedTargetWithConstant(nCode, source, target);
                return;
            } else if (target.isIndexed()) {
                this.indexedTarget(nCode, source, target);
                return;
            } else {
                this.indexedSource(nCode, source, target);
            }
        }
    }

    private void indexedTargetWithConstant(List<String> nCode, Operand source, Operand target) {
        String from = this.getOpName(source);
        String to = this.getOpName(target);
        nCode.add("this._memory[Math.floor(" + to + ")]=Math.floor(" + from + ") & 255;");
    }

    private void indexedSource(List<String> nCode, Operand source, Operand target) {
        String from = this.getOpName(source);
        String to = this.getOpName(target);
        nCode.add(String.valueOf(to) + "=this._memory[Math.floor(" + from + ") & 65535];");
    }

    private void indexedTarget(List<String> nCode, Operand source, Operand target) {
        this.indexedTargetWithConstant(nCode, source, target);
    }

    private void noIndexRealSource(List<String> nCode, Operand source, Operand target) {
        String from = this.getOpName(source);
        String addr = target.getAddress();
        if (addr == null || !addr.contains(":")) {
            this.fillMemory(nCode, target, from);
        } else {
            String[] as = addr.split(":");
            target.setAddress(as[0].trim());
            this.fillMemory(nCode, target, from);
            target.setAddress(as[1].trim());
            this.fillMemory(nCode, target, String.valueOf(from) + " >> 8");
        }
    }

    private void noIndexIntegerSource(List<String> nCode, Operand source, Operand target) {
        this.noIndexRealSource(nCode, source, target);
    }

    private void fillMemory(List<String> nCode, Operand target, String from) {
        String to = this.getOpName(target);
        if (this.isNumber(from)) {
            from = "this._memory[" + from + "]";
        }
        if (this.isNumber(to)) {
            to = "this._memory[" + to + "]";
        }
        nCode.add(String.valueOf(to) + "=Math.floor(" + from + ") & 255;");
    }
}

