/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.cbmnative.mos6502;

import com.sixtyfour.Logger;
import com.sixtyfour.cbmnative.Unlinker;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class Unlinker6502
implements Unlinker {
    @Override
    public List<String> unlink(List<String> res) {
        Logger.log("Unlinking unused runtime code...");
        ArrayList<String> ret = new ArrayList<String>();
        int posy = res.lastIndexOf("; *** SUBROUTINES ***");
        int posyEnd = res.lastIndexOf("; *** SUBROUTINES END ***");
        List<String> endRet = res.subList(posyEnd, res.size());
        res = res.subList(0, posyEnd);
        ret.addAll(res.subList(0, posy + 1));
        Set<String> codeJumps = this.findJumps(ret);
        List<String> subs = res.subList(posy + 1, res.size());
        int codeLength = 0;
        do {
            codeLength = codeJumps.size();
            int cnt = 0;
            for (String line : subs) {
                if (codeJumps.contains(line = this.findLabel(line))) {
                    int start = this.find(subs, cnt, -1);
                    int end = this.find(subs, cnt, 1);
                    if (start == -1 || end == -1) {
                        throw new RuntimeException("Failed to find block delimiter @ " + cnt + "/" + subs.get(cnt));
                    }
                    List<String> subSubs = subs.subList(start, end + 1);
                    codeJumps.addAll(this.findJumps(subSubs));
                }
                ++cnt;
            }
        } while (codeJumps.size() > codeLength);
        int i = 0;
        while (i < subs.size()) {
            String line;
            line = subs.get(i);
            if (!line.startsWith(";")) {
                int start = this.find(subs, i, -1);
                int end = this.find(subs, i, 1);
                List<String> subSubs = subs.subList(start, end + 1);
                boolean used = false;
                for (String subLine : subSubs) {
                    if (!codeJumps.contains(subLine = this.findLabel(subLine)) && !subLine.startsWith("INITS") && !subLine.startsWith("INITN")) continue;
                    used = true;
                    break;
                }
                if (used) {
                    ret.addAll(subSubs);
                }
                i = end;
            }
            ++i;
        }
        ret.addAll(endRet);
        return ret;
    }

    private String findLabel(String line) {
        line = line.trim().toUpperCase(Locale.ENGLISH);
        int pos = (line = line.replace("\t", " ")).indexOf(" ");
        if (pos != -1) {
            line = line.substring(0, pos);
        }
        return line;
    }

    private int find(List<String> subs, int cnt, int dir) {
        int i = cnt;
        while (i >= 0 && i < subs.size()) {
            if (subs.get(i).startsWith(";###")) {
                return i;
            }
            i += dir;
        }
        return -1;
    }

    private Set<String> findJumps(List<String> ret) {
        String[] jumps = new String[]{"JMP", "JSR", "BNE", "BEQ", "BMI", "BCC", "BCS", "BRA"};
        HashSet<String> labels = new HashSet<String>();
        block0: for (String line : ret) {
            line = line.replace("\t", " ");
            String[] stringArray = jumps;
            int n = jumps.length;
            int n2 = 0;
            while (n2 < n) {
                String jmp = stringArray[n2];
                jmp = String.valueOf(jmp) + " ";
                if (line.toUpperCase(Locale.ENGLISH).contains(jmp)) {
                    int pos = line.indexOf(jmp);
                    String end = line.substring(pos + 4);
                    if ((pos = end.indexOf(";")) != -1) {
                        end = end.substring(0, pos);
                    }
                    end = end.trim();
                    labels.add(end);
                    continue block0;
                }
                ++n2;
            }
        }
        return labels;
    }
}

