/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.cbmnative.mos6502.generators;

import com.sixtyfour.cbmnative.Generator;
import com.sixtyfour.cbmnative.GeneratorContext;
import com.sixtyfour.cbmnative.Operand;
import com.sixtyfour.cbmnative.Operands;
import java.util.List;
import java.util.Map;

public abstract class Calculation
implements Generator {
    protected String comment = null;
    protected String systemCall = null;
    protected String mnemonic = null;
    protected boolean skipArgTransfer = false;

    protected Calculation(String mnemonic, String comment, String systemCall) {
        this.mnemonic = mnemonic;
        this.comment = comment;
        this.systemCall = systemCall;
        this.skipArgTransfer = false;
    }

    protected Calculation(String mnemonic, String comment, String systemCall, boolean skipArgTransfer) {
        this.mnemonic = mnemonic;
        this.comment = comment;
        this.systemCall = systemCall;
        this.skipArgTransfer = skipArgTransfer;
    }

    @Override
    public String getMnemonic() {
        return this.mnemonic;
    }

    @Override
    public void generateCode(GeneratorContext context, String line, List<String> nCode, List<String> subCode, Map<String, String> name2label) {
        Operands ops = new Operands(line, name2label);
        Operand source = ops.getSource();
        Operand target = ops.getTarget();
        if (source.isRegister()) {
            nCode.add("LDA #<" + source.getRegisterName());
            nCode.add("LDY #>" + source.getRegisterName());
        } else {
            nCode.add("LDA #<" + source.getAddress());
            nCode.add("LDY #>" + source.getAddress());
        }
        nCode.add("; Real in (A/Y) to FAC");
        nCode.add("JSR REALFAC");
        if (target.isRegister()) {
            nCode.add("LDA #<" + target.getRegisterName());
            nCode.add("LDY #>" + target.getRegisterName());
        } else {
            nCode.add("LDA #<" + target.getAddress());
            nCode.add("LDY #>" + target.getAddress());
        }
        if (!this.skipArgTransfer) {
            nCode.add("; Real in (A/Y) to ARG");
            nCode.add("JSR MEMARG");
        }
        nCode.add(this.comment);
        nCode.add(this.systemCall);
        if (target.isRegister()) {
            nCode.add("LDX #<" + target.getRegisterName());
            nCode.add("LDY #>" + target.getRegisterName());
        } else {
            nCode.add("LDX #<" + target.getAddress());
            nCode.add("LDY #>" + target.getAddress());
        }
        nCode.add("; FAC to (X/Y)");
        nCode.add("JSR FACMEM");
    }
}

