/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.cbmnative.mos6502.generators;

import com.sixtyfour.cbmnative.GeneratorContext;
import com.sixtyfour.cbmnative.Operand;
import com.sixtyfour.cbmnative.Operands;
import com.sixtyfour.cbmnative.mos6502.generators.GeneratorBase;
import com.sixtyfour.elements.Type;
import java.util.List;
import java.util.Map;

public class Cmp
extends GeneratorBase {
    private static int CNT = 0;

    @Override
    public String getMnemonic() {
        return "CMP";
    }

    @Override
    public void generateCode(GeneratorContext context, String line, List<String> nCode, List<String> subCode, Map<String, String> name2label) {
        Operands ops = new Operands(line, name2label);
        Operand source = ops.getSource();
        Operand target = ops.getTarget();
        if (!source.isIndexed() && !target.isIndexed()) {
            if (source.getType() == Type.INTEGER) {
                this.noIndexIntegerSource(nCode, source, target);
            } else {
                this.noIndexRealSource(nCode, source, target);
            }
        } else {
            throw new RuntimeException("Invalid indexing mode: " + line);
        }
        nCode.add("COMP_SKP" + CNT + ":");
        ++CNT;
    }

    private void noIndexRealSource(List<String> nCode, Operand source, Operand target) {
        if (source.isRegister()) {
            nCode.add("LDA #<" + source.getRegisterName());
            nCode.add("LDY #>" + source.getRegisterName());
        } else {
            nCode.add("LDA #<" + source.getAddress());
            nCode.add("LDY #>" + source.getAddress());
        }
        nCode.add("; Real in (A/Y) to FAC");
        nCode.add("JSR REALFAC");
        if (target.getType() == Type.INTEGER) {
            nCode.add("; FAC to integer in Y/A");
            nCode.add("JSR FACINT");
            if (target.isRegister()) {
                nCode.add("CPY " + target.getRegisterName());
                nCode.add("BNE COMP_SKP" + CNT);
                nCode.add("CMP " + this.createAddress(target.getRegisterName(), 1));
                nCode.add("BNE COMP_SKP" + CNT);
            } else {
                nCode.add("CPY " + target.getAddress());
                nCode.add("BNE COMP_SKP" + CNT);
                nCode.add("CMP " + this.createAddress(target.getAddress(), 1));
                nCode.add("BNE COMP_SKP" + CNT);
            }
        } else {
            if (target.isRegister()) {
                nCode.add("LDA #<" + target.getRegisterName());
                nCode.add("LDY #>" + target.getRegisterName());
            } else {
                nCode.add("LDA #<" + target.getAddress());
                nCode.add("LDY #>" + target.getAddress());
            }
            nCode.add("; CMPFAC with (A/Y)");
            nCode.add("JSR CMPFAC");
        }
    }

    private void noIndexIntegerSource(List<String> nCode, Operand source, Operand target) {
        if (source.isRegister()) {
            nCode.add("LDY " + source.getRegisterName());
            nCode.add("LDA " + this.createAddress(source.getRegisterName(), 1));
        } else {
            nCode.add("LDY " + source.getAddress());
            nCode.add("LDA " + this.createAddress(source.getAddress(), 1));
        }
        if (target.getType() == Type.INTEGER) {
            if (target.isRegister()) {
                nCode.add("CPY " + target.getRegisterName());
                nCode.add("BNE COMP_SKP" + CNT);
                nCode.add("CMP " + this.createAddress(target.getRegisterName(), 1));
                nCode.add("BNE COMP_SKP" + CNT);
            } else {
                nCode.add("CPY " + target.getAddress());
                nCode.add("BNE COMP_SKP" + CNT);
                nCode.add("CMP " + this.createAddress(target.getAddress(), 1));
                nCode.add("BNE COMP_SKP" + CNT);
            }
        } else {
            nCode.add("; integer in Y/A to FAC");
            nCode.add("JSR INTFAC");
            if (target.isRegister()) {
                nCode.add("LDA #<" + target.getRegisterName());
                nCode.add("LDY #>" + target.getRegisterName());
            } else {
                nCode.add("LDA #<" + target.getAddress());
                nCode.add("LDY #>" + target.getAddress());
            }
            nCode.add("; CMPFAC with (A/Y)");
            nCode.add("JSR CMPFAC");
        }
    }
}

