/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.cbmnative.mos6502.generators;

import com.sixtyfour.cbmnative.Generator;
import com.sixtyfour.cbmnative.GeneratorContext;
import com.sixtyfour.cbmnative.Operand;
import com.sixtyfour.cbmnative.Operands;
import com.sixtyfour.elements.Type;
import java.util.List;
import java.util.Map;

public abstract class Compare
implements Generator {
    protected static int CNT = 0;
    protected String mnemonic = null;
    protected String command;

    protected Compare(String mnemonic, String command) {
        this.mnemonic = mnemonic;
        this.command = command;
    }

    @Override
    public String getMnemonic() {
        return this.mnemonic;
    }

    @Override
    public void generateCode(GeneratorContext context, String line, List<String> nCode, List<String> subCode, Map<String, String> name2label) {
        Operands ops = new Operands(line, name2label);
        Operand source = ops.getSource();
        Operand target = ops.getTarget();
        if (!source.isIndexed() && !target.isIndexed()) {
            if (source.getType() != Type.REAL || target.getType() != Type.REAL) {
                throw new RuntimeException("Invalid comparison: " + line);
            }
        } else {
            throw new RuntimeException("Invalid indexing mode: " + line);
        }
        this.noIndexRealSource(nCode, source, target);
        nCode.add(String.valueOf(this.mnemonic) + "_SKIP" + CNT + ":");
        nCode.add("; Real in (A/Y) to FAC");
        nCode.add("JSR REALFAC");
        if (target.isRegister()) {
            nCode.add("LDX #<" + target.getRegisterName());
            nCode.add("LDY #>" + target.getRegisterName());
        } else {
            nCode.add("LDX #<" + target.getAddress());
            nCode.add("LDY #>" + target.getAddress());
        }
        nCode.add("; FAC to (X/Y)");
        nCode.add("JSR FACMEM");
        ++CNT;
    }

    protected void noIndexRealSource(List<String> nCode, Operand source, Operand target) {
        if (source.isRegister()) {
            nCode.add("LDA #<" + source.getRegisterName());
            nCode.add("LDY #>" + source.getRegisterName());
        } else {
            nCode.add("LDA #<" + source.getAddress());
            nCode.add("LDY #>" + source.getAddress());
        }
        nCode.add("; Real in (A/Y) to FAC");
        nCode.add("JSR REALFAC");
        if (target.isRegister()) {
            nCode.add("LDA #<" + target.getRegisterName());
            nCode.add("LDY #>" + target.getRegisterName());
        } else {
            nCode.add("LDA #<" + target.getAddress());
            nCode.add("LDY #>" + target.getAddress());
        }
        nCode.add("; CMPFAC with (A/Y)");
        nCode.add("JSR CMPFAC");
        this.doCompare(nCode);
    }

    protected void doCompare(List<String> nCode) {
        nCode.add(String.valueOf(this.command) + " " + this.mnemonic + "_" + this.mnemonic + CNT);
        nCode.add("LDA #<REAL_CONST_ZERO");
        nCode.add("LDY #>REAL_CONST_ZERO");
        nCode.add("JMP " + this.mnemonic + "_SKIP" + CNT);
        nCode.add(String.valueOf(this.mnemonic) + "_" + this.mnemonic + CNT + ":");
        nCode.add("LDA #<REAL_CONST_MINUS_ONE");
        nCode.add("LDY #>REAL_CONST_MINUS_ONE");
    }
}

