/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.cbmnative.mos6502.generators;

import com.sixtyfour.cbmnative.Generator;
import com.sixtyfour.cbmnative.mos6502.generators.Abs;
import com.sixtyfour.cbmnative.mos6502.generators.Add;
import com.sixtyfour.cbmnative.mos6502.generators.And;
import com.sixtyfour.cbmnative.mos6502.generators.Atn;
import com.sixtyfour.cbmnative.mos6502.generators.Brk;
import com.sixtyfour.cbmnative.mos6502.generators.Cmp;
import com.sixtyfour.cbmnative.mos6502.generators.Cos;
import com.sixtyfour.cbmnative.mos6502.generators.Div;
import com.sixtyfour.cbmnative.mos6502.generators.Eq;
import com.sixtyfour.cbmnative.mos6502.generators.Exp;
import com.sixtyfour.cbmnative.mos6502.generators.Gt;
import com.sixtyfour.cbmnative.mos6502.generators.Gteq;
import com.sixtyfour.cbmnative.mos6502.generators.Int;
import com.sixtyfour.cbmnative.mos6502.generators.Je;
import com.sixtyfour.cbmnative.mos6502.generators.Jmp;
import com.sixtyfour.cbmnative.mos6502.generators.Jne;
import com.sixtyfour.cbmnative.mos6502.generators.Jsr;
import com.sixtyfour.cbmnative.mos6502.generators.LineNumberGenerator;
import com.sixtyfour.cbmnative.mos6502.generators.Log;
import com.sixtyfour.cbmnative.mos6502.generators.Lt;
import com.sixtyfour.cbmnative.mos6502.generators.Lteq;
import com.sixtyfour.cbmnative.mos6502.generators.Mov;
import com.sixtyfour.cbmnative.mos6502.generators.Movb;
import com.sixtyfour.cbmnative.mos6502.generators.Mul;
import com.sixtyfour.cbmnative.mos6502.generators.Neg;
import com.sixtyfour.cbmnative.mos6502.generators.Neq;
import com.sixtyfour.cbmnative.mos6502.generators.Nop;
import com.sixtyfour.cbmnative.mos6502.generators.Not;
import com.sixtyfour.cbmnative.mos6502.generators.Or;
import com.sixtyfour.cbmnative.mos6502.generators.Pop;
import com.sixtyfour.cbmnative.mos6502.generators.Pow;
import com.sixtyfour.cbmnative.mos6502.generators.Push;
import com.sixtyfour.cbmnative.mos6502.generators.Rnd;
import com.sixtyfour.cbmnative.mos6502.generators.Rts;
import com.sixtyfour.cbmnative.mos6502.generators.Sgn;
import com.sixtyfour.cbmnative.mos6502.generators.Shl;
import com.sixtyfour.cbmnative.mos6502.generators.Shr;
import com.sixtyfour.cbmnative.mos6502.generators.Sin;
import com.sixtyfour.cbmnative.mos6502.generators.Sqr;
import com.sixtyfour.cbmnative.mos6502.generators.Sub;
import com.sixtyfour.cbmnative.mos6502.generators.Tan;
import com.sixtyfour.cbmnative.mos6502.generators.Xor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class GeneratorList {
    private static final Generator LINE_NUMBER_GENERATOR = new LineNumberGenerator();
    private static final List<Generator> GENERATORS = Collections.unmodifiableList(new ArrayList<Generator>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(new Mov());
            this.add(new Movb());
            this.add(new Pop());
            this.add(new Push());
            this.add(new Jmp());
            this.add(new Jsr());
            this.add(new Rts());
            this.add(new Brk());
            this.add(new Jne());
            this.add(new Je());
            this.add(new Cmp());
            this.add(new Eq());
            this.add(new Neq());
            this.add(new Gt());
            this.add(new Gteq());
            this.add(new Lt());
            this.add(new Lteq());
            this.add(new Add());
            this.add(new Sub());
            this.add(new Mul());
            this.add(new Div());
            this.add(new Shr());
            this.add(new Shl());
            this.add(new And());
            this.add(new Or());
            this.add(new Int());
            this.add(new Pow());
            this.add(new Nop());
            this.add(new Not());
            this.add(new Sqr());
            this.add(new Exp());
            this.add(new Abs());
            this.add(new Sgn());
            this.add(new Sin());
            this.add(new Cos());
            this.add(new Tan());
            this.add(new Atn());
            this.add(new Log());
            this.add(new Rnd());
            this.add(new Xor());
            this.add(new Neg());
        }
    });
    private static final Map<String, Generator> NAME_2_GEN = new HashMap<String, Generator>(){
        private static final long serialVersionUID = 1L;
        {
            for (Generator gen : GENERATORS) {
                this.put(gen.getMnemonic(), gen);
            }
        }
    };

    public static Generator getGenerator(String line) {
        if ((line = line.trim().split(" ")[0].toUpperCase(Locale.ENGLISH)).endsWith(":") && (GeneratorList.isNumber(line) || line.startsWith("SKIP") || line.startsWith("NSKIP"))) {
            return LINE_NUMBER_GENERATOR;
        }
        return NAME_2_GEN.get(line);
    }

    private static boolean isNumber(String line) {
        try {
            line = line.replace(":", "");
            Integer.parseInt(line);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

