/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.cbmnative.mos6502.generators;

import com.sixtyfour.cbmnative.GeneratorContext;
import com.sixtyfour.cbmnative.mos6502.generators.GeneratorBase;
import java.util.List;
import java.util.Map;

public abstract class JumpBase
extends GeneratorBase {
    protected static int CNT = 0;
    protected String cmd = "";
    protected String antiCmd = "";

    JumpBase(String cmd, String antiCmd) {
        this.cmd = cmd;
        this.antiCmd = antiCmd;
    }

    public boolean mightBeSystemCallFromBasic() {
        return false;
    }

    @Override
    public void generateCode(GeneratorContext context, String line, List<String> nCode, List<String> subCode, Map<String, String> name2label) {
        String[] parts = line.split(" ");
        String label = parts[1];
        if (label.equals("($JUMP)") && this.antiCmd != null) {
            nCode.add(String.valueOf(this.antiCmd) + " R" + this.cmd + "_" + CNT);
            nCode.add("JMP (JUMP_TARGET)");
            nCode.add("R" + this.cmd + "_" + CNT + ":");
            ++CNT;
        } else if (Character.isDigit(label.charAt(0)) || label.startsWith("SKIP") || label.startsWith("NSKIP")) {
            nCode.add(String.valueOf(this.cmd) + " LINE_" + parts[1].trim());
        } else if (this.mightBeSystemCallFromBasic() && parts[1].startsWith("$")) {
            int val = Integer.parseInt(parts[1].trim().substring(1), 16);
            nCode.add("LDA #<" + val);
            nCode.add("STA TMP_ZP");
            nCode.add("LDA #>" + val);
            nCode.add("STA TMP_ZP+1");
            nCode.add("JSR SYSTEMCALL");
        } else {
            nCode.add(String.valueOf(this.cmd) + " " + parts[1].trim());
        }
    }
}

