/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.cbmnative.mos6502.generators;

import com.sixtyfour.cbmnative.Generator;
import com.sixtyfour.cbmnative.GeneratorContext;
import com.sixtyfour.cbmnative.Operand;
import com.sixtyfour.cbmnative.Operands;
import java.util.List;
import java.util.Map;

public abstract class MathFunction
implements Generator {
    private String comment = null;
    private String systemCall = null;
    private String mnemonic = null;

    protected MathFunction(String mnemonic, String comment, String systemCall) {
        this.mnemonic = mnemonic;
        this.comment = comment;
        this.systemCall = systemCall;
    }

    @Override
    public String getMnemonic() {
        return this.mnemonic;
    }

    @Override
    public void generateCode(GeneratorContext context, String line, List<String> nCode, List<String> subCode, Map<String, String> name2label) {
        Operands ops = new Operands(line, name2label);
        Operand source = ops.getSource();
        Operand target = ops.getTarget();
        if (source.isRegister()) {
            nCode.add("LDA #<" + source.getRegisterName());
            nCode.add("LDY #>" + source.getRegisterName());
        } else {
            nCode.add("LDA #<" + source.getAddress());
            nCode.add("LDY #>" + source.getAddress());
        }
        nCode.add("; Real in (A/Y) to FAC");
        nCode.add("JSR REALFAC");
        nCode.add(this.comment);
        nCode.add(this.systemCall);
        if (target.isRegister()) {
            nCode.add("LDX #<" + target.getRegisterName());
            nCode.add("LDY #>" + target.getRegisterName());
        } else {
            nCode.add("LDX #<" + target.getAddress());
            nCode.add("LDY #>" + target.getAddress());
        }
        nCode.add("; FAC to (X/Y)");
        nCode.add("JSR FACMEM");
    }
}

