/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.cbmnative.mos6502.generators;

import com.sixtyfour.cbmnative.GeneratorContext;
import com.sixtyfour.cbmnative.Operand;
import com.sixtyfour.cbmnative.Operands;
import com.sixtyfour.cbmnative.mos6502.generators.GeneratorBase;
import com.sixtyfour.elements.Type;
import java.util.List;
import java.util.Map;

public class Mov
extends GeneratorBase {
    private static int MOV_CNT = 0;

    @Override
    public String getMnemonic() {
        return "MOV";
    }

    @Override
    public void generateCode(GeneratorContext context, String line, List<String> nCode, List<String> subCode, Map<String, String> name2label) {
        Operands ops = new Operands(line, name2label);
        Operand source = ops.getSource();
        Operand target = ops.getTarget();
        context.setLastMoveSource(source);
        context.setLastMoveTarget(target);
        if (!source.isIndexed() && !target.isIndexed()) {
            if (source.getType() == Type.STRING) {
                if (source.isArray()) {
                    this.sourceStringArray(nCode, source, target);
                } else {
                    this.sourceString(nCode, source, target);
                }
            } else if (target.getType() == Type.STRING) {
                this.targetString(nCode, source, target);
            } else if (source.isArray()) {
                this.noIndexArraySource(nCode, source, target);
            } else if (source.getType() == Type.INTEGER) {
                this.noIndexIntegerSource(nCode, source, target);
            } else {
                this.noIndexRealSource(nCode, source, target);
            }
        } else if (target.getType() == Type.INTEGER) {
            this.indexedTargetInteger(nCode, source, target);
        } else if (source.isIndexed() && source.isRegister()) {
            this.indexedSourceTargetReal(nCode, source, target);
        } else {
            throw new RuntimeException("Invalid index mode: " + line);
        }
    }

    private void targetString(List<String> nCode, Operand source, Operand target) {
        if (source.isRegister()) {
            nCode.add("LDA " + source.getRegisterName());
            nCode.add("LDY " + this.createAddress(source.getRegisterName(), 1));
        } else {
            nCode.add("LDA " + source.getAddress());
            nCode.add("LDY " + this.createAddress(source.getAddress(), 1));
        }
        nCode.add("STA TMP_ZP");
        nCode.add("STY TMP_ZP+1");
        if (!this.checkSpecialWriteVarsString(nCode, target)) {
            if (target.isRegister()) {
                nCode.add("LDA #<" + target.getRegisterName());
                nCode.add("LDY #>" + target.getRegisterName());
            } else {
                nCode.add("LDA #<" + target.getAddress());
                nCode.add("LDY #>" + target.getAddress());
            }
            nCode.add("JSR COPYSTRING");
        }
    }

    private void sourceString(List<String> nCode, Operand source, Operand target) {
        if (source.isConstant()) {
            nCode.add("LDA #<" + source.getAddress());
            nCode.add("LDY #>" + source.getAddress());
        } else {
            this.checkSpecialReadVars(nCode, source);
            nCode.add("LDA " + source.getAddress());
            nCode.add("LDY " + this.createAddress(source.getAddress(), 1));
        }
        nCode.add("STA " + target.getRegisterName());
        nCode.add("STY " + this.createAddress(target.getRegisterName(), 1));
    }

    private void sourceStringArray(List<String> nCode, Operand source, Operand target) {
        if (source.isConstant()) {
            nCode.add("LDA #<" + source.getAddress());
            nCode.add("LDY #>" + source.getAddress());
        } else {
            this.checkSpecialReadVars(nCode, source);
            nCode.add("LDA #<" + source.getAddress());
            nCode.add("LDY #>" + source.getAddress());
        }
        nCode.add("STA " + target.getRegisterName());
        nCode.add("STY " + this.createAddress(target.getRegisterName(), 1));
    }

    private void noIndexArraySource(List<String> nCode, Operand source, Operand target) {
        if (source.isRegister()) {
            nCode.add("LDA #<" + source.getRegisterName());
            nCode.add("LDY #>" + source.getRegisterName());
        } else {
            nCode.add("LDA #<" + source.getAddress());
            nCode.add("LDY #>" + source.getAddress());
        }
        if (target.isRegister()) {
            nCode.add("STA " + target.getRegisterName());
            nCode.add("STY " + this.createAddress(target.getRegisterName(), 1));
        } else {
            nCode.add("STA " + target.getAddress());
            nCode.add("STY " + this.createAddress(target.getAddress(), 1));
        }
    }

    private void indexedTargetInteger(List<String> nCode, Operand source, Operand target) {
        if (source.isRegister()) {
            nCode.add("LDA #<" + source.getRegisterName());
            nCode.add("LDY #>" + source.getRegisterName());
        } else {
            nCode.add("LDA #<" + source.getAddress());
            nCode.add("LDY #>" + source.getAddress());
        }
        if (target.isRegister()) {
            nCode.add("STA " + target.getRegisterName());
            nCode.add("STY " + this.createAddress(target.getRegisterName(), 1));
        } else {
            nCode.add("STA " + target.getAddress());
            nCode.add("STY " + this.createAddress(target.getAddress(), 1));
        }
    }

    private void indexedSourceTargetReal(List<String> nCode, Operand source, Operand target) {
        if (source.isRegister()) {
            nCode.add("LDA #<" + source.getRegisterName());
            nCode.add("LDY #>" + source.getRegisterName());
        } else {
            nCode.add("LDA #<" + source.getAddress());
            nCode.add("LDY #>" + source.getAddress());
        }
        nCode.add("; Real in (A/Y) to FAC");
        nCode.add("JSR REALFAC");
        nCode.add("JSR FACWORD");
        String lab = "MOVSELF" + MOV_CNT++;
        nCode.add("STY " + lab + "+1");
        nCode.add("STA " + lab + "+2");
        nCode.add(String.valueOf(lab) + ":");
        nCode.add("LDA $FFFF");
        nCode.add("TAY");
        nCode.add("LDA #0");
        if (target.getType() == Type.REAL) {
            nCode.add("; integer in Y/A to FAC");
            nCode.add("JSR INTFAC");
            if (target.isRegister()) {
                nCode.add("LDX #<" + target.getRegisterName());
                nCode.add("LDY #>" + target.getRegisterName());
            } else {
                nCode.add("LDX #<" + target.getAddress());
                nCode.add("LDY #>" + target.getAddress());
            }
            nCode.add("; FAC to (X/Y)");
            nCode.add("JSR FACMEM");
        } else if (target.isRegister()) {
            nCode.add("STY " + target.getRegisterName());
            nCode.add("STA " + this.createAddress(target.getRegisterName(), 1));
        } else {
            nCode.add("STY " + target.getAddress());
            nCode.add("STA " + this.createAddress(target.getAddress(), 1));
        }
    }

    private void noIndexRealSource(List<String> nCode, Operand source, Operand target) {
        if (source.isRegister()) {
            nCode.add("LDA #<" + source.getRegisterName());
            nCode.add("LDY #>" + source.getRegisterName());
        } else {
            this.checkSpecialReadVars(nCode, source);
            nCode.add("LDA #<" + source.getAddress());
            nCode.add("LDY #>" + source.getAddress());
        }
        nCode.add("; Real in (A/Y) to FAC");
        nCode.add("JSR REALFAC");
        if (!this.checkSpecialWriteVarsReal(nCode, target)) {
            if (target.getType() == Type.INTEGER) {
                nCode.add("; FAC to integer in Y/A");
                nCode.add("JSR FACINT");
                if (target.isRegister()) {
                    nCode.add("STY " + target.getRegisterName());
                    nCode.add("STA " + this.createAddress(target.getRegisterName(), 1));
                } else {
                    nCode.add("STY " + target.getAddress());
                    nCode.add("STA " + this.createAddress(target.getAddress(), 1));
                }
            } else {
                if (target.isRegister()) {
                    nCode.add("LDX #<" + target.getRegisterName());
                    nCode.add("LDY #>" + target.getRegisterName());
                } else {
                    nCode.add("LDX #<" + target.getAddress());
                    nCode.add("LDY #>" + target.getAddress());
                }
                nCode.add("; FAC to (X/Y)");
                nCode.add("JSR FACMEM");
            }
        }
    }

    private void noIndexIntegerSource(List<String> nCode, Operand source, Operand target) {
        if (source.isRegister()) {
            nCode.add("LDY " + source.getRegisterName());
            nCode.add("LDA " + this.createAddress(source.getRegisterName(), 1));
        } else {
            nCode.add("LDY " + source.getAddress());
            nCode.add("LDA " + this.createAddress(source.getAddress(), 1));
        }
        if (target.getType() == Type.INTEGER) {
            if (target.isRegister()) {
                nCode.add("STY " + target.getRegisterName());
                nCode.add("STA " + this.createAddress(target.getRegisterName(), 1));
            } else {
                nCode.add("STY " + target.getAddress());
                nCode.add("STA " + this.createAddress(target.getAddress(), 1));
            }
        } else {
            nCode.add("; integer in Y/A to FAC");
            nCode.add("JSR INTFAC");
            if (!this.checkSpecialWriteVarsReal(nCode, target)) {
                if (target.isRegister()) {
                    nCode.add("LDX #<" + target.getRegisterName());
                    nCode.add("LDY #>" + target.getRegisterName());
                } else {
                    nCode.add("LDX #<" + target.getAddress());
                    nCode.add("LDY #>" + target.getAddress());
                }
                nCode.add("; FAC to (X/Y)");
                nCode.add("JSR FACMEM");
            }
        }
    }
}

