/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.cbmnative.mos6502.generators;

import com.sixtyfour.cbmnative.GeneratorContext;
import com.sixtyfour.cbmnative.Operand;
import com.sixtyfour.cbmnative.Operands;
import com.sixtyfour.cbmnative.mos6502.generators.GeneratorBase;
import com.sixtyfour.elements.Type;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Movb
extends GeneratorBase {
    protected static int MOV_CNT = 0;

    @Override
    public String getMnemonic() {
        return "MOVB";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void generateCode(GeneratorContext context, String line, List<String> nCode, List<String> subCode, Map<String, String> name2label) {
        Operands ops = new Operands(line, name2label);
        ++MOV_CNT;
        Operand source = ops.getSource();
        Operand target = ops.getTarget();
        context.setLastMoveSource(source);
        context.setLastMoveTarget(target);
        if (!source.isIndexed() && !target.isIndexed()) {
            if (source.getType() == Type.INTEGER) {
                this.noIndexIntegerSource(nCode, source, target);
                return;
            } else {
                this.noIndexRealSource(nCode, source, target);
            }
            return;
        } else {
            if (target.isIndexed() && source.isIndexed()) {
                throw new RuntimeException("Invalid index mode (both sides are indexed!): " + line);
            }
            if (!target.isRegister() || !source.isRegister()) {
                if (!target.isRegister() || !source.isConstant()) throw new RuntimeException("Invalid index mode (at least one side isn't a register and source isn't a constant value either!): " + line);
                this.indexedTargetWithConstant(nCode, source, target);
                return;
            } else if (target.isIndexed()) {
                this.indexedTarget(nCode, source, target);
                return;
            } else {
                this.indexedSource(nCode, source, target);
            }
        }
    }

    protected void indexedSource(List<String> nCode, Operand source, Operand target) {
        this.createIndexedSourceCode(nCode, source);
        if (target.getType() == Type.INTEGER) {
            nCode.add("MOVBSELF" + MOV_CNT + ":");
            nCode.add("LDA $FFFF");
            nCode.add("STA " + target.getRegisterName());
            nCode.add("STY " + this.createAddress(target.getRegisterName(), 1));
        } else {
            nCode.add("MOVBSELF" + MOV_CNT + ":");
            nCode.add("LDY $FFFF");
            nCode.add("LDA #0");
            nCode.add("; integer in Y/A to FAC");
            nCode.add("JSR INTFAC");
            nCode.add("LDX #<" + target.getRegisterName());
            nCode.add("LDY #>" + target.getRegisterName());
            nCode.add("; FAC to (X/Y)");
            nCode.add("JSR FACMEM");
        }
    }

    protected void createIndexedSourceCode(List<String> nCode, Operand source) {
        if (source.getType() == Type.INTEGER) {
            nCode.add("LDY " + source.getRegisterName());
            nCode.add("LDA " + this.createAddress(source.getRegisterName(), 1));
            nCode.add("STY TMP_REG");
            nCode.add("STA TMP_REG+1");
        } else {
            nCode.add("LDA #<" + source.getRegisterName());
            nCode.add("LDY #>" + source.getRegisterName());
            nCode.add("; Real in (A/Y) to FAC");
            nCode.add("JSR REALFAC");
            nCode.add("; FAC to integer in Y/A");
            nCode.add("JSR FACWORD");
            String lab = "MOVBSELF" + MOV_CNT;
            nCode.add("STY " + lab + "+1");
            nCode.add("STA " + lab + "+2");
        }
    }

    private void indexedTargetWithConstant(List<String> nCode, Operand source, Operand target) {
        this.createIndexedTargetCode(nCode, target);
        nCode.add("LDA #$" + Integer.toHexString((int)Float.parseFloat(source.getValue().substring(1))).toUpperCase(Locale.ENGLISH));
        nCode.add("MOVBSELF" + MOV_CNT + ":");
        nCode.add("STA $FFFF");
    }

    private void indexedTarget(List<String> nCode, Operand source, Operand target) {
        this.createIndexedTargetCode(nCode, target);
        if (source.getType() == Type.INTEGER) {
            nCode.add("LDA " + source.getRegisterName());
            nCode.add("MOVBSELF" + MOV_CNT + ":");
            nCode.add("STA $FFFF");
        } else {
            nCode.add("LDA #<" + source.getRegisterName());
            nCode.add("LDY #>" + source.getRegisterName());
            nCode.add("; Real in (A/Y) to FAC");
            nCode.add("JSR REALFAC");
            nCode.add("; FAC to integer in Y/A");
            nCode.add("JSR FACWORD");
            nCode.add("MOVBSELF" + MOV_CNT + ":");
            nCode.add("STY $FFFF");
        }
    }

    private void createIndexedTargetCode(List<String> nCode, Operand target) {
        if (target.getType() == Type.INTEGER) {
            nCode.add("LDY " + target.getRegisterName());
            nCode.add("LDA " + this.createAddress(target.getRegisterName(), 1));
            nCode.add("STY TMP_REG");
            nCode.add("STA TMP_REG+1");
        } else {
            nCode.add("LDA #<" + target.getRegisterName());
            nCode.add("LDY #>" + target.getRegisterName());
            nCode.add("; Real in (A/Y) to FAC");
            nCode.add("JSR REALFAC");
            nCode.add("; FAC to integer in Y/A");
            nCode.add("JSR FACWORD");
            String lab = "MOVBSELF" + MOV_CNT;
            nCode.add("STY " + lab + "+1");
            nCode.add("STA " + lab + "+2");
        }
    }

    private void noIndexRealSource(List<String> nCode, Operand source, Operand target) {
        if (source.isRegister()) {
            nCode.add("LDA #<" + source.getRegisterName());
            nCode.add("LDY #>" + source.getRegisterName());
        } else {
            this.checkSpecialReadVars(nCode, source);
            nCode.add("LDA #<" + source.getAddress());
            nCode.add("LDY #>" + source.getAddress());
        }
        nCode.add("; Real in (A/Y) to FAC");
        nCode.add("JSR REALFAC");
        if (target.isAddress()) {
            nCode.add("; FAC to integer in Y/A");
            nCode.add("JSR FACWORD");
            this.addStoreCommand(nCode, target);
        } else if (target.getType() == Type.INTEGER) {
            nCode.add("; FAC to integer in Y/A");
            nCode.add("JSR FACWORD");
            nCode.add("STY " + target.getRegisterName());
            nCode.add("STA " + this.createAddress(target.getRegisterName(), 1));
        } else {
            nCode.add("LDX #<" + target.getRegisterName());
            nCode.add("LDY #>" + target.getRegisterName());
            nCode.add("; FAC to (X/Y)");
            nCode.add("JSR FACMEM");
        }
    }

    private void noIndexIntegerSource(List<String> nCode, Operand source, Operand target) {
        if (source.isRegister()) {
            nCode.add("LDY " + source.getRegisterName());
            nCode.add("LDA #0");
        } else {
            nCode.add("LDY " + source.getAddress());
            nCode.add("LDA #0");
        }
        if (target.getType() == Type.INTEGER) {
            this.addStoreCommand(nCode, target);
        } else {
            nCode.add("; integer in Y/A to FAC");
            nCode.add("JSR INTFAC");
            if (target.isAddress()) {
                nCode.add("; FAC to integer in Y/A");
                nCode.add("JSR FACWORD");
                this.addStoreCommand(nCode, target);
            } else if (target.getType() == Type.INTEGER) {
                nCode.add("; FAC to integer in Y/A");
                nCode.add("JSR FACWORD");
                nCode.add("STY " + target.getRegisterName());
                nCode.add("STA " + this.createAddress(target.getRegisterName(), 1));
            } else {
                nCode.add("LDX #<" + target.getRegisterName());
                nCode.add("LDY #>" + target.getRegisterName());
                nCode.add("; FAC to (X/Y)");
                nCode.add("JSR FACMEM");
            }
        }
    }

    private void addStoreCommand(List<String> nCode, Operand target) {
        String addr = target.getAddress();
        if (!addr.contains(":")) {
            nCode.add("STY " + addr);
        } else {
            String[] as = addr.split(":");
            nCode.add("STY " + as[0].trim());
            nCode.add("STA " + as[1].trim());
        }
    }
}

