/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.cbmnative.mos6502.generators;

import com.sixtyfour.cbmnative.GeneratorContext;
import com.sixtyfour.cbmnative.Operand;
import com.sixtyfour.cbmnative.Operands;
import com.sixtyfour.cbmnative.mos6502.generators.Calculation;
import java.util.List;
import java.util.Map;

public class Shr
extends Calculation {
    public Shr() {
        super("SHR", "; FAC = FAC>>A", "JSR SHR");
    }

    protected Shr(String mnemonic, String comment, String systemCall) {
        super(mnemonic, comment, systemCall);
    }

    @Override
    public void generateCode(GeneratorContext context, String line, List<String> nCode, List<String> subCode, Map<String, String> name2label) {
        Operands ops = new Operands(line, name2label);
        Operand target = ops.getTarget();
        if (target.isRegister()) {
            nCode.add("LDA #<" + target.getRegisterName());
            nCode.add("LDY #>" + target.getRegisterName());
        } else {
            nCode.add("LDA #<" + target.getAddress());
            nCode.add("LDY #>" + target.getAddress());
        }
        nCode.add("; Real in (A/Y) to FAC");
        nCode.add("JSR REALFAC");
        nCode.add(this.comment);
        nCode.add(this.systemCall);
        if (target.isRegister()) {
            nCode.add("LDX #<" + target.getRegisterName());
            nCode.add("LDY #>" + target.getRegisterName());
        } else {
            nCode.add("LDX #<" + target.getAddress());
            nCode.add("LDY #>" + target.getAddress());
        }
        nCode.add("; FAC to (X/Y)");
        nCode.add("JSR FACMEM");
    }
}

