/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.cbmnative.mos6502.vic20;

import com.sixtyfour.Loader;
import com.sixtyfour.Logger;
import com.sixtyfour.cbmnative.PlatformProvider;
import com.sixtyfour.cbmnative.mos6502.AbstractTransformer;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.config.MemoryConfig;
import com.sixtyfour.system.Machine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Transformer20
extends AbstractTransformer {
    public Transformer20() {
        this.variableStart = -1;
        this.runtimeStart = -1;
        this.stringMemoryEnd = 0;
        this.startAddress = 4632;
        this.preferZeropage = true;
    }

    @Override
    public List<String> transform(CompilerConfig config, MemoryConfig memConfig, Machine machine, PlatformProvider platform, List<String> code) {
        Logger.log("Compiling into native assembly code...");
        ArrayList<String> res = new ArrayList<String>();
        ArrayList<String> consts = new ArrayList<String>();
        ArrayList<String> vars = new ArrayList<String>();
        ArrayList<String> mnems = new ArrayList<String>();
        ArrayList<String> subs = new ArrayList<String>();
        mnems.add("; *** CODE ***");
        if (this.runtimeStart != -1) {
            subs.add("*=$" + Integer.toHexString(this.runtimeStart));
        }
        subs.add("; *** SUBROUTINES ***");
        subs.addAll(Arrays.asList(Loader.loadProgram(this.getClass().getResourceAsStream("/subroutines.asm"))));
        AbstractTransformer.addExtensionSubroutines(subs, "asm");
        consts.add("; *** CONSTANTS ***");
        if (this.variableStart >= 0) {
            consts.add("*=$" + Integer.toHexString(this.variableStart));
        }
        consts.add("CONSTANTS");
        vars.add("; *** VARIABLES ***");
        vars.add("VARIABLES");
        this.addExtensionConstants(res);
        res.add("SGNFAC = $DC2B");
        res.add("MEMARG = $DA8C");
        res.add("ARGADD = $D86A");
        res.add("ARGAND = $CFE9");
        res.add("ARGDIV = $DB14");
        res.add("FACMUL = $DA30");
        res.add("MEMMUL = $DA28");
        res.add("FACADD = $D867");
        res.add("FACLOG = $D9EA");
        res.add("FACSQR = $DF71");
        res.add("FACEXPCALL = $DFED");
        res.add("FACABS = $DC58");
        res.add("FACSIN = $E268");
        res.add("FACCOS = $E261");
        res.add("FACTAN = $E2B1");
        res.add("FACATN = $E30B");
        res.add("FACSIG = $DC39");
        res.add("FACNOT = $CED4");
        res.add("FACRND = $E094");
        res.add("FACWORD = $D7F7");
        res.add("FACDIV = $DB0F");
        res.add("BASINT = $DCCC");
        res.add("FACPOW = $DF7B");
        res.add("FACSUB = $D853");
        res.add("MEMSUB = $D850");
        res.add("FACOR = $CFE6");
        res.add("FACMEM = $DBD7");
        res.add("ARGFAC = $DBFC");
        res.add("FACARG = $DC0C");
        res.add("FACSTR = $DDDF");
        res.add("FACINT = $D1AA");
        res.add("RNDFAC = $DC1B");
        res.add("REALFAC = $DBA2");
        res.add("INTFAC = $D391");
        res.add("WRITETIS = $C9E7");
        res.add("GETTI = $DE68");
        res.add("GETTIME = $CF7E");
        res.add("COPYTIME = $CF87");
        res.add("TI2FAC = $CF84");
        res.add("CHROUT = $FFD2");
        res.add("PRINTSTRS = $CB25");
        res.add("VALS = $D7B5");
        res.add("CMPFAC = $DC5B");
        res.add("BYTEFAC = $D3A2");
        res.add("CRSRPOS = $FFF0");
        res.add("CRSRRIGHT = $CB3B");
        res.add("GETIN = $FFE4");
        res.add("INPUT = $C560");
        res.add("OPENCH = $FFC0");
        res.add("CLOSECH = $FFC3");
        res.add("CHKIN = $FFC6");
        res.add("CHKOUT = $FFC9");
        res.add("CLRCH = $FFCC");
        res.add("LOADXX = $FFD5");
        res.add("SAVEXX = $FFD8");
        res.add("TWAIT = $FFE1");
        res.add("ERRALL = $C437");
        res.add("ERRIQ = $D248");
        res.add("ERREI = $CCF4");
        res.add("ERRSYN = $CF08");
        res.add("ERRFNF = $F1E2");
        this.addMemoryLocations(res);
        this.addBasicBuffer(res, platform, memConfig);
        res.add("TMP_ZP = 105");
        res.add("TMP2_ZP = 107");
        res.add("TMP3_ZP = 34");
        res.add(";make sure that JUMP_TARGET's low can't be $ff");
        res.add("JUMP_TARGET = 69");
        if (this.preferZeropage) {
            res.add("TMP_REG=71");
            res.add("G_REG=73");
        }
        res.add("*=" + this.startAddress);
        res.add("TSX");
        res.add("STX SP_SAVE");
        this.addStructures(config, memConfig, machine, platform, code, res, consts, vars, mnems, subs);
        return res;
    }
}

