/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.cbmnative.mos6502.x16;

import com.sixtyfour.Loader;
import com.sixtyfour.Logger;
import com.sixtyfour.cbmnative.PlatformProvider;
import com.sixtyfour.cbmnative.mos6502.AbstractTransformer;
import com.sixtyfour.cbmnative.mos6502.StringAdder;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.config.MemoryConfig;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.rommap.CallMapper;
import com.sixtyfour.util.rommap.Mapping;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class TransformerX16
extends AbstractTransformer {
    public TransformerX16() {
        this.variableStart = -1;
        this.runtimeStart = -1;
        this.stringMemoryEnd = 0;
        this.startAddress = 2072;
        this.preferZeropage = true;
    }

    @Override
    public List<String> transform(CompilerConfig config, MemoryConfig memConfig, Machine machine, PlatformProvider platform, List<String> code) {
        Logger.log("Compiling into native assembly code...");
        ArrayList<String> res = new ArrayList<String>();
        ArrayList<String> consts = new ArrayList<String>();
        ArrayList<String> vars = new ArrayList<String>();
        ArrayList<String> mnems = new ArrayList<String>();
        ArrayList<String> subs = new ArrayList<String>();
        mnems.add("; *** CODE ***");
        if (this.runtimeStart != -1) {
            subs.add("*=$" + Integer.toHexString(this.runtimeStart));
        }
        subs.add("; *** SUBROUTINES ***");
        subs.addAll(Arrays.asList(Loader.loadProgram(this.getClass().getResourceAsStream("/subroutines.asm"))));
        AbstractTransformer.addExtensionSubroutines(subs, "asm");
        consts.add("; *** CONSTANTS ***");
        if (this.variableStart >= 0) {
            consts.add("*=$" + Integer.toHexString(this.variableStart));
        }
        consts.add("CONSTANTS");
        vars.add("; *** VARIABLES ***");
        vars.add("VARIABLES");
        this.addExtensionConstants(res);
        Mapping mapping = CallMapper.mapCalls(config, false);
        Map<String, String> calls = mapping.getMap();
        calls.forEach((k, v) -> {
            boolean bl = res.add(String.valueOf(k) + " = " + v);
        });
        this.addMemoryLocations(res);
        this.addBasicBuffer(res, platform, memConfig);
        res.add("TMP_ZP = 96");
        res.add("TMP2_ZP = 101");
        res.add("TMP3_ZP = 106");
        res.add(";make sure that JUMP_TARGET's low can't be $ff");
        res.add("JUMP_TARGET = 111");
        if (this.preferZeropage) {
            res.add("TMP_REG=116");
            res.add("G_REG=121");
        }
        res.add("TMP_BANK=95");
        res.add("*=" + this.startAddress);
        res.add("TSX");
        res.add("STX SP_SAVE");
        this.addStructures(config, memConfig, machine, platform, code, res, consts, vars, mnems, subs, mapping.getFarCalls(), new StringAdder(){

            @Override
            public void addStringVars(List<String> strVars) {
                if (!strVars.contains("; VAR: DA$")) {
                    strVars.add("; VAR: DA$");
                    strVars.add("VAR_DA$ .WORD EMPTYSTR");
                }
            }
        });
        return res;
    }

    @Override
    protected void addMemoryLocations(List<String> res) {
        Logger.log("Adding additional runtime labels...");
        String[] labels = Loader.loadProgram(TransformerX16.class.getResourceAsStream("/rommap/memloc-x16.map"));
        this.addLabels(res, labels);
    }
}

