/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.cbmnative.mos6502.x16;

import com.sixtyfour.cbmnative.Operand;
import java.util.List;

public interface X16Defaults {
    default public void checkSpecialReadVarsX16(List<String> nCode, Operand source) {
        String addr = source.getAddress();
        boolean add = false;
        if (addr.equals("VAR_MX")) {
            X16Defaults.addMouseGet(nCode);
            nCode.add("LDY MOUSE_STORE");
            nCode.add("LDA MOUSE_STORE+1");
            add = true;
        } else if (addr.equals("VAR_MY")) {
            X16Defaults.addMouseGet(nCode);
            nCode.add("LDY MOUSE_STORE+2");
            nCode.add("LDA MOUSE_STORE+3");
            add = true;
        } else if (addr.equals("VAR_MB")) {
            X16Defaults.addMouseGet(nCode);
            nCode.add("TAY");
            nCode.add("LDA #0");
            add = true;
        } else if (addr.equals("VAR_DA$")) {
            nCode.add("JSR READDAD");
        }
        if (add) {
            nCode.add("JSR INTFAC");
            nCode.add("LDX #<" + addr);
            nCode.add("LDY #>" + addr);
            nCode.add("JSR FACMEM");
        }
    }

    default public boolean checkSpecialWriteVarsStringX16(List<String> nCode, Operand target) {
        if (target.getAddress().equals("VAR_DA$")) {
            nCode.add("JSR WRITEDAD");
            return true;
        }
        return false;
    }

    public static void addMouseGet(List<String> nCode) {
        nCode.add("LDX #MOUSE_STORE");
        nCode.add("JSR mouse_get");
    }
}

