/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.cbmnative.mos6502.x16.generators;

import com.sixtyfour.cbmnative.Operand;
import com.sixtyfour.cbmnative.mos6502.generators.Movb;
import com.sixtyfour.cbmnative.mos6502.x16.X16Defaults;
import com.sixtyfour.elements.Type;
import java.util.List;

public class MovbX
extends Movb
implements X16Defaults {
    @Override
    protected void indexedSource(List<String> nCode, Operand source, Operand target) {
        this.createIndexedSourceCode(nCode, source);
        if (target.getType() == Type.INTEGER) {
            nCode.add("MOVBSELF" + MOV_CNT + ":");
            nCode.add("LDA $FFFF");
            nCode.add("STA " + target.getRegisterName());
            nCode.add("STY " + this.createAddress(target.getRegisterName(), 1));
            nCode.add("PLA");
            nCode.add("STA ROMSELECT");
        } else {
            nCode.add("MOVBSELF" + MOV_CNT + ":");
            nCode.add("LDY $FFFF");
            nCode.add("PLA");
            nCode.add("STA ROMSELECT");
            nCode.add("LDA #0");
            nCode.add("; integer in Y/A to FAC");
            nCode.add("JSR INTFAC");
            nCode.add("LDX #<" + target.getRegisterName());
            nCode.add("LDY #>" + target.getRegisterName());
            nCode.add("; FAC to (X/Y)");
            nCode.add("JSR FACMEM");
        }
    }

    @Override
    protected void createIndexedSourceCode(List<String> nCode, Operand source) {
        super.createIndexedSourceCode(nCode, source);
        nCode.add("LDA ROMSELECT");
        nCode.add("PHA");
        nCode.add("LDA #0");
        nCode.add("STA ROMSELECT");
    }

    @Override
    protected void checkSpecialReadVars(List<String> nCode, Operand source) {
        super.checkSpecialReadVars(nCode, source);
        this.checkSpecialReadVarsX16(nCode, source);
    }

    @Override
    protected boolean checkSpecialWriteVarsString(List<String> nCode, Operand target) {
        boolean ret = super.checkSpecialWriteVarsString(nCode, target);
        if (!ret) {
            ret = this.checkSpecialWriteVarsStringX16(nCode, target);
        }
        return ret;
    }
}

