/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements;

import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.List;

public class Constant<T>
implements Atom {
    private T value;
    private Type type;

    public Constant(T value) {
        this.value = value;
        if (VarUtils.isInteger(value)) {
            this.type = Type.INTEGER;
        } else if (VarUtils.isFloat(value)) {
            this.type = Type.REAL;
        } else if (VarUtils.isDouble(value)) {
            this.type = Type.REAL;
        } else if (VarUtils.isString(value)) {
            this.type = Type.STRING;
        } else {
            throw new RuntimeException("Type mismatch error: " + value);
        }
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("#" + this.value.toString() + "{" + (Object)((Object)this.type) + "}");
        ArrayList<CodeContainer> cc = new ArrayList<CodeContainer>();
        cc.add(new CodeContainer(ret));
        return cc;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Constant) {
            if (o == this) {
                return true;
            }
            return this.value.equals(((Constant)o).value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Type getType(boolean ignoreMt) {
        return this.type;
    }

    public T eval(Machine machine) {
        return this.value;
    }

    @Override
    public boolean isTerm() {
        return false;
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public String toCode(Machine machine) {
        if (VarUtils.isInteger(this.value)) {
            return String.valueOf(VarUtils.getInt(this.value));
        }
        if (VarUtils.isFloat(this.value)) {
            return String.valueOf(VarUtils.getFloat(this.value));
        }
        if (VarUtils.isDouble(this.value)) {
            return String.valueOf(VarUtils.getDouble(this.value));
        }
        if (VarUtils.isString(this.value)) {
            return "\"" + this.value.toString() + "\"";
        }
        throw new RuntimeException("Type mismatch error: " + this.value);
    }

    @Override
    public boolean isConstant() {
        return true;
    }
}

