/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements;

import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.commands.Command;
import com.sixtyfour.elements.commands.CommandList;
import com.sixtyfour.elements.functions.Function;
import com.sixtyfour.elements.functions.FunctionList;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.IntegerC;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Variable
implements Atom {
    private String name;
    private String upperCaseName;
    private Type type;
    private boolean array = false;
    private Object value;
    private int[] dimensions;
    private boolean persistent = false;
    private boolean constant = false;
    private boolean system = false;

    public Variable(String name, List<Object> values, int ... dimensions) {
        this(name, values == null ? Variable.createEmptyArray(dimensions) : values);
        this.dimensions = dimensions;
        this.array = true;
        this.setName(name.endsWith("[]") ? name : String.valueOf(name) + "[]");
    }

    public Variable(String name, Object value) {
        String un = VarUtils.toUpper(name);
        List<Command> commands = CommandList.getCommands();
        for (Command command : commands) {
            if (!un.contains(command.getName())) continue;
            throw new RuntimeException("Syntax error: " + un);
        }
        List<Function> functions = FunctionList.getFunctions();
        for (Function function : functions) {
            if (!un.contains(function.getName())) continue;
            throw new RuntimeException("Syntax error: " + un);
        }
        if (!Character.isAlphabetic(un.charAt(0)) && un.equals("_")) {
            throw new RuntimeException("Syntax error: " + un);
        }
        String woa = name.replace("[]", "");
        char c = woa.charAt(woa.length() - 1);
        this.type = null;
        this.findType(c);
        if (this.type == null) {
            if (!Character.isAlphabetic(c) && !Character.isDigit(c)) {
                throw new RuntimeException("Syntax error: " + name + "/" + woa);
            }
            throw new RuntimeException("Unknown variable type for: " + name + "/" + woa);
        }
        if (value == null) {
            if (this.type == Type.STRING) {
                value = "";
            }
            if (this.type == Type.INTEGER) {
                value = 0;
            }
            if (this.type == Type.REAL) {
                value = Float.valueOf(0.0f);
            }
        }
        if (!name.startsWith("_")) {
            StringBuilder sb = new StringBuilder();
            int alphaCount = 0;
            int i = 0;
            while (i < name.length()) {
                char cc = name.charAt(i);
                if (Character.isLetter(cc) || Character.isDigit(cc)) {
                    if (++alphaCount <= 2) {
                        sb.append(cc);
                    }
                } else {
                    sb.append(cc);
                }
                ++i;
            }
            name = sb.toString();
        }
        this.setName(name);
        this.setValue(value);
    }

    private void findType(char c) {
        if (c == '$') {
            this.type = Type.STRING;
        } else if (c == '%') {
            this.type = Type.INTEGER;
        } else if (Character.isLetter(c) || Character.isDigit(c)) {
            this.type = Type.REAL;
        }
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(String.valueOf(this.upperCaseName.toString()) + "{" + (Object)((Object)this.type) + "}");
        ArrayList<CodeContainer> cc = new ArrayList<CodeContainer>();
        cc.add(new CodeContainer(ret));
        return cc;
    }

    public void clear() {
        if (this.array) {
            List vals = (List)this.value;
            vals.clear();
            int i = 0;
            while (i < Variable.calcSize(this.dimensions)) {
                if (this.type == Type.STRING) {
                    vals.add("");
                }
                if (this.type == Type.INTEGER) {
                    vals.add(0);
                }
                if (this.type == Type.REAL) {
                    vals.add(Float.valueOf(0.0f));
                }
                ++i;
            }
        } else {
            if (this.type == Type.STRING) {
                this.value = "";
            }
            if (this.type == Type.INTEGER) {
                this.value = 0;
            }
            if (this.type == Type.REAL) {
                this.value = Float.valueOf(0.0f);
            }
        }
    }

    public boolean isArray() {
        return this.array;
    }

    public boolean isSupposedToBeArray() {
        return this.array || this.name.endsWith("[]");
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Type getType(boolean ignoreMT) {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.upperCaseName = VarUtils.toUpper(name);
    }

    public String getUpperCaseName() {
        return this.upperCaseName;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Variable) {
            if (o == this) {
                return true;
            }
            return this.name.equalsIgnoreCase(((Variable)o).name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        if (!this.array || this.value == null) {
            return String.valueOf(this.name) + "{" + this.value + "/" + this.isConstant() + "}";
        }
        return String.valueOf(this.name) + "{" + Arrays.toString(((List)this.value).toArray()) + "}";
    }

    public int elements() {
        if (!this.array) {
            return 1;
        }
        return ((List)this.value).size();
    }

    @Override
    public Object eval(Machine machine) {
        return this.value;
    }

    public Object evalFromCode() {
        return this.value;
    }

    public boolean isReadOnly() {
        return false;
    }

    public Object getValue() {
        if (this.array) {
            throw new RuntimeException("Not a simple type: " + this);
        }
        return this.value;
    }

    public void setValue(Object value) {
        if (this.array) {
            throw new RuntimeException("Not a simple type: " + this);
        }
        if (value == this.value || value.equals(this.value)) {
            return;
        }
        if (this.type == Type.INTEGER && (VarUtils.isFloat(value) || VarUtils.isDouble(value))) {
            value = IntegerC.valueOf(VarUtils.getInt(value));
        } else if (this.type == Type.REAL && VarUtils.isInteger(value)) {
            value = Float.valueOf(VarUtils.getFloat(value));
        }
        this.value = value;
    }

    public Object getInternalValue() {
        return this.value;
    }

    public Object getValue(int ... pos) {
        if (!this.array) {
            throw new RuntimeException("Not an array type: " + this);
        }
        int ap = 0;
        int cnt = 0;
        if (pos.length != this.dimensions.length) {
            throw new RuntimeException("Array indices don't match: " + this + "/" + pos.length + "/" + this.dimensions.length);
        }
        if (pos.length == 1) {
            ap = pos[0];
        } else {
            int m = 1;
            int[] nArray = pos;
            int n = pos.length;
            int n2 = 0;
            while (n2 < n) {
                int p = nArray[n2];
                ap += m * p;
                m *= this.dimensions[cnt] + 1;
                ++cnt;
                ++n2;
            }
        }
        return ((List)this.value).get(ap);
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    public Object setValue(Object val, int ... pos) {
        if (!this.array) {
            throw new RuntimeException("Not an array type: " + this);
        }
        int ap = 0;
        int cnt = 0;
        if (pos.length != this.dimensions.length) {
            throw new RuntimeException("Array indices don't match: " + this);
        }
        if (pos.length == 1) {
            ap = pos[0];
        } else {
            int m = 1;
            int[] nArray = pos;
            int n = pos.length;
            int n2 = 0;
            while (n2 < n) {
                int p = nArray[n2];
                ap += m * p;
                m *= this.dimensions[cnt] + 1;
                ++cnt;
                ++n2;
            }
        }
        if (this.type == Type.INTEGER && (VarUtils.isFloat(val) || VarUtils.isDouble(val))) {
            val = IntegerC.valueOf(VarUtils.getInt(val));
        } else if (this.type == Type.REAL && VarUtils.isInteger(val)) {
            val = Float.valueOf(VarUtils.getFloat(val));
        }
        List ovalue = (List)this.value;
        if (ap >= ovalue.size() || ap < 0) {
            throw new RuntimeException("Array index out of range: " + this.name + "(" + val + "/" + ovalue.size() + ")");
        }
        return ovalue.set(ap, val);
    }

    public float inc(float value) {
        if (this.type == Type.INTEGER) {
            int ret = (int)((float)VarUtils.getInt(this.value) + value);
            this.value = IntegerC.valueOf(ret);
            return ret;
        }
        if (this.type == Type.REAL) {
            float ret = VarUtils.getFloat(this.value) + value;
            this.value = Float.valueOf(ret);
            return ret;
        }
        throw new RuntimeException("Type mismatch error: " + this);
    }

    @Override
    public boolean isTerm() {
        return false;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    @Override
    public String toCode(Machine machine) {
        if (this.array) {
            return null;
        }
        machine.getJit().addVariable(this);
        String nam = VarUtils.relabel(this.name);
        if (this.type == Type.REAL) {
            return "((Number) " + nam + ".evalFromCode()).floatValue()";
        }
        if (this.type == Type.INTEGER) {
            return "((Number) " + nam + ".evalFromCode()).intValue()";
        }
        return String.valueOf(nam) + ".evalFromCode()";
    }

    public void setConstant(boolean constant) {
        this.constant = constant;
    }

    @Override
    public boolean isConstant() {
        return this.constant;
    }

    private static int calcSize(int[] dimensions) {
        int size = 1;
        int[] nArray = dimensions;
        int n = dimensions.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            size *= i + 1;
            ++n2;
        }
        return size;
    }

    private static Object createEmptyArray(int[] dimensions) {
        int size = Variable.calcSize(dimensions);
        ArrayList<Object> ret = new ArrayList<Object>(size);
        int i = 0;
        while (i < size) {
            ret.add(null);
            ++i;
        }
        return ret;
    }

    public boolean isSystem() {
        return this.system;
    }

    public void setSystem(boolean system) {
        this.system = system;
    }
}

