/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.commands;

import com.sixtyfour.cbmnative.NativeCompiler;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.Variable;
import com.sixtyfour.elements.commands.Command;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Term;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.BasicProgramCounter;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractCommand
implements Command {
    protected String name;
    protected Term term;
    protected int lineCnt = 0;
    protected int linePos = 0;
    protected int lineNumber = 0;

    private AbstractCommand() {
    }

    public AbstractCommand(String name) {
        this.name = VarUtils.toUpper(name);
    }

    @Override
    public Command cloneCommand() {
        try {
            AbstractCommand clone = (AbstractCommand)this.getClass().newInstance();
            clone.name = this.name;
            return clone;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate command: " + this.name);
        }
    }

    @Override
    public Type getType(boolean ignoreMt) {
        return this.getType();
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        throw new RuntimeException("Command " + this.getName() + " not implemented in native compiler!");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean keepSpaces() {
        return false;
    }

    @Override
    public Term getTerm() {
        return this.term;
    }

    @Override
    public List<Term> getAllTerms() {
        ArrayList<Term> ret = new ArrayList<Term>();
        ret.add(this.term);
        return ret;
    }

    @Override
    public void setTerm(Term term) {
        this.term = term;
    }

    @Override
    public boolean isCommand(String command) {
        return VarUtils.toUpper(command.trim()).startsWith(this.name);
    }

    public String toString() {
        return String.valueOf(this.name) + " @ " + this.lineNumber;
    }

    @Override
    public Type getType() {
        return null;
    }

    @Override
    public Object eval(Machine machine) {
        return null;
    }

    @Override
    public String parse(CompilerConfig config, String linePart, int lineCnt, int lineNumber, int linePos, boolean lastPos, Machine machine) {
        this.lineCnt = lineCnt;
        this.linePos = linePos;
        this.lineNumber = lineNumber;
        return null;
    }

    @Override
    public BasicProgramCounter execute(CompilerConfig config, Machine machine) {
        return null;
    }

    @Override
    public void stopExecution() {
    }

    @Override
    public boolean isTerm() {
        return false;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public String toCode(Machine machine) {
        return null;
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public boolean isOverride() {
        return false;
    }

    protected void typeMismatch(String line) {
        throw new RuntimeException("Type mismatch error: " + line);
    }

    protected void syntaxError(String line) {
        throw new RuntimeException("Syntax error: " + line);
    }

    protected List<String> addSingleParameter(CompilerConfig config, Machine machine, NativeCompiler compiler, List<Atom> pars) {
        List<String> expr = compiler.compileToPseudoCode(config, machine, pars.get(0));
        String expPush = this.getPushRegister(expr.get(expr.size() - 1));
        expr = expr.subList(0, expr.size() - 1);
        if (expPush.equals("Y")) {
            expr.add("MOV X,Y");
        }
        return expr;
    }

    protected List<CodeContainer> createSingleParameterCall(CompilerConfig config, Machine machine, List<Atom> pars, String callLabel) {
        NativeCompiler compiler = NativeCompiler.getCompiler();
        ArrayList<String> after = new ArrayList<String>();
        List<String> expr = null;
        ArrayList<String> before = new ArrayList<String>();
        expr = this.addSingleParameter(config, machine, compiler, pars);
        after.add("JSR " + callLabel);
        CodeContainer cc = new CodeContainer(before, expr, after);
        ArrayList<CodeContainer> ccs = new ArrayList<CodeContainer>();
        ccs.add(cc);
        return ccs;
    }

    protected void typeMismatch(Object obj) {
        this.typeMismatch(obj.toString());
    }

    protected void syntaxError(Object obj) {
        this.syntaxError(obj.toString());
    }

    protected List<String> saveC(List<String> expr) {
        if (expr.size() > 0 && expr.get(expr.size() - 1).equals("PUSH C")) {
            expr = expr.subList(0, expr.size() - 1);
        } else {
            expr.add("POP C");
        }
        return expr;
    }

    protected void checkTypes(List<Atom> params, String msg, Type ... types) {
        if (types == null) {
            return;
        }
        int max = Math.min(types.length, params.size());
        int i = 0;
        while (i < max) {
            if (types[i] != null && params.get(i).getType().equals((Object)types[i])) {
                this.typeMismatch(msg);
                break;
            }
            ++i;
        }
    }

    protected String getVariableLabel(CompilerConfig config, Machine machine, Variable variable) {
        List<CodeContainer> ccs = variable.evalToCode(config, machine);
        return ccs.get(0).getExpression().get(0);
    }

    protected String getPushRegister(String line) {
        if (line.startsWith("PUSH")) {
            line = line.substring(4).trim();
            return line;
        }
        return null;
    }
}

