/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.commands;

import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.commands.AbstractCommand;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.BasicProgramCounter;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.List;

public class Close
extends AbstractCommand {
    public Close() {
        super("CLOSE");
    }

    @Override
    public String parse(CompilerConfig config, String linePart, int lineCnt, int lineNumber, int linePos, boolean lastPos, Machine machine) {
        super.parse(config, linePart, lineCnt, lineNumber, linePos, lastPos, machine);
        this.term = Parser.getTerm(config, this, linePart, machine, true);
        List<Atom> pars = Parser.getParameters(this.term);
        if (pars.size() == 0) {
            this.syntaxError(this);
        }
        if (pars.size() > 1) {
            pars = pars.subList(0, 1);
        }
        this.checkTypes(pars, linePart, Type.STRING);
        return null;
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        List<Atom> pars = Parser.getParameters(this.term);
        return this.createSingleParameterCall(config, machine, pars, "CLOSE");
    }

    @Override
    public BasicProgramCounter execute(CompilerConfig config, Machine machine) {
        List<Atom> pars = Parser.getParameters(this.term);
        Atom fileNumber = pars.get(0);
        int fn = VarUtils.getInt(fileNumber.eval(machine));
        if (machine.getOutputChannel().getPrintConsumer() != null && machine.getOutputChannel().getChannel() == fn) {
            machine.getOutputChannel().setPrintConsumer(null, 0);
        }
        machine.getDeviceProvider().close(fn);
        return null;
    }
}

