/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.commands;

import com.sixtyfour.cbmnative.Util;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.commands.AbstractCommand;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.BasicProgramCounter;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.List;

public class Cmd
extends AbstractCommand {
    private Atom fileNumber = null;

    public Cmd() {
        super("CMD");
    }

    @Override
    public String parse(CompilerConfig config, String linePart, int lineCnt, int lineNumber, int linePos, boolean lastPos, Machine machine) {
        int pos = (linePart = linePart.substring(this.name.length())).indexOf(44);
        if (pos == -1) {
            pos = linePart.length();
        }
        this.term = Parser.getTerm(config, linePart.substring(0, pos), machine, false, true);
        linePart = pos != linePart.length() ? linePart.substring(pos + 1) : "";
        List<Atom> pars = Parser.getParameters(this.term);
        if (pars.size() != 1) {
            this.syntaxError(this);
        }
        this.fileNumber = pars.get(0);
        this.checkTypes(pars, linePart, Type.STRING);
        return "PRINT" + linePart;
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        int fn = VarUtils.getInt(this.fileNumber.eval(machine));
        return Util.createSingleCommand("MOV X,#" + fn + "{INTEGER}", "JSR CMD");
    }

    @Override
    public BasicProgramCounter execute(CompilerConfig config, Machine machine) {
        int fn = VarUtils.getInt(this.fileNumber.eval(machine));
        if (!machine.getDeviceProvider().isOpen(fn)) {
            throw new RuntimeException("File not open error: " + this);
        }
        machine.getOutputChannel().setPrintConsumer(machine.getDeviceProvider(), fn);
        return null;
    }
}

