/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.commands;

import com.sixtyfour.elements.commands.Close;
import com.sixtyfour.elements.commands.Clr;
import com.sixtyfour.elements.commands.Cmd;
import com.sixtyfour.elements.commands.Command;
import com.sixtyfour.elements.commands.Cont;
import com.sixtyfour.elements.commands.Data;
import com.sixtyfour.elements.commands.Def;
import com.sixtyfour.elements.commands.Dim;
import com.sixtyfour.elements.commands.End;
import com.sixtyfour.elements.commands.For;
import com.sixtyfour.elements.commands.Get;
import com.sixtyfour.elements.commands.GetFile;
import com.sixtyfour.elements.commands.Gosub;
import com.sixtyfour.elements.commands.Goto;
import com.sixtyfour.elements.commands.If;
import com.sixtyfour.elements.commands.Input;
import com.sixtyfour.elements.commands.InputFile;
import com.sixtyfour.elements.commands.Let;
import com.sixtyfour.elements.commands.Load;
import com.sixtyfour.elements.commands.Lst;
import com.sixtyfour.elements.commands.New;
import com.sixtyfour.elements.commands.Next;
import com.sixtyfour.elements.commands.On;
import com.sixtyfour.elements.commands.Open;
import com.sixtyfour.elements.commands.Poke;
import com.sixtyfour.elements.commands.Print;
import com.sixtyfour.elements.commands.PrintFile;
import com.sixtyfour.elements.commands.PrintShortcut;
import com.sixtyfour.elements.commands.Read;
import com.sixtyfour.elements.commands.Rem;
import com.sixtyfour.elements.commands.Restore;
import com.sixtyfour.elements.commands.Return;
import com.sixtyfour.elements.commands.Run;
import com.sixtyfour.elements.commands.Save;
import com.sixtyfour.elements.commands.Stop;
import com.sixtyfour.elements.commands.Sys;
import com.sixtyfour.elements.commands.Verify;
import com.sixtyfour.elements.commands.Wait;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class CommandList {
    private static List<Command> COMMANDS = Collections.unmodifiableList(new ArrayList<Command>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(new Let());
            this.add(new For());
            this.add(new If());
            this.add(new Goto());
            this.add(new Gosub());
            this.add(new Next());
            this.add(new Read());
            this.add(new Data());
            this.add(new Poke());
            this.add(new Sys());
            this.add(new Return());
            this.add(new PrintFile());
            this.add(new Print());
            this.add(new PrintShortcut());
            this.add(new Dim());
            this.add(new Rem());
            this.add(new End());
            this.add(new Stop());
            this.add(new New());
            this.add(new Lst());
            this.add(new Def());
            this.add(new GetFile());
            this.add(new Get());
            this.add(new On());
            this.add(new Wait());
            this.add(new Run());
            this.add(new Cont());
            this.add(new InputFile());
            this.add(new Input());
            this.add(new Restore());
            this.add(new Clr());
            this.add(new Open());
            this.add(new Close());
            this.add(new Cmd());
            this.add(new Load());
            this.add(new Save());
            this.add(new Verify());
        }
    });
    private static final Command LET = COMMANDS.get(0);

    public static void registerNewCommands(List<Command> commands) {
        if (commands != null && !commands.isEmpty()) {
            COMMANDS = new ArrayList<Command>(COMMANDS);
            Set newNames = commands.stream().filter(p -> p.isOverride()).map(p -> p.getName()).collect(Collectors.toSet());
            COMMANDS = COMMANDS.stream().filter(p -> !newNames.contains(p.getName())).collect(Collectors.toList());
            COMMANDS.addAll(commands);
            COMMANDS = Collections.unmodifiableList(COMMANDS);
            ArrayList<String> names = new ArrayList<String>();
            for (Command command : COMMANDS) {
                for (String name : names) {
                    if (!command.getName().startsWith(name)) continue;
                    throw new RuntimeException("Naming conflict: " + command.getClass() + " is hidden by " + name);
                }
                names.add(command.getName());
            }
        }
    }

    public static List<Command> getCommands() {
        return COMMANDS;
    }

    public static Command getLetCommand() {
        return LET;
    }
}

