/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.commands;

import com.sixtyfour.cbmnative.Util;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.commands.AbstractCommand;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.DataStore;
import com.sixtyfour.system.Machine;
import java.util.ArrayList;
import java.util.List;

public class Data
extends AbstractCommand {
    public Data() {
        super("DATA");
    }

    @Override
    public String parse(CompilerConfig config, String linePart, int lineCnt, int lineNumber, int linePos, boolean lastPos, Machine machine) {
        super.parse(config, linePart, lineCnt, lineNumber, linePos, lastPos, machine);
        List<String> parts = this.getParts(linePart.substring(4), lastPos);
        DataStore dataStore = machine.getDataStore();
        for (String part : parts) {
            if (config.isNonDecimalNumbersAware()) {
                if (part.startsWith("$")) {
                    part = String.valueOf(Integer.parseInt(part.substring(1), 16));
                } else if (part.startsWith("%")) {
                    part = String.valueOf(Integer.parseInt(part.substring(1), 2));
                }
            }
            dataStore.add(part);
        }
        return null;
    }

    @Override
    public boolean keepSpaces() {
        return true;
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        return Util.createNoCommand();
    }

    private List<String> getParts(String line, boolean lastPos) {
        ArrayList<String> res = new ArrayList<String>();
        boolean inString = false;
        StringBuilder sb = new StringBuilder();
        boolean hasQuotes = false;
        int i = 0;
        while (i < line.length()) {
            char c = line.charAt(i);
            if (inString || c != ' ' || sb.length() != 0) {
                String txt;
                if (c == '\"') {
                    if (sb.length() == 0) {
                        inString = true;
                        hasQuotes = true;
                        sb.append("{STRING}");
                    } else if (inString) {
                        inString = false;
                    } else {
                        sb.append(c);
                    }
                } else if (!inString) {
                    if (c == ',') {
                        inString = false;
                        txt = this.getText(sb, hasQuotes);
                        res.add(txt);
                        hasQuotes = false;
                    } else {
                        if (hasQuotes && c != ' ') {
                            this.syntaxError(this);
                        }
                        sb.append(c);
                    }
                } else {
                    sb.append(c);
                }
                if (i == line.length() - 1) {
                    inString = false;
                    txt = this.getText(sb, hasQuotes);
                    if (lastPos && !hasQuotes) {
                        txt = txt.replaceAll("\\s*$", "");
                    }
                    res.add(txt);
                    hasQuotes = false;
                }
            }
            ++i;
        }
        return res;
    }

    private String getText(StringBuilder sb, boolean hasQuotes) {
        String txt = sb.toString();
        sb.setLength(0);
        if (txt.isEmpty()) {
            txt = "\\0";
        }
        return txt;
    }
}

