/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.commands;

import com.sixtyfour.cbmnative.NativeCompiler;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.Variable;
import com.sixtyfour.elements.commands.AbstractCommand;
import com.sixtyfour.elements.commands.Command;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.TermEnhancer;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.BasicProgramCounter;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.List;

public class Def
extends AbstractCommand {
    private static int DEF_COUNT = 0;
    private String varName = null;
    private String fnName = null;
    private int count = 0;

    public Def() {
        super("DEF");
    }

    @Override
    public Type getType() {
        return this.term.getType();
    }

    @Override
    public String parse(CompilerConfig config, String linePart, int lineCnt, int lineNumber, int linePos, boolean lastPos, Machine machine) {
        super.parse(config, linePart, lineCnt, lineNumber, linePos, lastPos, machine);
        linePart = TermEnhancer.removeWhiteSpace(linePart);
        int pos = linePart.indexOf(40);
        int pos2 = linePart.indexOf(41);
        if (pos == -1 || pos2 == -1 || pos > pos2) {
            this.syntaxError(this);
        }
        this.fnName = VarUtils.toUpper(linePart.substring(3, pos));
        if (!this.fnName.startsWith("FN")) {
            this.syntaxError(this);
        }
        this.fnName = this.fnName.substring(2);
        if (this.fnName.length() > 2) {
            this.fnName = this.fnName.substring(0, 2);
        }
        this.varName = VarUtils.toUpper(linePart.substring(pos + 1, pos2));
        if (this.varName.length() == 0) {
            this.syntaxError(this);
        }
        if (linePart.length() < pos2 + 2 && linePart.charAt(pos2 + 1) != '=') {
            this.syntaxError(this);
        }
        String term = linePart.substring(pos2 + 2);
        StringBuilder sb = new StringBuilder();
        boolean inString = false;
        term = String.valueOf(term) + " ";
        String modTerm = VarUtils.toUpper(term).replace("OR", "##").replace("AND", "###").replace("NOT", "###");
        int i = 0;
        while (i < modTerm.length()) {
            char c = modTerm.charAt(i);
            if (c == '\"') {
                boolean bl = inString = !inString;
            }
            if (!inString) {
                if (Character.isLetter(c) || Character.isDigit(c)) {
                    sb.append(c);
                } else {
                    String tmp = VarUtils.toUpper(sb.toString());
                    if (tmp.equals(this.varName)) {
                        String add = "_" + this.varName + this.fnName;
                        term = String.valueOf(term.substring(0, i - this.varName.length())) + add + term.substring(i);
                        modTerm = String.valueOf(modTerm.substring(0, i - this.varName.length())) + add + modTerm.substring(i);
                        i += add.length() - 1;
                    }
                    sb.setLength(0);
                }
            }
            ++i;
        }
        this.varName = "_" + this.varName + this.fnName;
        this.term = Parser.getTerm(config, term, machine, false, true, null);
        machine.add(new Variable(this.varName, Float.valueOf(0.0f)));
        return null;
    }

    @Override
    public Object eval(Machine machine) {
        return this.term.eval(machine);
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        Command cmd = machine.getFunction(this.fnName);
        if (cmd != null && !cmd.getTerm().toString().equals(this.getTerm().toString())) {
            throw new RuntimeException("Redef'd function error: " + this.fnName + "/" + cmd.getTerm());
        }
        machine.setFunction(this.fnName, this);
        NativeCompiler compiler = NativeCompiler.getCompiler();
        ArrayList<String> after = new ArrayList<String>();
        List<String> expr = compiler.compileToPseudoCode(config, machine, this.term);
        ArrayList<String> before = new ArrayList<String>();
        this.count = DEF_COUNT++;
        String label = "DEF" + this.count;
        after.add("RTS");
        after.add("END" + label + ":");
        before.add("JMP END" + label);
        before.add(String.valueOf(label) + ":");
        before.add("POP X");
        before.add("MOV " + this.varName + "{REAL},X");
        CodeContainer cc = new CodeContainer(before, expr, after);
        ArrayList<CodeContainer> ccs = new ArrayList<CodeContainer>();
        ccs.add(cc);
        return ccs;
    }

    public String getVarName() {
        return this.varName;
    }

    @Override
    public BasicProgramCounter execute(CompilerConfig config, Machine machine) {
        machine.setFunction(this.fnName, this);
        return null;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }
}

