/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.commands;

import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.Variable;
import com.sixtyfour.elements.commands.AbstractCommand;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.Term;
import com.sixtyfour.parser.VariableAndTerms;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.BasicProgramCounter;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Dim
extends AbstractCommand {
    private List<Variable> vars;
    private Map<String, List<Atom>> terms;

    public Dim() {
        super("DIM");
    }

    public List<Variable> getVars() {
        return this.vars;
    }

    public void setVar(List<Variable> vars) {
        this.vars = vars;
    }

    @Override
    public Type getType() {
        return Type.NONE;
    }

    @Override
    public String parse(CompilerConfig config, String linePart, int lineCnt, int lineNumber, int linePos, boolean lastPos, Machine machine) {
        super.parse(config, linePart, lineCnt, lineNumber, linePos, lastPos, machine);
        List<VariableAndTerms> vars = Parser.getArrayVariables(config, linePart, machine);
        this.terms = new HashMap<String, List<Atom>>();
        this.vars = new ArrayList<Variable>();
        if (vars != null) {
            for (VariableAndTerms var : vars) {
                Variable vary = new Variable(var.getVarName(), null);
                this.vars.add(vary);
                this.terms.put(vary.getName(), var.getTerms());
            }
        }
        return null;
    }

    @Override
    public List<Term> getAllTerms() {
        ArrayList<Term> ret = new ArrayList<Term>();
        ret.add(this.term);
        Collection<List<Atom>> terms = this.terms.values();
        for (List<Atom> atoms : terms) {
            for (Atom atom : atoms) {
                if (atom instanceof Term) {
                    ret.add((Term)atom);
                    continue;
                }
                if (!(atom instanceof Variable)) continue;
                ret.add(new Term(atom));
            }
        }
        return ret;
    }

    @Override
    public BasicProgramCounter execute(CompilerConfig config, Machine machine) {
        int i = 0;
        while (i < this.vars.size()) {
            Variable var = this.vars.get(i);
            if (!var.isArray()) {
                List<Atom> pars = this.terms.get(var.getName());
                if (pars == null) {
                    throw new RuntimeException("Array dimensions missing @ line " + this.lineNumber + ": " + var.getName() + "/" + this);
                }
                int[] pis = new int[pars.size()];
                int cnt = 0;
                for (Atom par : pars) {
                    pis[cnt++] = VarUtils.getInt(par.eval(machine));
                }
                Variable vary = new Variable(var.getName(), null, pis);
                if (machine.getVariable(vary.getName()) != null) {
                    Variable av = machine.getVariable(vary.getName());
                    if (!av.isArray()) {
                        this.redimed(var);
                    } else {
                        int[] edims = av.getDimensions();
                        if (edims.length != pis.length) {
                            this.redimed(var);
                        }
                        int ii = 0;
                        while (ii < edims.length) {
                            if (edims[ii] != pis[ii]) {
                                this.redimed(var);
                            }
                            ++ii;
                        }
                    }
                }
                machine.add(vary);
                this.vars.set(i, vary);
                var = vary;
            }
            var.clear();
            ++i;
        }
        return null;
    }

    private void redimed(Variable var) {
        throw new RuntimeException("Redim'd array error @ line " + this.lineNumber + ": " + var.getName() + "/" + this);
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        this.execute(config, machine);
        int i = 0;
        while (i < this.vars.size()) {
            Variable var = this.vars.get(i);
            List<Atom> pars = this.terms.get(var.getName());
            for (Atom par : pars) {
                if (((Number)par.eval(machine)).intValue() != 0) continue;
                throw new RuntimeException("Arrays have to be defined static and can't have a zero size @ line " + this.lineNumber);
            }
            ++i;
        }
        return new ArrayList<CodeContainer>();
    }
}

