/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.commands;

import com.sixtyfour.cbmnative.NativeCompiler;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.commands.AbstractCommand;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.TermEnhancer;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.Machine;
import java.util.ArrayList;
import java.util.List;

public abstract class FileOperation
extends AbstractCommand {
    public FileOperation(String name) {
        super(name);
    }

    @Override
    public String parse(CompilerConfig config, String linePart, int lineCnt, int lineNumber, int linePos, boolean lastPos, Machine machine) {
        super.parse(config, linePart, lineCnt, lineNumber, linePos, lastPos, machine);
        linePart = TermEnhancer.removeWhiteSpace(linePart);
        linePart = linePart.substring(this.name.length());
        if (linePart.trim().isEmpty()) {
            linePart = "\"\"";
        }
        this.term = Parser.getTerm(config, linePart, machine, false, true);
        List<Atom> pars = Parser.getParameters(this.term);
        if (pars.size() > 0 && !pars.get(0).getType().equals((Object)Type.STRING)) {
            this.syntaxError(this);
        }
        if (pars.size() > 1 && pars.get(1).getType().equals((Object)Type.STRING)) {
            this.syntaxError(this);
        }
        if (pars.size() > 2 && pars.get(2).getType().equals((Object)Type.STRING)) {
            this.syntaxError(this);
        }
        return null;
    }

    protected boolean isLoad() {
        return false;
    }

    protected List<CodeContainer> evalToCode(CompilerConfig config, Machine machine, String call) {
        NativeCompiler compiler = NativeCompiler.getCompiler();
        ArrayList<String> after = new ArrayList<String>();
        ArrayList<String> expr = new ArrayList<String>();
        ArrayList<String> before = new ArrayList<String>();
        List<Atom> pars = Parser.getParameters(this.term);
        try {
            switch (pars.size()) {
                case 0: {
                    expr.addAll(compiler.compileToPseudoCode(config, machine, pars.get(0)));
                    expr.add("MOV G,#{STRING}");
                    after.add("MOV X,#1{INTEGER}");
                    after.add("MOV Y,#0{INTEGER}");
                    break;
                }
                case 1: {
                    expr.addAll(compiler.compileToPseudoCode(config, machine, pars.get(0)));
                    expr.add("POP G");
                    after.add("MOV X,#1{INTEGER}");
                    after.add("MOV Y,#0{INTEGER}");
                    break;
                }
                case 2: {
                    expr.addAll(compiler.compileToPseudoCode(config, machine, pars.get(0)));
                    expr.addAll(compiler.compileToPseudoCode(config, machine, pars.get(1)));
                    expr.add("POP X");
                    expr.add("POP G");
                    after.add("MOV Y,#0{INTEGER}");
                    break;
                }
                case 3: {
                    expr.addAll(compiler.compileToPseudoCode(config, machine, pars.get(0)));
                    expr.addAll(compiler.compileToPseudoCode(config, machine, pars.get(1)));
                    expr.addAll(compiler.compileToPseudoCode(config, machine, pars.get(2)));
                    expr.add("POP Y");
                    expr.add("POP X");
                    expr.add("POP G");
                    break;
                }
                default: {
                    this.syntaxError(this);
                    break;
                }
            }
        }
        catch (ClassCastException e) {
            this.syntaxError(this);
        }
        after.add("JSR " + call);
        if (this.isLoad()) {
            after.add("JMP RESTARTPRG");
        }
        CodeContainer cc = new CodeContainer(before, expr, after);
        ArrayList<CodeContainer> ccs = new ArrayList<CodeContainer>();
        ccs.add(cc);
        return ccs;
    }
}

